/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.Serializable;
import java.util.Objects;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;

public class BaseFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient FileStatus fileStatus;
    private final String fullPath;
    private long fileLen;

    public BaseFile(BaseFile dataFile) {
        this.fileStatus = dataFile.fileStatus;
        this.fullPath = dataFile.fullPath;
        this.fileLen = dataFile.fileLen;
    }

    public BaseFile(FileStatus fileStatus) {
        this.fileStatus = fileStatus;
        this.fullPath = fileStatus.getPath().toString();
        this.fileLen = fileStatus.getLen();
    }

    public BaseFile(String filePath) {
        this.fileStatus = null;
        this.fullPath = filePath;
        this.fileLen = -1L;
    }

    public String getPath() {
        return this.fullPath;
    }

    public String getFileName() {
        return new Path(this.fullPath).getName();
    }

    public FileStatus getFileStatus() {
        return this.fileStatus;
    }

    public long getFileSize() {
        return this.fileLen;
    }

    public void setFileLen(long fileLen) {
        this.fileLen = fileLen;
    }

    public long getFileLen() {
        return this.fileLen;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseFile dataFile = (BaseFile)o;
        return Objects.equals(this.fullPath, dataFile.fullPath);
    }

    public int hashCode() {
        return Objects.hash(this.fullPath);
    }

    public String toString() {
        return "BaseFile{fullPath=" + this.fullPath + ", fileLen=" + this.fileLen + '}';
    }
}

