/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.common;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.client.SparkTaskContextSupplier;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.data.HoodieAccumulator;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.EngineProperty;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.function.SerializableBiFunction;
import org.apache.hudi.common.function.SerializableConsumer;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.function.SerializablePairFlatMapFunction;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.data.HoodieJavaRDD;
import org.apache.hudi.data.HoodieSparkLongAccumulator;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.SQLContext;
import scala.Tuple2;

public class HoodieSparkEngineContext
extends HoodieEngineContext {
    private final JavaSparkContext javaSparkContext;
    private SQLContext sqlContext;

    public HoodieSparkEngineContext(JavaSparkContext jsc) {
        super(new SerializableConfiguration(jsc.hadoopConfiguration()), new SparkTaskContextSupplier());
        this.javaSparkContext = jsc;
        this.sqlContext = SQLContext.getOrCreate((SparkContext)jsc.sc());
    }

    public void setSqlContext(SQLContext sqlContext) {
        this.sqlContext = sqlContext;
    }

    public JavaSparkContext getJavaSparkContext() {
        return this.javaSparkContext;
    }

    public SQLContext getSqlContext() {
        return this.sqlContext;
    }

    public static JavaSparkContext getSparkContext(HoodieEngineContext context) {
        return ((HoodieSparkEngineContext)context).getJavaSparkContext();
    }

    @Override
    public HoodieAccumulator newAccumulator() {
        HoodieSparkLongAccumulator accumulator = HoodieSparkLongAccumulator.create();
        this.javaSparkContext.sc().register(accumulator.getAccumulator());
        return accumulator;
    }

    @Override
    public <T> HoodieData<T> emptyHoodieData() {
        return HoodieJavaRDD.of(this.javaSparkContext.emptyRDD());
    }

    @Override
    public <T> HoodieData<T> parallelize(List<T> data, int parallelism) {
        return HoodieJavaRDD.of(this.javaSparkContext.parallelize(data, parallelism));
    }

    @Override
    public <I, O> List<O> map(List<I> data, SerializableFunction<I, O> func, int parallelism) {
        return this.javaSparkContext.parallelize(data, parallelism).map(func::apply).collect();
    }

    @Override
    public <I, K, V> List<V> mapToPairAndReduceByKey(List<I> data, SerializablePairFunction<I, K, V> mapToPairFunc, SerializableBiFunction<V, V, V> reduceFunc, int parallelism) {
        return this.javaSparkContext.parallelize(data, parallelism).mapToPair((PairFunction & Serializable)input -> {
            Pair pair = mapToPairFunc.call(input);
            return new Tuple2(pair.getLeft(), pair.getRight());
        }).reduceByKey(reduceFunc::apply).map(Tuple2::_2).collect();
    }

    @Override
    public <I, K, V> Stream<ImmutablePair<K, V>> mapPartitionsToPairAndReduceByKey(Stream<I> data, SerializablePairFlatMapFunction<Iterator<I>, K, V> flatMapToPairFunc, SerializableBiFunction<V, V, V> reduceFunc, int parallelism) {
        return this.javaSparkContext.parallelize(data.collect(Collectors.toList()), parallelism).mapPartitionsToPair((PairFlatMapFunction & Serializable)iterator2 -> flatMapToPairFunc.call((Iterator)iterator2).collect(Collectors.toList()).stream().map(e -> new Tuple2(e.getKey(), e.getValue())).iterator()).reduceByKey(reduceFunc::apply).map((Function & Serializable)e -> new ImmutablePair<Object, Object>(e._1, e._2)).collect().stream();
    }

    @Override
    public <I, K, V> List<V> reduceByKey(List<Pair<K, V>> data, SerializableBiFunction<V, V, V> reduceFunc, int parallelism) {
        return this.javaSparkContext.parallelize(data, parallelism).mapToPair((PairFunction & Serializable)pair -> new Tuple2(pair.getLeft(), pair.getRight())).reduceByKey(reduceFunc::apply).map(Tuple2::_2).collect();
    }

    @Override
    public <I, O> List<O> flatMap(List<I> data, SerializableFunction<I, Stream<O>> func, int parallelism) {
        return this.javaSparkContext.parallelize(data, parallelism).flatMap((FlatMapFunction & Serializable)x -> ((Stream)func.apply(x)).iterator()).collect();
    }

    @Override
    public <I> void foreach(List<I> data, SerializableConsumer<I> consumer, int parallelism) {
        this.javaSparkContext.parallelize(data, parallelism).foreach(consumer::accept);
    }

    @Override
    public <I, K, V> Map<K, V> mapToPair(List<I> data, SerializablePairFunction<I, K, V> func, Integer parallelism) {
        if (Objects.nonNull(parallelism)) {
            return this.javaSparkContext.parallelize(data, parallelism.intValue()).mapToPair((PairFunction & Serializable)input -> {
                Pair pair = func.call(input);
                return new Tuple2(pair.getLeft(), pair.getRight());
            }).collectAsMap();
        }
        return this.javaSparkContext.parallelize(data).mapToPair((PairFunction & Serializable)input -> {
            Pair pair = func.call(input);
            return new Tuple2(pair.getLeft(), pair.getRight());
        }).collectAsMap();
    }

    @Override
    public void setProperty(EngineProperty key, String value) {
        if (key != EngineProperty.COMPACTION_POOL_NAME) {
            throw new HoodieException("Unknown engine property :" + (Object)((Object)key));
        }
        this.javaSparkContext.setLocalProperty("spark.scheduler.pool", value);
    }

    @Override
    public Option<String> getProperty(EngineProperty key) {
        if (key == EngineProperty.EMBEDDED_SERVER_HOST) {
            return Option.ofNullable(this.javaSparkContext.getConf().get("spark.driver.host", null));
        }
        throw new HoodieException("Unknown engine property :" + (Object)((Object)key));
    }

    @Override
    public void setJobStatus(String activeModule, String activityDescription) {
        this.javaSparkContext.setJobGroup(activeModule, activityDescription);
    }
}

