/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.clustering.update.strategy;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.table.action.cluster.strategy.UpdateStrategy;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;

public class SparkAllowUpdateStrategy<T extends HoodieRecordPayload<T>>
extends UpdateStrategy<T, JavaRDD<HoodieRecord<T>>> {
    public SparkAllowUpdateStrategy(HoodieSparkEngineContext engineContext, HashSet<HoodieFileGroupId> fileGroupsInPendingClustering) {
        super(engineContext, fileGroupsInPendingClustering);
    }

    private List<HoodieFileGroupId> getGroupIdsWithUpdate(JavaRDD<HoodieRecord<T>> inputRecords) {
        List fileGroupIdsWithUpdates = inputRecords.filter((Function & Serializable)record -> record.getCurrentLocation() != null).map((Function & Serializable)record -> new HoodieFileGroupId(record.getPartitionPath(), record.getCurrentLocation().getFileId())).distinct().collect();
        return fileGroupIdsWithUpdates;
    }

    @Override
    public Pair<JavaRDD<HoodieRecord<T>>, Set<HoodieFileGroupId>> handleUpdate(JavaRDD<HoodieRecord<T>> taggedRecordsRDD) {
        List<HoodieFileGroupId> fileGroupIdsWithRecordUpdate = this.getGroupIdsWithUpdate(taggedRecordsRDD);
        Set fileGroupIdsWithUpdatesAndPendingClustering = fileGroupIdsWithRecordUpdate.stream().filter(f -> this.fileGroupsInPendingClustering.contains(f)).collect(Collectors.toSet());
        return Pair.of(taggedRecordsRDD, fileGroupIdsWithUpdatesAndPendingClustering);
    }
}

