/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.client.AbstractHoodieWriteClient;
import org.apache.hudi.client.HoodieWriteResult;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.client.utils.TransactionUtils;
import org.apache.hudi.com.codahale.metrics.Timer;
import org.apache.hudi.common.HoodiePendingRollbackInfo;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.HoodieWrapperFileSystem;
import org.apache.hudi.common.metrics.Registry;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.TableServiceType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.data.HoodieJavaRDD;
import org.apache.hudi.exception.HoodieClusteringException;
import org.apache.hudi.exception.HoodieCommitException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.SparkHoodieIndexFactory;
import org.apache.hudi.metadata.SparkHoodieBackedTableMetadataWriter;
import org.apache.hudi.metrics.DistributedRegistry;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.compact.CompactHelpers;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.apache.hudi.table.upgrade.SparkUpgradeDowngradeHelper;
import org.apache.hudi.table.upgrade.UpgradeDowngrade;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;

public class SparkRDDWriteClient<T extends HoodieRecordPayload>
extends AbstractHoodieWriteClient<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> {
    private static final Logger LOG = LogManager.getLogger(SparkRDDWriteClient.class);

    public SparkRDDWriteClient(HoodieEngineContext context, HoodieWriteConfig clientConfig) {
        this(context, clientConfig, Option.empty());
    }

    @Deprecated
    public SparkRDDWriteClient(HoodieEngineContext context, HoodieWriteConfig writeConfig, boolean rollbackPending) {
        this(context, writeConfig, Option.empty());
    }

    @Deprecated
    public SparkRDDWriteClient(HoodieEngineContext context, HoodieWriteConfig writeConfig, boolean rollbackPending, Option<EmbeddedTimelineService> timelineService) {
        this(context, writeConfig, timelineService);
    }

    public SparkRDDWriteClient(HoodieEngineContext context, HoodieWriteConfig writeConfig, Option<EmbeddedTimelineService> timelineService) {
        super(context, writeConfig, timelineService);
    }

    public static SparkConf registerClasses(SparkConf conf) {
        conf.registerKryoClasses(new Class[]{HoodieWriteConfig.class, HoodieRecord.class, HoodieKey.class});
        return conf;
    }

    @Override
    protected HoodieIndex createIndex(HoodieWriteConfig writeConfig) {
        return SparkHoodieIndexFactory.createIndex(this.config);
    }

    @Override
    public boolean commit(String instantTime, JavaRDD<WriteStatus> writeStatuses, Option<Map<String, String>> extraMetadata, String commitActionType, Map<String, List<String>> partitionToReplacedFileIds) {
        List writeStats = writeStatuses.map(WriteStatus::getStat).collect();
        return this.commitStats(instantTime, writeStats, extraMetadata, commitActionType, partitionToReplacedFileIds);
    }

    @Override
    protected HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> createTable(HoodieWriteConfig config, Configuration hadoopConf, boolean refreshTimeline) {
        return HoodieSparkTable.create(config, this.context, refreshTimeline);
    }

    @Override
    public JavaRDD<HoodieRecord<T>> filterExists(JavaRDD<HoodieRecord<T>> hoodieRecords) {
        HoodieSparkTable table = HoodieSparkTable.create(this.config, this.context);
        Timer.Context indexTimer = this.metrics.getIndexCtx();
        JavaRDD recordsWithLocation = HoodieJavaRDD.getJavaRDD(this.getIndex().tagLocation((HoodieData<HoodieRecord<T>>)HoodieJavaRDD.of(hoodieRecords), this.context, (HoodieTable)table));
        this.metrics.updateIndexMetrics("lookup", this.metrics.getDurationInMs(indexTimer == null ? 0L : indexTimer.stop()));
        return recordsWithLocation.filter((Function & Serializable)v1 -> !v1.isCurrentLocationKnown());
    }

    @Override
    public void bootstrap(Option<Map<String, String>> extraMetadata) {
        this.getTableAndInitCtx(WriteOperationType.UPSERT, "00000000000001").bootstrap(this.context, extraMetadata);
    }

    @Override
    public JavaRDD<WriteStatus> upsert(JavaRDD<HoodieRecord<T>> records, String instantTime) {
        HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> table = this.getTableAndInitCtx(WriteOperationType.UPSERT, instantTime);
        table.validateUpsertSchema();
        this.preWrite(instantTime, WriteOperationType.UPSERT, table.getMetaClient());
        HoodieWriteMetadata<JavaRDD<WriteStatus>> result = table.upsert(this.context, instantTime, records);
        if (result.getIndexLookupDuration().isPresent()) {
            this.metrics.updateIndexMetrics("lookup", result.getIndexLookupDuration().get().toMillis());
        }
        return this.postWrite(result, instantTime, table);
    }

    @Override
    public JavaRDD<WriteStatus> upsertPreppedRecords(JavaRDD<HoodieRecord<T>> preppedRecords, String instantTime) {
        HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> table = this.getTableAndInitCtx(WriteOperationType.UPSERT_PREPPED, instantTime);
        table.validateUpsertSchema();
        this.preWrite(instantTime, WriteOperationType.UPSERT_PREPPED, table.getMetaClient());
        HoodieWriteMetadata<JavaRDD<WriteStatus>> result = table.upsertPrepped(this.context, instantTime, preppedRecords);
        return this.postWrite(result, instantTime, table);
    }

    @Override
    public JavaRDD<WriteStatus> insert(JavaRDD<HoodieRecord<T>> records, String instantTime) {
        HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> table = this.getTableAndInitCtx(WriteOperationType.INSERT, instantTime);
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.INSERT, table.getMetaClient());
        HoodieWriteMetadata<JavaRDD<WriteStatus>> result = table.insert(this.context, instantTime, records);
        return this.postWrite(result, instantTime, table);
    }

    @Override
    public JavaRDD<WriteStatus> insertPreppedRecords(JavaRDD<HoodieRecord<T>> preppedRecords, String instantTime) {
        HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> table = this.getTableAndInitCtx(WriteOperationType.INSERT_PREPPED, instantTime);
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.INSERT_PREPPED, table.getMetaClient());
        HoodieWriteMetadata<JavaRDD<WriteStatus>> result = table.insertPrepped(this.context, instantTime, preppedRecords);
        return this.postWrite(result, instantTime, table);
    }

    public HoodieWriteResult insertOverwrite(JavaRDD<HoodieRecord<T>> records, String instantTime) {
        HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> table = this.getTableAndInitCtx(WriteOperationType.INSERT_OVERWRITE, instantTime);
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.INSERT_OVERWRITE, table.getMetaClient());
        HoodieWriteMetadata<JavaRDD<WriteStatus>> result = table.insertOverwrite(this.context, instantTime, records);
        return new HoodieWriteResult(this.postWrite(result, instantTime, table), result.getPartitionToReplaceFileIds());
    }

    public HoodieWriteResult insertOverwriteTable(JavaRDD<HoodieRecord<T>> records, String instantTime) {
        HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> table = this.getTableAndInitCtx(WriteOperationType.INSERT_OVERWRITE_TABLE, instantTime);
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.INSERT_OVERWRITE_TABLE, table.getMetaClient());
        HoodieWriteMetadata<JavaRDD<WriteStatus>> result = table.insertOverwriteTable(this.context, instantTime, records);
        return new HoodieWriteResult(this.postWrite(result, instantTime, table), result.getPartitionToReplaceFileIds());
    }

    @Override
    public JavaRDD<WriteStatus> bulkInsert(JavaRDD<HoodieRecord<T>> records, String instantTime) {
        return this.bulkInsert(records, instantTime, Option.empty());
    }

    @Override
    public JavaRDD<WriteStatus> bulkInsert(JavaRDD<HoodieRecord<T>> records, String instantTime, Option<BulkInsertPartitioner<JavaRDD<HoodieRecord<T>>>> userDefinedBulkInsertPartitioner) {
        HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> table = this.getTableAndInitCtx(WriteOperationType.BULK_INSERT, instantTime);
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.BULK_INSERT, table.getMetaClient());
        HoodieWriteMetadata<JavaRDD<WriteStatus>> result = table.bulkInsert(this.context, instantTime, records, userDefinedBulkInsertPartitioner);
        return this.postWrite(result, instantTime, table);
    }

    @Override
    public JavaRDD<WriteStatus> bulkInsertPreppedRecords(JavaRDD<HoodieRecord<T>> preppedRecords, String instantTime, Option<BulkInsertPartitioner<JavaRDD<HoodieRecord<T>>>> bulkInsertPartitioner) {
        HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> table = this.getTableAndInitCtx(WriteOperationType.BULK_INSERT_PREPPED, instantTime);
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.BULK_INSERT_PREPPED, table.getMetaClient());
        HoodieWriteMetadata<JavaRDD<WriteStatus>> result = table.bulkInsertPrepped(this.context, instantTime, preppedRecords, bulkInsertPartitioner);
        return this.postWrite(result, instantTime, table);
    }

    @Override
    public JavaRDD<WriteStatus> delete(JavaRDD<HoodieKey> keys2, String instantTime) {
        HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> table = this.getTableAndInitCtx(WriteOperationType.DELETE, instantTime);
        this.preWrite(instantTime, WriteOperationType.DELETE, table.getMetaClient());
        HoodieWriteMetadata<JavaRDD<WriteStatus>> result = table.delete(this.context, instantTime, keys2);
        return this.postWrite(result, instantTime, table);
    }

    public HoodieWriteResult deletePartitions(List<String> partitions, String instantTime) {
        HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> table = this.getTableAndInitCtx(WriteOperationType.DELETE_PARTITION, instantTime);
        this.preWrite(instantTime, WriteOperationType.DELETE_PARTITION, table.getMetaClient());
        HoodieWriteMetadata result = table.deletePartitions(this.context, instantTime, partitions);
        return new HoodieWriteResult(this.postWrite((HoodieWriteMetadata<JavaRDD<WriteStatus>>)result, instantTime, table), result.getPartitionToReplaceFileIds());
    }

    @Override
    protected JavaRDD<WriteStatus> postWrite(HoodieWriteMetadata<JavaRDD<WriteStatus>> result, String instantTime, HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> hoodieTable) {
        if (result.getIndexLookupDuration().isPresent()) {
            this.metrics.updateIndexMetrics(this.getOperationType().name(), result.getIndexUpdateDuration().get().toMillis());
        }
        if (result.isCommitted()) {
            if (result.getFinalizeDuration().isPresent()) {
                this.metrics.updateFinalizeWriteMetrics(result.getFinalizeDuration().get().toMillis(), result.getWriteStats().get().size());
            }
            this.postCommit(hoodieTable, result.getCommitMetadata().get(), instantTime, Option.empty());
            this.emitCommitMetrics(instantTime, result.getCommitMetadata().get(), hoodieTable.getMetaClient().getCommitActionType());
        }
        return result.getWriteStatuses();
    }

    @Override
    public void commitCompaction(String compactionInstantTime, JavaRDD<WriteStatus> writeStatuses, Option<Map<String, String>> extraMetadata) throws IOException {
        HoodieSparkTable table = HoodieSparkTable.create(this.config, this.context);
        HoodieCommitMetadata metadata = CompactHelpers.getInstance().createCompactionMetadata(table, compactionInstantTime, HoodieJavaRDD.of(writeStatuses), this.config.getSchema());
        extraMetadata.ifPresent(m -> m.forEach(metadata::addMetadata));
        this.completeCompaction(metadata, writeStatuses, (HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>>)table, compactionInstantTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void completeCompaction(HoodieCommitMetadata metadata, JavaRDD<WriteStatus> writeStatuses, HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> table, String compactionCommitTime) {
        this.context.setJobStatus(this.getClass().getSimpleName(), "Collect compaction write status and commit compaction");
        List writeStats = writeStatuses.map(WriteStatus::getStat).collect();
        try {
            HoodieInstant compactionInstant = new HoodieInstant(HoodieInstant.State.INFLIGHT, "compaction", compactionCommitTime);
            this.txnManager.beginTransaction(Option.of(compactionInstant), Option.empty());
            this.finalizeWrite(table, compactionCommitTime, writeStats);
            this.writeTableMetadataForTableServices(table, metadata, compactionInstant);
            LOG.info((Object)("Committing Compaction " + compactionCommitTime + ". Finished with result " + metadata));
            CompactHelpers.getInstance().completeInflightCompaction(table, compactionCommitTime, metadata);
        }
        finally {
            this.txnManager.endTransaction();
        }
        WriteMarkersFactory.get(this.config.getMarkersType(), table, compactionCommitTime).quietDeleteMarkerDir(this.context, this.config.getMarkersDeleteParallelism());
        if (this.compactionTimer != null) {
            long durationInMs = this.metrics.getDurationInMs(this.compactionTimer.stop());
            try {
                this.metrics.updateCommitMetrics(HoodieActiveTimeline.parseDateFromInstantTime(compactionCommitTime).getTime(), durationInMs, metadata, "compaction");
            }
            catch (ParseException e) {
                throw new HoodieCommitException("Commit time is not of valid format. Failed to commit compaction " + this.config.getBasePath() + " at time " + compactionCommitTime, e);
            }
        }
        LOG.info((Object)("Compacted successfully on commit " + compactionCommitTime));
    }

    @Override
    protected JavaRDD<WriteStatus> compact(String compactionInstantTime, boolean shouldComplete) {
        HoodieSparkTable table = HoodieSparkTable.create(this.config, this.context, true);
        this.preWrite(compactionInstantTime, WriteOperationType.COMPACT, table.getMetaClient());
        HoodieTimeline pendingCompactionTimeline = table.getActiveTimeline().filterPendingCompactionTimeline();
        HoodieInstant inflightInstant = HoodieTimeline.getCompactionInflightInstant(compactionInstantTime);
        if (pendingCompactionTimeline.containsInstant(inflightInstant)) {
            table.rollbackInflightCompaction(inflightInstant);
            table.getMetaClient().reloadActiveTimeline();
        }
        this.compactionTimer = this.metrics.getCompactionCtx();
        HoodieWriteMetadata compactionMetadata = table.compact(this.context, compactionInstantTime);
        JavaRDD statuses = (JavaRDD)compactionMetadata.getWriteStatuses();
        if (shouldComplete && compactionMetadata.getCommitMetadata().isPresent()) {
            this.completeTableService(TableServiceType.COMPACT, compactionMetadata.getCommitMetadata().get(), (JavaRDD<WriteStatus>)statuses, table, compactionInstantTime);
        }
        return statuses;
    }

    @Override
    public HoodieWriteMetadata<JavaRDD<WriteStatus>> cluster(String clusteringInstant, boolean shouldComplete) {
        HoodieSparkTable table = HoodieSparkTable.create(this.config, this.context, this.config.isMetadataTableEnabled());
        this.preWrite(clusteringInstant, WriteOperationType.CLUSTER, table.getMetaClient());
        HoodieTimeline pendingClusteringTimeline = table.getActiveTimeline().filterPendingReplaceTimeline();
        HoodieInstant inflightInstant = HoodieTimeline.getReplaceCommitInflightInstant(clusteringInstant);
        if (pendingClusteringTimeline.containsInstant(inflightInstant)) {
            this.rollbackInflightClustering(inflightInstant, table);
            table.getMetaClient().reloadActiveTimeline();
        }
        this.clusteringTimer = this.metrics.getClusteringCtx();
        LOG.info((Object)("Starting clustering at " + clusteringInstant));
        HoodieWriteMetadata<JavaRDD<WriteStatus>> clusteringMetadata = table.cluster(this.context, clusteringInstant);
        JavaRDD statuses = (JavaRDD)clusteringMetadata.getWriteStatuses();
        if (shouldComplete && clusteringMetadata.getCommitMetadata().isPresent()) {
            this.completeTableService(TableServiceType.CLUSTER, clusteringMetadata.getCommitMetadata().get(), (JavaRDD<WriteStatus>)statuses, table, clusteringInstant);
        }
        return clusteringMetadata;
    }

    private void completeClustering(HoodieReplaceCommitMetadata metadata, JavaRDD<WriteStatus> writeStatuses, HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> table, String clusteringCommitTime) {
        List<HoodieWriteStat> writeStats = metadata.getPartitionToWriteStats().entrySet().stream().flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toList());
        if (writeStats.stream().mapToLong(s -> s.getTotalWriteErrors()).sum() > 0L) {
            throw new HoodieClusteringException("Clustering failed to write to files:" + writeStats.stream().filter(s -> s.getTotalWriteErrors() > 0L).map(s -> s.getFileId()).collect(Collectors.joining(",")));
        }
        try {
            HoodieInstant clusteringInstant = new HoodieInstant(HoodieInstant.State.INFLIGHT, "replacecommit", clusteringCommitTime);
            this.txnManager.beginTransaction(Option.of(clusteringInstant), Option.empty());
            this.finalizeWrite(table, clusteringCommitTime, writeStats);
            this.writeTableMetadataForTableServices(table, metadata, clusteringInstant);
            if (this.config.isLayoutOptimizationEnabled() && !this.config.getClusteringSortColumns().isEmpty()) {
                table.updateMetadataIndexes(this.context, writeStats, clusteringCommitTime);
            }
            LOG.info((Object)("Committing Clustering " + clusteringCommitTime + ". Finished with result " + metadata));
            table.getActiveTimeline().transitionReplaceInflightToComplete(HoodieTimeline.getReplaceCommitInflightInstant(clusteringCommitTime), Option.of(metadata.toJsonString().getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e2) {
            throw new HoodieClusteringException("unable to transition clustering inflight to complete: " + clusteringCommitTime, e2);
        }
        finally {
            this.txnManager.endTransaction();
        }
        WriteMarkersFactory.get(this.config.getMarkersType(), table, clusteringCommitTime).quietDeleteMarkerDir(this.context, this.config.getMarkersDeleteParallelism());
        if (this.clusteringTimer != null) {
            long durationInMs = this.metrics.getDurationInMs(this.clusteringTimer.stop());
            try {
                this.metrics.updateCommitMetrics(HoodieActiveTimeline.parseDateFromInstantTime(clusteringCommitTime).getTime(), durationInMs, metadata, "replacecommit");
            }
            catch (ParseException e3) {
                throw new HoodieCommitException("Commit time is not of valid format. Failed to commit compaction " + this.config.getBasePath() + " at time " + clusteringCommitTime, e3);
            }
        }
        LOG.info((Object)("Clustering successfully on commit " + clusteringCommitTime));
    }

    private void writeTableMetadataForTableServices(HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> table, HoodieCommitMetadata commitMetadata, HoodieInstant hoodieInstant) {
        boolean isTableServiceAction = table.isTableServiceAction(hoodieInstant.getAction());
        table.getMetadataWriter(hoodieInstant.getTimestamp()).ifPresent(w -> w.update(commitMetadata, hoodieInstant.getTimestamp(), isTableServiceAction));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> getTableAndInitCtx(WriteOperationType operationType, String instantTime) {
        HoodieTableMetaClient metaClient = this.createMetaClient(true);
        UpgradeDowngrade upgradeDowngrade = new UpgradeDowngrade(metaClient, this.config, this.context, SparkUpgradeDowngradeHelper.getInstance());
        try {
            this.txnManager.beginTransaction();
            if (upgradeDowngrade.needsUpgradeOrDowngrade(HoodieTableVersion.current())) {
                List<String> instantsToRollback = this.getInstantsToRollback(metaClient, HoodieFailedWritesCleaningPolicy.EAGER, Option.of(instantTime));
                Map<String, Option<HoodiePendingRollbackInfo>> pendingRollbacks = this.getPendingRollbackInfos(metaClient);
                instantsToRollback.forEach(entry -> pendingRollbacks.putIfAbsent((String)entry, Option.empty()));
                this.rollbackFailedWrites(pendingRollbacks, true);
                new UpgradeDowngrade(metaClient, this.config, this.context, SparkUpgradeDowngradeHelper.getInstance()).run(HoodieTableVersion.current(), instantTime);
                metaClient.reloadActiveTimeline();
                this.initializeMetadataTable(Option.of(instantTime));
            }
        }
        finally {
            this.txnManager.endTransaction();
        }
        metaClient.validateTableProperties(this.config.getProps(), operationType);
        return this.getTableAndInitCtx(metaClient, operationType, instantTime);
    }

    private void initializeMetadataTable(Option<String> inFlightInstantTimestamp) {
        if (this.config.isMetadataTableEnabled()) {
            SparkHoodieBackedTableMetadataWriter.create(this.context.getHadoopConf().get(), this.config, this.context, Option.empty(), inFlightInstantTimestamp);
        }
    }

    private void completeTableService(TableServiceType tableServiceType, HoodieCommitMetadata metadata, JavaRDD<WriteStatus> writeStatuses, HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> table, String commitInstant) {
        switch (tableServiceType) {
            case CLUSTER: {
                this.completeClustering((HoodieReplaceCommitMetadata)metadata, writeStatuses, table, commitInstant);
                break;
            }
            case COMPACT: {
                this.completeCompaction(metadata, writeStatuses, table, commitInstant);
                break;
            }
            default: {
                throw new IllegalArgumentException("This table service is not valid " + (Object)((Object)tableServiceType));
            }
        }
    }

    private HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> getTableAndInitCtx(HoodieTableMetaClient metaClient, WriteOperationType operationType, String instantTime) {
        HoodieSparkTable table;
        if (operationType == WriteOperationType.DELETE) {
            this.setWriteSchemaForDeletes(metaClient);
        }
        this.writeTimer = (table = HoodieSparkTable.create(this.config, (HoodieSparkEngineContext)this.context, metaClient, this.config.isMetadataTableEnabled())).getMetaClient().getCommitActionType().equals("commit") ? this.metrics.getCommitCtx() : this.metrics.getDeltaCommitCtx();
        table.getHoodieView().sync();
        return table;
    }

    @Override
    protected void preCommit(HoodieInstant inflightInstant, HoodieCommitMetadata metadata) {
        HoodieTable table = this.createTable(this.config, this.hadoopConf);
        TransactionUtils.resolveWriteConflictIfAny(table, this.txnManager.getCurrentTransactionOwner(), Option.of(metadata), this.config, this.txnManager.getLastCompletedTransactionOwner());
    }

    @Override
    protected void initWrapperFSMetrics() {
        if (this.config.isMetricsOn()) {
            Registry registryMeta;
            Registry registry;
            JavaSparkContext jsc = ((HoodieSparkEngineContext)this.context).getJavaSparkContext();
            if (this.config.isExecutorMetricsEnabled()) {
                registry = Registry.getRegistry(HoodieWrapperFileSystem.class.getSimpleName(), DistributedRegistry.class.getName());
                ((DistributedRegistry)registry).register(jsc);
                registryMeta = Registry.getRegistry(HoodieWrapperFileSystem.class.getSimpleName() + "MetaFolder", DistributedRegistry.class.getName());
                ((DistributedRegistry)registryMeta).register(jsc);
            } else {
                registry = Registry.getRegistry(HoodieWrapperFileSystem.class.getSimpleName());
                registryMeta = Registry.getRegistry(HoodieWrapperFileSystem.class.getSimpleName() + "MetaFolder");
            }
            HoodieWrapperFileSystem.setMetricsRegistry(registry, registryMeta);
        }
    }

    @Override
    protected void releaseResources() {
        ((HoodieSparkEngineContext)this.context).getJavaSparkContext().getPersistentRDDs().values().forEach(rdd -> rdd.unpersist());
    }
}

