/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.async;

import java.io.Serializable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class HoodieAsyncService
implements Serializable {
    private static final Logger LOG = LogManager.getLogger(HoodieAsyncService.class);
    private boolean started;
    private boolean shutdownRequested = false;
    private volatile boolean shutdown;
    private transient ExecutorService executor;
    private transient CompletableFuture future;
    private final boolean runInDaemonMode;
    private transient BlockingQueue<HoodieInstant> pendingInstants = new LinkedBlockingQueue<HoodieInstant>();
    private transient ReentrantLock queueLock = new ReentrantLock();
    private transient Condition consumed = this.queueLock.newCondition();

    protected HoodieAsyncService() {
        this(false);
    }

    protected HoodieAsyncService(boolean runInDaemonMode) {
        this.runInDaemonMode = runInDaemonMode;
    }

    protected boolean isShutdownRequested() {
        return this.shutdownRequested;
    }

    protected boolean isShutdown() {
        return this.shutdown;
    }

    public void waitForShutdown() throws ExecutionException, InterruptedException {
        try {
            this.future.get();
        }
        catch (ExecutionException ex) {
            LOG.error((Object)"Service shutdown with error", (Throwable)ex);
            throw ex;
        }
    }

    public void shutdown(boolean force) {
        if (!this.shutdownRequested || force) {
            this.shutdownRequested = true;
            if (this.executor != null) {
                if (force) {
                    this.executor.shutdownNow();
                } else {
                    this.executor.shutdown();
                    try {
                        this.executor.awaitTermination(24L, TimeUnit.HOURS);
                    }
                    catch (InterruptedException ie) {
                        LOG.error((Object)"Interrupted while waiting for shutdown", (Throwable)ie);
                    }
                }
            }
        }
    }

    public void start(Function<Boolean, Boolean> onShutdownCallback) {
        Pair<CompletableFuture, ExecutorService> res = this.startService();
        this.future = res.getKey();
        this.executor = res.getValue();
        this.started = true;
        this.monitorThreads(onShutdownCallback);
    }

    protected abstract Pair<CompletableFuture, ExecutorService> startService();

    private void monitorThreads(Function<Boolean, Boolean> onShutdownCallback) {
        LOG.info((Object)"Submitting monitor thread !!");
        Executors.newSingleThreadExecutor(r -> {
            Thread t = new Thread(r, "Monitor Thread");
            t.setDaemon(this.isRunInDaemonMode());
            return t;
        }).submit(() -> {
            boolean error = false;
            try {
                LOG.info((Object)"Monitoring thread(s) !!");
                this.future.get();
            }
            catch (ExecutionException ex) {
                LOG.error((Object)"Monitor noticed one or more threads failed. Requesting graceful shutdown of other threads", (Throwable)ex);
                error = true;
            }
            catch (InterruptedException ie) {
                LOG.error((Object)"Got interrupted Monitoring threads", (Throwable)ie);
                error = true;
            }
            finally {
                this.shutdown = true;
                if (null != onShutdownCallback) {
                    onShutdownCallback.apply(error);
                }
                this.shutdown(false);
            }
        });
    }

    public boolean isRunInDaemonMode() {
        return this.runInDaemonMode;
    }

    public void waitTillPendingAsyncServiceInstantsReducesTo(int numPending) throws InterruptedException {
        try {
            this.queueLock.lock();
            while (!this.isShutdown() && this.pendingInstants.size() > numPending) {
                this.consumed.await();
            }
        }
        finally {
            this.queueLock.unlock();
        }
    }

    public void enqueuePendingAsyncServiceInstant(HoodieInstant instant) {
        LOG.info((Object)("Enqueuing new pending clustering instant: " + instant.getTimestamp()));
        this.pendingInstants.add(instant);
    }

    HoodieInstant fetchNextAsyncServiceInstant() throws InterruptedException {
        LOG.info((Object)"Waiting for next instant upto 10 seconds");
        HoodieInstant instant = this.pendingInstants.poll(10L, TimeUnit.SECONDS);
        if (instant != null) {
            try {
                this.queueLock.lock();
                this.consumed.signal();
            }
            finally {
                this.queueLock.unlock();
            }
        }
        return instant;
    }
}

