/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.util.Threads;

@InterfaceAudience.Private
public class MultiHConnection {
    private static final Log LOG = LogFactory.getLog(MultiHConnection.class);
    private HConnection[] hConnections;
    private final Object hConnectionsLock = new Object();
    private int noOfConnections;
    private ExecutorService batchPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiHConnection(Configuration conf, int noOfConnections) throws IOException {
        this.noOfConnections = noOfConnections;
        Object object = this.hConnectionsLock;
        synchronized (object) {
            this.hConnections = new HConnection[noOfConnections];
            for (int i = 0; i < noOfConnections; ++i) {
                HConnection conn;
                this.hConnections[i] = conn = HConnectionManager.createConnection(conf);
            }
        }
        this.createBatchPool(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.hConnectionsLock;
        synchronized (object) {
            if (this.hConnections != null) {
                for (HConnection conn : this.hConnections) {
                    if (conn == null) continue;
                    try {
                        conn.close();
                    }
                    catch (IOException e) {
                        LOG.info((Object)"Got exception in closing connection", (Throwable)e);
                    }
                    finally {
                        conn = null;
                    }
                }
                this.hConnections = null;
            }
        }
        if (this.batchPool != null && !this.batchPool.isShutdown()) {
            this.batchPool.shutdown();
            try {
                if (!this.batchPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                    this.batchPool.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.batchPool.shutdownNow();
            }
        }
    }

    public <R> void processBatchCallback(List<? extends Row> actions, TableName tableName, Object[] results, Batch.Callback<R> callback) throws IOException {
        try {
            this.hConnections[ThreadLocalRandom.current().nextInt(this.noOfConnections)].processBatchCallback(actions, tableName, this.batchPool, results, callback);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.getMessage());
        }
    }

    private void createBatchPool(Configuration conf) {
        int maxThreads = conf.getInt("hbase.multihconnection.threads.max", 256);
        int coreThreads = conf.getInt("hbase.multihconnection.threads.core", 256);
        if (maxThreads == 0) {
            maxThreads = Runtime.getRuntime().availableProcessors() * 8;
        }
        if (coreThreads == 0) {
            coreThreads = Runtime.getRuntime().availableProcessors() * 8;
        }
        long keepAliveTime = conf.getLong("hbase.multihconnection.threads.keepalivetime", 60L);
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(maxThreads * conf.getInt("hbase.client.max.total.tasks", 100));
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(coreThreads, maxThreads, keepAliveTime, TimeUnit.SECONDS, workQueue, Threads.newDaemonThreadFactory("MultiHConnection-shared-"));
        tpe.allowCoreThreadTimeOut(true);
        this.batchPool = tpe;
    }
}

