/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hudi.org.apache.commons.codec.binary.Hex;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class MD5Hash {
    private static final Log LOG = LogFactory.getLog(MD5Hash.class);

    public static String getMD5AsHex(byte[] key) {
        return MD5Hash.getMD5AsHex(key, 0, key.length);
    }

    public static String getMD5AsHex(byte[] key, int offset, int length) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(key, offset, length);
            byte[] digest = md.digest();
            return new String(Hex.encodeHex(digest));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Error computing MD5 hash", e);
        }
    }
}

