/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.protobuf.Message;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ipc.AsyncCall;
import org.apache.hadoop.hbase.ipc.AsyncRpcChannel;
import org.apache.hadoop.hbase.ipc.FatalConnectionException;
import org.apache.hadoop.hbase.ipc.IPCUtil;
import org.apache.hadoop.hbase.ipc.RemoteWithExtrasException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.RPCProtos;
import org.apache.hadoop.ipc.RemoteException;

@InterfaceAudience.Private
public class AsyncServerResponseHandler
extends ChannelInboundHandlerAdapter {
    private final AsyncRpcChannel channel;

    public AsyncServerResponseHandler(AsyncRpcChannel channel) {
        this.channel = channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf inBuffer = (ByteBuf)msg;
        ByteBufInputStream in = new ByteBufInputStream(inBuffer);
        int totalSize = inBuffer.readableBytes();
        try {
            RPCProtos.ResponseHeader responseHeader = RPCProtos.ResponseHeader.parseDelimitedFrom((InputStream)in);
            int id = responseHeader.getCallId();
            AsyncCall call2 = this.channel.removePendingCall(id);
            if (call2 == null) {
                int readSoFar = IPCUtil.getTotalSizeWhenWrittenDelimited(new Message[]{responseHeader});
                int whatIsLeftToRead = totalSize - readSoFar;
                inBuffer.skipBytes(whatIsLeftToRead);
                return;
            }
            if (responseHeader.hasException()) {
                RPCProtos.ExceptionResponse exceptionResponse = responseHeader.getException();
                RemoteException re = this.createRemoteException(exceptionResponse);
                if (exceptionResponse.getExceptionClassName().equals(FatalConnectionException.class.getName())) {
                    this.channel.close(re);
                } else {
                    call2.setFailed((IOException)((Object)re));
                }
            } else {
                Message value = null;
                if (call2.responseDefaultType != null) {
                    Message.Builder builder = call2.responseDefaultType.newBuilderForType();
                    ProtobufUtil.mergeDelimitedFrom(builder, (InputStream)in);
                    value = builder.build();
                }
                CellScanner cellBlockScanner = null;
                if (responseHeader.hasCellBlockMeta()) {
                    int size = responseHeader.getCellBlockMeta().getLength();
                    byte[] cellBlock = new byte[size];
                    inBuffer.readBytes(cellBlock, 0, cellBlock.length);
                    cellBlockScanner = this.channel.client.createCellScanner(cellBlock);
                }
                call2.setSuccess(value, cellBlockScanner);
                call2.callStats.setResponseSizeBytes(totalSize);
            }
        }
        catch (IOException e) {
            this.channel.close(e);
        }
        finally {
            inBuffer.release();
        }
    }

    private RemoteException createRemoteException(RPCProtos.ExceptionResponse e) {
        String innerExceptionClassName = e.getExceptionClassName();
        boolean doNotRetry = e.getDoNotRetry();
        return e.hasHostname() ? new RemoteWithExtrasException(innerExceptionClassName, e.getStackTrace(), e.getHostname(), e.getPort(), doNotRetry) : new RemoteWithExtrasException(innerExceptionClassName, e.getStackTrace(), doNotRetry);
    }
}

