/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.rendering.markdown;

import io.javalin.core.util.OptionalDependency;
import io.javalin.core.util.Util;
import io.javalin.rendering.FileRenderer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0004H\u0007J&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/javalin/rendering/markdown/JavalinCommonmark;", "Lio/javalin/rendering/FileRenderer;", "()V", "parser", "Lorg/commonmark/parser/Parser;", "renderer", "Lorg/commonmark/renderer/html/HtmlRenderer;", "configure", "", "staticHtmlRenderer", "staticMarkdownParser", "render", "", "filePath", "model", "", "", "javalin"})
public final class JavalinCommonmark
implements FileRenderer {
    private static HtmlRenderer renderer;
    private static Parser parser;
    public static final JavalinCommonmark INSTANCE;

    @JvmStatic
    public static final void configure(@NotNull HtmlRenderer staticHtmlRenderer, @NotNull Parser staticMarkdownParser) {
        Intrinsics.checkParameterIsNotNull(staticHtmlRenderer, "staticHtmlRenderer");
        Intrinsics.checkParameterIsNotNull(staticMarkdownParser, "staticMarkdownParser");
        renderer = staticHtmlRenderer;
        parser = staticMarkdownParser;
    }

    @NotNull
    public String render(@NotNull String filePath, @NotNull Map<String, ? extends Object> model) {
        Parser parser;
        Intrinsics.checkParameterIsNotNull(filePath, "filePath");
        Intrinsics.checkParameterIsNotNull(model, "model");
        Util.INSTANCE.ensureDependencyPresent(OptionalDependency.COMMONMARK);
        HtmlRenderer htmlRenderer = renderer;
        if (htmlRenderer == null) {
            htmlRenderer = renderer = HtmlRenderer.builder().build();
        }
        if ((parser = JavalinCommonmark.parser) == null) {
            parser = Parser.builder().build();
        }
        JavalinCommonmark.parser = parser;
        URL uRL = JavalinCommonmark.class.getResource(filePath);
        Intrinsics.checkExpressionValueIsNotNull(uRL, "JavalinCommonmark::class\u2026ava.getResource(filePath)");
        URL uRL2 = uRL;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes(uRL2);
        String fileContent = new String(byArray, charset);
        HtmlRenderer htmlRenderer2 = renderer;
        if (htmlRenderer2 == null) {
            Intrinsics.throwNpe();
        }
        Parser parser2 = JavalinCommonmark.parser;
        if (parser2 == null) {
            Intrinsics.throwNpe();
        }
        String string = htmlRenderer2.render(parser2.parse(fileContent));
        Intrinsics.checkExpressionValueIsNotNull(string, "renderer!!.render(parser!!.parse(fileContent))");
        return string;
    }

    private JavalinCommonmark() {
    }

    static {
        JavalinCommonmark javalinCommonmark;
        INSTANCE = javalinCommonmark = new JavalinCommonmark();
    }
}

