/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.xspec;

import com.amazonaws.annotation.Beta;
import com.amazonaws.annotation.Immutable;
import com.amazonaws.services.dynamodbv2.xspec.ComparatorCondition;
import com.amazonaws.services.dynamodbv2.xspec.ExpressionSpecBuilder;
import com.amazonaws.services.dynamodbv2.xspec.IfNotExistsFunction;
import com.amazonaws.services.dynamodbv2.xspec.InCondition;
import com.amazonaws.services.dynamodbv2.xspec.LiteralOperand;
import com.amazonaws.services.dynamodbv2.xspec.PathOperand;
import com.amazonaws.services.dynamodbv2.xspec.SetAction;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

@Beta
@Immutable
public final class B
extends PathOperand {
    B(String path) {
        super(path);
    }

    public InCondition in(ByteBuffer ... values2) {
        LinkedList<LiteralOperand> list = new LinkedList<LiteralOperand>();
        for (ByteBuffer v : values2) {
            list.add(new LiteralOperand(v));
        }
        return new InCondition(this, list);
    }

    public InCondition in(byte[] ... values2) {
        LinkedList<LiteralOperand> list = new LinkedList<LiteralOperand>();
        for (byte[] v : values2) {
            list.add(new LiteralOperand(v));
        }
        return new InCondition(this, list);
    }

    public InCondition inByteBufferList(List<ByteBuffer> values2) {
        LinkedList<LiteralOperand> list = new LinkedList<LiteralOperand>();
        for (ByteBuffer v : values2) {
            list.add(new LiteralOperand(v));
        }
        return new InCondition(this, list);
    }

    public InCondition inBytesList(List<byte[]> values2) {
        LinkedList<LiteralOperand> list = new LinkedList<LiteralOperand>();
        for (byte[] v : values2) {
            list.add(new LiteralOperand(v));
        }
        return new InCondition(this, list);
    }

    public ComparatorCondition eq(B that) {
        return new ComparatorCondition("=", this, that);
    }

    public ComparatorCondition eq(ByteBuffer value) {
        return new ComparatorCondition("=", this, new LiteralOperand(value));
    }

    public ComparatorCondition ne(B that) {
        return new ComparatorCondition("<>", this, that);
    }

    public ComparatorCondition ne(ByteBuffer value) {
        return new ComparatorCondition("<>", this, new LiteralOperand(value));
    }

    public IfNotExistsFunction<B> ifNotExists(ByteBuffer defaultValue) {
        return new IfNotExistsFunction<B>(this, new LiteralOperand(defaultValue));
    }

    public IfNotExistsFunction<B> ifNotExists(B defaultValue) {
        return ExpressionSpecBuilder.if_not_exists(this, defaultValue);
    }

    public SetAction set(B source) {
        return new SetAction(this, source);
    }

    public SetAction set(ByteBuffer value) {
        return new SetAction(this, new LiteralOperand(value));
    }

    public SetAction set(byte[] value) {
        return new SetAction(this, new LiteralOperand(value));
    }

    public SetAction set(IfNotExistsFunction<B> ifNotExistsFunction) {
        return new SetAction(this, ifNotExistsFunction);
    }

    public ComparatorCondition eq(byte[] value) {
        return new ComparatorCondition("=", this, new LiteralOperand(value));
    }

    public ComparatorCondition ne(byte[] value) {
        return new ComparatorCondition("<>", this, new LiteralOperand(value));
    }

    public IfNotExistsFunction<B> ifNotExists(byte[] defaultValue) {
        return new IfNotExistsFunction<B>(this, new LiteralOperand(defaultValue));
    }
}

