/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerateStrategy;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerator;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardTypeConverters;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DynamoDBMapperFieldModel<T, V>
implements DynamoDBAutoGenerator<V>,
DynamoDBTypeConverter<AttributeValue, V> {
    private final Properties<V> properties;
    private final DynamoDBTypeConverter<AttributeValue, V> converter;
    private final DynamoDBAttributeType attributeType;
    private final Reflect<T, V> reflect;

    private DynamoDBMapperFieldModel(Builder<T, V> builder) {
        this.properties = ((Builder)builder).properties;
        this.converter = ((Builder)builder).converter;
        this.attributeType = ((Builder)builder).attributeType;
        this.reflect = ((Builder)builder).reflect;
    }

    @Deprecated
    public String getDynamoDBAttributeName() {
        return this.properties.attributeName();
    }

    @Deprecated
    public DynamoDBAttributeType getDynamoDBAttributeType() {
        return this.attributeType;
    }

    public final String name() {
        return this.properties.attributeName();
    }

    public final V get(T object) {
        return this.reflect.get(object);
    }

    public final void set(T object, V value) {
        this.reflect.set(object, value);
    }

    @Override
    public final DynamoDBAutoGenerateStrategy getGenerateStrategy() {
        if (this.properties.autoGenerator() != null) {
            return this.properties.autoGenerator().getGenerateStrategy();
        }
        return null;
    }

    @Override
    public final V generate(V currentValue) {
        return this.properties.autoGenerator().generate(currentValue);
    }

    @Override
    public final AttributeValue convert(V object) {
        return this.converter.convert(object);
    }

    @Override
    public final V unconvert(AttributeValue object) {
        return this.converter.unconvert(object);
    }

    public final AttributeValue getAndConvert(T object) {
        return this.convert((Object)this.get(object));
    }

    public final void unconvertAndSet(T object, AttributeValue value) {
        this.set(object, this.unconvert(value));
    }

    public final DynamoDBAttributeType attributeType() {
        return this.attributeType;
    }

    public final KeyType keyType() {
        return this.properties.keyType();
    }

    public final boolean versioned() {
        return this.properties.versioned();
    }

    public final List<String> globalSecondaryIndexNames(KeyType keyType) {
        if (this.properties.globalSecondaryIndexNames().containsKey((Object)keyType)) {
            return this.properties.globalSecondaryIndexNames().get((Object)keyType);
        }
        return Collections.emptyList();
    }

    public final List<String> localSecondaryIndexNames() {
        return this.properties.localSecondaryIndexNames();
    }

    public final boolean indexed() {
        return !this.properties.globalSecondaryIndexNames().isEmpty() || !this.properties.localSecondaryIndexNames().isEmpty();
    }

    public final Condition beginsWith(V value) {
        return new Condition().withComparisonOperator(ComparisonOperator.BEGINS_WITH).withAttributeValueList(new AttributeValue[]{this.convert((Object)value)});
    }

    public final Condition between(V lo, V hi) {
        return new Condition().withComparisonOperator(ComparisonOperator.BETWEEN).withAttributeValueList(new AttributeValue[]{this.convert((Object)lo), this.convert((Object)hi)});
    }

    public final Condition contains(V value) {
        return new Condition().withComparisonOperator(ComparisonOperator.CONTAINS).withAttributeValueList(new AttributeValue[]{this.convert((Object)value)});
    }

    public final Condition eq(V value) {
        return new Condition().withComparisonOperator(ComparisonOperator.EQ).withAttributeValueList(new AttributeValue[]{this.convert((Object)value)});
    }

    public final Condition ge(V value) {
        return new Condition().withComparisonOperator(ComparisonOperator.GE).withAttributeValueList(new AttributeValue[]{this.convert((Object)value)});
    }

    public final Condition gt(V value) {
        return new Condition().withComparisonOperator(ComparisonOperator.GT).withAttributeValueList(new AttributeValue[]{this.convert((Object)value)});
    }

    public final Condition in(Collection<V> values2) {
        return new Condition().withComparisonOperator(ComparisonOperator.IN).withAttributeValueList(StandardTypeConverters.Vector.LIST.convert(values2, this));
    }

    public final Condition in(V ... values2) {
        return this.in((Collection<V>)Arrays.asList(values2));
    }

    public final Condition isNull() {
        return new Condition().withComparisonOperator(ComparisonOperator.NULL);
    }

    public final Condition le(V value) {
        return new Condition().withComparisonOperator(ComparisonOperator.LE).withAttributeValueList(new AttributeValue[]{this.convert((Object)value)});
    }

    public final Condition lt(V value) {
        return new Condition().withComparisonOperator(ComparisonOperator.LT).withAttributeValueList(new AttributeValue[]{this.convert((Object)value)});
    }

    public final Condition ne(V value) {
        return new Condition().withComparisonOperator(ComparisonOperator.NE).withAttributeValueList(new AttributeValue[]{this.convert((Object)value)});
    }

    public final Condition notContains(V value) {
        return new Condition().withComparisonOperator(ComparisonOperator.NOT_CONTAINS).withAttributeValueList(new AttributeValue[]{this.convert((Object)value)});
    }

    public final Condition notNull() {
        return new Condition().withComparisonOperator(ComparisonOperator.NOT_NULL);
    }

    public final Condition betweenAny(V lo, V hi) {
        return lo == null ? (hi == null ? null : this.le(hi)) : (hi == null ? this.ge(lo) : (lo.equals(hi) ? this.eq(lo) : this.between(lo, hi)));
    }

    static interface Reflect<T, V> {
        public V get(T var1);

        public void set(T var1, V var2);
    }

    static interface Properties<V> {
        public String attributeName();

        public KeyType keyType();

        public boolean versioned();

        public Map<KeyType, List<String>> globalSecondaryIndexNames();

        public List<String> localSecondaryIndexNames();

        public DynamoDBAutoGenerator<V> autoGenerator();

        public static final class Immutable<V>
        implements Properties<V> {
            private final String attributeName;
            private final KeyType keyType;
            private final boolean versioned;
            private final Map<KeyType, List<String>> globalSecondaryIndexNames;
            private final List<String> localSecondaryIndexNames;
            private final DynamoDBAutoGenerator<V> autoGenerator;

            public Immutable(Properties<V> properties) {
                this.attributeName = properties.attributeName();
                this.keyType = properties.keyType();
                this.versioned = properties.versioned();
                this.globalSecondaryIndexNames = properties.globalSecondaryIndexNames();
                this.localSecondaryIndexNames = properties.localSecondaryIndexNames();
                this.autoGenerator = properties.autoGenerator();
            }

            @Override
            public final String attributeName() {
                return this.attributeName;
            }

            @Override
            public final KeyType keyType() {
                return this.keyType;
            }

            @Override
            public final boolean versioned() {
                return this.versioned;
            }

            @Override
            public final Map<KeyType, List<String>> globalSecondaryIndexNames() {
                return this.globalSecondaryIndexNames;
            }

            @Override
            public final List<String> localSecondaryIndexNames() {
                return this.localSecondaryIndexNames;
            }

            @Override
            public final DynamoDBAutoGenerator<V> autoGenerator() {
                return this.autoGenerator;
            }
        }
    }

    static class Builder<T, V> {
        private final Properties<V> properties;
        private DynamoDBTypeConverter<AttributeValue, V> converter;
        private Reflect<T, V> reflect;
        private DynamoDBAttributeType attributeType;
        private Class<T> targetType;

        public Builder(Class<T> targetType, Properties<V> properties) {
            this.properties = properties;
            this.targetType = targetType;
        }

        public final Builder<T, V> with(DynamoDBTypeConverter<AttributeValue, V> converter) {
            this.converter = converter;
            return this;
        }

        public final Builder<T, V> with(DynamoDBAttributeType attributeType) {
            this.attributeType = attributeType;
            return this;
        }

        public final Builder<T, V> with(Reflect<T, V> reflect) {
            this.reflect = reflect;
            return this;
        }

        public final DynamoDBMapperFieldModel<T, V> build() {
            DynamoDBMapperFieldModel result = new DynamoDBMapperFieldModel(this);
            if ((result.keyType() != null || result.indexed()) && !result.attributeType().name().matches("[BNS]")) {
                throw new DynamoDBMappingException(String.format("%s[%s]; only scalar (B, N, or S) type allowed for key", this.targetType.getSimpleName(), result.name()));
            }
            if (result.keyType() != null && result.getGenerateStrategy() == DynamoDBAutoGenerateStrategy.ALWAYS) {
                throw new DynamoDBMappingException(String.format("%s[%s]; auto-generated key and ALWAYS not allowed", this.targetType.getSimpleName(), result.name()));
            }
            return result;
        }
    }

    public static enum DynamoDBAttributeType {
        B,
        N,
        S,
        BS,
        NS,
        SS,
        BOOL,
        NULL,
        L,
        M;

    }
}

