/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.util.guava;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.clickhouse.util.Utils;

public class StreamUtils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    private static final int BUF_SIZE = 4096;
    public static final Charset UTF_8 = Charset.forName("UTF-8");

    public static String toString(InputStream in) throws IOException {
        return new String(StreamUtils.toByteArray(in), UTF_8);
    }

    public static byte[] toByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamUtils.copy(in, out);
        return out.toByteArray();
    }

    public static long copy(InputStream from2, OutputStream to2) throws IOException {
        int r;
        byte[] buf = new byte[4096];
        long total = 0L;
        while ((r = from2.read(buf)) != -1) {
            to2.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }

    public static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            log.error("can not close stream: {}", (Object)e.getMessage());
        }
    }

    public static void close(ResultSet rs) {
        if (rs == null) {
            return;
        }
        try {
            rs.close();
        }
        catch (SQLException e) {
            log.error("can not close resultset: {}", (Object)e.getMessage());
        }
    }
}

