/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse;

import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;

public class ClickHouseUtil {
    private static final Escaper CLICKHOUSE_ESCAPER = Escapers.builder().addEscape('\\', "\\\\").addEscape('\n', "\\n").addEscape('\t', "\\t").addEscape('\b', "\\b").addEscape('\f', "\\f").addEscape('\r', "\\r").addEscape('\u0000', "\\0").addEscape('\'', "\\'").addEscape('`', "\\`").build();

    public static String escape(String s2) {
        if (s2 == null) {
            return "\\N";
        }
        return CLICKHOUSE_ESCAPER.escape(s2);
    }

    public static String quoteIdentifier(String s2) {
        if (s2 == null) {
            throw new IllegalArgumentException("Can't quote null as identifier");
        }
        StringBuilder sb = new StringBuilder(s2.length() + 2);
        sb.append('`');
        sb.append(CLICKHOUSE_ESCAPER.escape(s2));
        sb.append('`');
        return sb.toString();
    }
}

