/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.scp.common.helpers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.scp.ScpModuleProperties;
import org.apache.sshd.scp.common.ScpFileOpener;
import org.apache.sshd.scp.common.ScpSourceStreamResolver;
import org.apache.sshd.scp.common.ScpTargetStreamResolver;
import org.apache.sshd.scp.common.helpers.LocalFileScpSourceStreamResolver;
import org.apache.sshd.scp.common.helpers.LocalFileScpTargetStreamResolver;

public class DefaultScpFileOpener
extends AbstractLoggingBean
implements ScpFileOpener {
    public static final DefaultScpFileOpener INSTANCE = new DefaultScpFileOpener();
    private static final OpenOption[] DEFAULT_SYNC_OPTIONS = new OpenOption[]{StandardOpenOption.SYNC, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE};

    @Override
    public InputStream openRead(Session session, Path file, long size2, Set<PosixFilePermission> permissions, OpenOption ... options) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("openRead({}) size={}, permissions={}, file={}, options={}", session, size2, permissions, file, Arrays.toString(options));
        }
        return Files.newInputStream(file, options);
    }

    @Override
    public OutputStream openWrite(Session session, Path file, long size2, Set<PosixFilePermission> permissions, OpenOption ... options) throws IOException {
        options = this.resolveOpenOptions(session, file, size2, permissions, options);
        if (this.log.isDebugEnabled()) {
            this.log.debug("openWrite({}) size={}, permissions={}, file={}, options={}", session, size2, permissions, file, Arrays.toString(options));
        }
        return Files.newOutputStream(file, options);
    }

    protected OpenOption[] resolveOpenOptions(Session session, Path file, long size2, Set<PosixFilePermission> permissions, OpenOption ... options) throws IOException {
        if (!ScpModuleProperties.PROP_AUTO_SYNC_FILE_ON_WRITE.getRequired(session).booleanValue()) {
            return options;
        }
        int numOptions = GenericUtils.length(options);
        if (numOptions <= 0) {
            return (OpenOption[])DEFAULT_SYNC_OPTIONS.clone();
        }
        OpenOption syncOption = Stream.of(options).filter(o -> o == StandardOpenOption.SYNC).findFirst().orElse(null);
        if (syncOption != null) {
            return options;
        }
        Object[] tmp = new OpenOption[numOptions + 1];
        System.arraycopy(options, 0, tmp, 0, numOptions);
        tmp[numOptions] = StandardOpenOption.SYNC;
        if (this.log.isDebugEnabled()) {
            this.log.debug("resolveOpenOptions({}) modify options from {} to {} for {}", session, Arrays.toString(options), Arrays.toString(tmp), file);
        }
        return tmp;
    }

    @Override
    public ScpSourceStreamResolver createScpSourceStreamResolver(Session session, Path path) throws IOException {
        return new LocalFileScpSourceStreamResolver(path, this);
    }

    @Override
    public ScpTargetStreamResolver createScpTargetStreamResolver(Session session, Path path) throws IOException {
        return new LocalFileScpTargetStreamResolver(path, this);
    }
}

