/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.scp.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collection;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientSessionHolder;
import org.apache.sshd.common.session.SessionHolder;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.scp.common.helpers.ScpTimestampCommandDetails;

public interface ScpClient
extends SessionHolder<ClientSession>,
ClientSessionHolder {
    @Override
    default public ClientSession getSession() {
        return this.getClientSession();
    }

    default public void download(String remote2, String local, Option ... options) throws IOException {
        this.download(remote2, local, (Collection<Option>)GenericUtils.of((Enum[])options));
    }

    public void download(String var1, String var2, Collection<Option> var3) throws IOException;

    default public void download(String remote2, Path local, Option ... options) throws IOException {
        this.download(remote2, local, (Collection<Option>)GenericUtils.of((Enum[])options));
    }

    public void download(String var1, Path var2, Collection<Option> var3) throws IOException;

    public void download(String var1, OutputStream var2) throws IOException;

    default public byte[] downloadBytes(String remote2) throws IOException {
        try (ByteArrayOutputStream local = new ByteArrayOutputStream();){
            this.download(remote2, local);
            byte[] byArray = local.toByteArray();
            return byArray;
        }
    }

    default public void download(String[] remote2, String local, Option ... options) throws IOException {
        this.download(remote2, local, (Collection<Option>)GenericUtils.of((Enum[])options));
    }

    default public void download(String[] remote2, Path local, Option ... options) throws IOException {
        this.download(remote2, local, (Collection<Option>)GenericUtils.of((Enum[])options));
    }

    public void download(String[] var1, String var2, Collection<Option> var3) throws IOException;

    public void download(String[] var1, Path var2, Collection<Option> var3) throws IOException;

    default public void upload(String local, String remote2, Option ... options) throws IOException {
        this.upload(local, remote2, (Collection<Option>)GenericUtils.of((Enum[])options));
    }

    default public void upload(String local, String remote2, Collection<Option> options) throws IOException {
        this.upload(new String[]{ValidateUtils.checkNotNullAndNotEmpty(local, "Invalid argument local: %s", (Object)local)}, remote2, options);
    }

    default public void upload(Path local, String remote2, Option ... options) throws IOException {
        this.upload(local, remote2, (Collection<Option>)GenericUtils.of((Enum[])options));
    }

    default public void upload(Path local, String remote2, Collection<Option> options) throws IOException {
        this.upload(new Path[]{ValidateUtils.checkNotNull(local, "Invalid local argument: %s", (Object)local)}, remote2, GenericUtils.of(options));
    }

    default public void upload(String[] local, String remote2, Option ... options) throws IOException {
        this.upload(local, remote2, (Collection<Option>)GenericUtils.of((Enum[])options));
    }

    public void upload(String[] var1, String var2, Collection<Option> var3) throws IOException;

    default public void upload(Path[] local, String remote2, Option ... options) throws IOException {
        this.upload(local, remote2, (Collection<Option>)GenericUtils.of((Enum[])options));
    }

    public void upload(Path[] var1, String var2, Collection<Option> var3) throws IOException;

    default public void upload(byte[] data, String remote2, Collection<PosixFilePermission> perms, ScpTimestampCommandDetails time) throws IOException {
        this.upload(data, 0, data.length, remote2, perms, time);
    }

    default public void upload(byte[] data, int offset, int len, String remote2, Collection<PosixFilePermission> perms, ScpTimestampCommandDetails time) throws IOException {
        try (ByteArrayInputStream local = new ByteArrayInputStream(data, offset, len);){
            this.upload(local, remote2, len, perms, time);
        }
    }

    public void upload(InputStream var1, String var2, long var3, Collection<PosixFilePermission> var5, ScpTimestampCommandDetails var6) throws IOException;

    public static String createSendCommand(String remote2, Collection<Option> options) {
        StringBuilder sb = new StringBuilder(remote2.length() + 64).append("scp");
        ScpClient.appendCommandOption(sb, options, Option.TargetIsDirectory);
        ScpClient.appendCommandOption(sb, options, Option.Recursive);
        ScpClient.appendCommandOption(sb, options, Option.PreserveAttributes);
        sb.append(" -t").append(" --").append(' ').append(remote2);
        return sb.toString();
    }

    public static String createReceiveCommand(String remote2, Collection<Option> options) {
        ValidateUtils.checkNotNullAndNotEmpty(remote2, "No remote location specified");
        StringBuilder sb = new StringBuilder(remote2.length() + 64).append("scp");
        ScpClient.appendCommandOption(sb, options, Option.Recursive);
        ScpClient.appendCommandOption(sb, options, Option.PreserveAttributes);
        sb.append(" -f").append(" --").append(' ').append(remote2);
        return sb.toString();
    }

    public static StringBuilder appendCommandOption(StringBuilder sb, Collection<Option> options, Option opt2) {
        if (GenericUtils.isNotEmpty(options) && options.contains((Object)opt2)) {
            sb.append(' ').append(opt2.getOptionValue());
        }
        return sb;
    }

    public static enum Option {
        Recursive("-r"),
        PreserveAttributes("-p"),
        TargetIsDirectory("-d");

        private final String optionValue;

        private Option(String optionValue) {
            this.optionValue = optionValue;
        }

        public String getOptionValue() {
            return this.optionValue;
        }
    }
}

