/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.resource.PathResource;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class ModifiableFileWatcher
extends AbstractLoggingBean {
    public static final Set<PosixFilePermission> STRICTLY_PROHIBITED_FILE_PERMISSION = Collections.unmodifiableSet(EnumSet.of(PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_WRITE));
    protected final LinkOption[] options;
    private final Path file;
    private final AtomicBoolean lastExisted = new AtomicBoolean(false);
    private final AtomicLong lastSize = new AtomicLong(Long.MIN_VALUE);
    private final AtomicLong lastModified = new AtomicLong(-1L);

    public ModifiableFileWatcher(Path file) {
        this(file, IoUtils.getLinkOptions(true));
    }

    public ModifiableFileWatcher(Path file, LinkOption ... options) {
        this.file = Objects.requireNonNull(file, "No path to watch");
        this.options = options == null ? IoUtils.EMPTY_LINK_OPTIONS : (LinkOption[])options.clone();
    }

    public final Path getPath() {
        return this.file;
    }

    public final boolean exists() throws IOException {
        return Files.exists(this.getPath(), this.options);
    }

    public final long size() throws IOException {
        if (this.exists()) {
            return Files.size(this.getPath());
        }
        return -1L;
    }

    public final FileTime lastModified() throws IOException {
        if (this.exists()) {
            BasicFileAttributes attrs = Files.readAttributes(this.getPath(), BasicFileAttributes.class, this.options);
            return attrs.lastModifiedTime();
        }
        return null;
    }

    public boolean checkReloadRequired() throws IOException {
        boolean exists2 = this.exists();
        if (exists2 != this.lastExisted.getAndSet(exists2)) {
            return true;
        }
        if (!exists2) {
            this.resetReloadAttributes();
            return false;
        }
        long size2 = this.size();
        if (size2 < 0L) {
            this.resetReloadAttributes();
            return true;
        }
        if (size2 != this.lastSize.getAndSet(size2)) {
            return true;
        }
        FileTime modifiedTime = this.lastModified();
        if (modifiedTime == null) {
            this.resetReloadAttributes();
            return true;
        }
        long timestamp = modifiedTime.toMillis();
        return timestamp != this.lastModified.getAndSet(timestamp);
    }

    public void resetReloadAttributes() {
        this.lastExisted.set(false);
        this.lastSize.set(Long.MIN_VALUE);
        this.lastModified.set(-1L);
    }

    public void updateReloadAttributes() throws IOException {
        if (this.exists()) {
            long size2 = this.size();
            FileTime modifiedTime = this.lastModified();
            if (size2 >= 0L && modifiedTime != null) {
                this.lastExisted.set(true);
                this.lastSize.set(size2);
                this.lastModified.set(modifiedTime.toMillis());
                return;
            }
        }
        this.resetReloadAttributes();
    }

    public PathResource toPathResource() {
        return this.toPathResource(IoUtils.EMPTY_OPEN_OPTIONS);
    }

    public PathResource toPathResource(OpenOption ... options) {
        return new PathResource(this.getPath(), options);
    }

    public String toString() {
        return Objects.toString(this.getPath());
    }

    public static AbstractMap.SimpleImmutableEntry<String, Object> validateStrictConfigFilePermissions(Path path, LinkOption ... options) throws IOException {
        PosixFilePermission p;
        if (path == null || !Files.exists(path, options)) {
            return null;
        }
        Set<PosixFilePermission> perms = IoUtils.getPermissions(path, options);
        if (GenericUtils.isEmpty(perms)) {
            return null;
        }
        if (OsUtils.isUNIX() && (p = IoUtils.validateExcludedPermissions(perms, STRICTLY_PROHIBITED_FILE_PERMISSION)) != null) {
            return new AbstractMap.SimpleImmutableEntry<String, PosixFilePermission>(String.format("Permissions violation (%s)", new Object[]{p}), p);
        }
        String owner = IoUtils.getFileOwner(path, options);
        if (GenericUtils.isEmpty(owner)) {
            return null;
        }
        String current = OsUtils.getCurrentUser();
        HashSet<String> expected = new HashSet<String>();
        expected.add(current);
        if (OsUtils.isUNIX()) {
            expected.add("root");
        }
        if (!expected.contains(owner)) {
            return new AbstractMap.SimpleImmutableEntry<String, Object>(String.format("Owner violation (%s)", owner), owner);
        }
        return null;
    }
}

