/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.keyprovider;

import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.resource.IoResource;
import org.apache.sshd.common.util.io.resource.ResourceStreamProvider;
import org.apache.sshd.common.util.security.SecurityUtils;

public abstract class AbstractResourceKeyPairProvider<R>
extends AbstractKeyPairProvider {
    private FilePasswordProvider passwordFinder;
    private final Map<String, Iterable<KeyPair>> cacheMap = new TreeMap<String, Iterable<KeyPair>>(String.CASE_INSENSITIVE_ORDER);

    protected AbstractResourceKeyPairProvider() {
    }

    public FilePasswordProvider getPasswordFinder() {
        return this.passwordFinder;
    }

    public void setPasswordFinder(FilePasswordProvider passwordFinder) {
        this.passwordFinder = passwordFinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetCacheMap(Collection<?> resources) {
        Set<String> toDelete = Collections.emptySet();
        Map<String, Iterable<KeyPair>> map2 = this.cacheMap;
        synchronized (map2) {
            if (this.cacheMap.size() <= 0) {
                return;
            }
            if (GenericUtils.isEmpty(resources)) {
                this.cacheMap.clear();
                return;
            }
            for (Object r : resources) {
                String resourceKey = ValidateUtils.checkNotNullAndNotEmpty(Objects.toString(r, null), "No resource key value");
                if (this.cacheMap.containsKey(resourceKey)) continue;
                if (toDelete.isEmpty()) {
                    toDelete = new TreeSet(String.CASE_INSENSITIVE_ORDER);
                }
                if (toDelete.add(resourceKey)) continue;
            }
            if (GenericUtils.size(toDelete) > 0) {
                toDelete.forEach(this.cacheMap::remove);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("resetCacheMap(" + resources + ") removed previous cached keys for " + toDelete);
        }
    }

    protected Iterable<KeyPair> loadKeys(SessionContext session, Collection<? extends R> resources) {
        if (GenericUtils.isEmpty(resources)) {
            return Collections.emptyList();
        }
        return () -> new KeyPairIterator(session, resources);
    }

    protected IoResource<?> getIoResource(SessionContext session, R resource) {
        return IoResource.forResource(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterable<KeyPair> doLoadKeys(SessionContext session, R resource) throws IOException, GeneralSecurityException {
        Iterable<KeyPair> ids;
        IoResource<?> ioResource = ValidateUtils.checkNotNull(this.getIoResource(session, resource), "No I/O resource available for %s", resource);
        String resourceKey = ValidateUtils.checkNotNullAndNotEmpty(ioResource.getName(), "No resource string value for %s", resource);
        Map<String, Iterable<KeyPair>> map2 = this.cacheMap;
        synchronized (map2) {
            ids = this.cacheMap.get(resourceKey);
        }
        if (ids != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("doLoadKeys({}) using cached identifiers", (Object)resourceKey);
            }
            return ids;
        }
        ids = this.doLoadKeys(session, ioResource, resource, this.getPasswordFinder());
        if (ids != null) {
            boolean reusedKey;
            Map<String, Iterable<KeyPair>> map3 = this.cacheMap;
            synchronized (map3) {
                reusedKey = this.cacheMap.containsKey(resourceKey);
                if (reusedKey) {
                    ids = this.cacheMap.get(resourceKey);
                } else {
                    this.cacheMap.put(resourceKey, ids);
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("doLoadKeys({}) {}", (Object)resourceKey, (Object)(reusedKey ? "re-loaded" : "loaded"));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("doLoadKeys({}) no key loaded", (Object)resourceKey);
        }
        return ids;
    }

    protected Iterable<KeyPair> doLoadKeys(SessionContext session, NamedResource resourceKey, R resource, FilePasswordProvider provider) throws IOException, GeneralSecurityException {
        try (InputStream inputStream = this.openKeyPairResource(session, resourceKey, resource);){
            Iterable<KeyPair> iterable = this.doLoadKeys(session, resourceKey, inputStream, provider);
            return iterable;
        }
    }

    protected InputStream openKeyPairResource(SessionContext session, NamedResource resourceKey, R resource) throws IOException {
        if (resourceKey instanceof ResourceStreamProvider) {
            return ((ResourceStreamProvider)((Object)resourceKey)).openInputStream();
        }
        throw new StreamCorruptedException("Cannot open resource data for " + resource);
    }

    protected Iterable<KeyPair> doLoadKeys(SessionContext session, NamedResource resourceKey, InputStream inputStream, FilePasswordProvider provider) throws IOException, GeneralSecurityException {
        return SecurityUtils.loadKeyPairIdentities(session, resourceKey, inputStream, provider);
    }

    protected class KeyPairIterator
    implements Iterator<KeyPair> {
        protected final SessionContext session;
        private final Iterator<? extends R> iterator;
        private Iterator<KeyPair> currentIdentities;
        private KeyPair nextKeyPair;
        private boolean nextKeyPairSet;

        protected KeyPairIterator(SessionContext session, Collection<? extends R> resources) {
            this.session = session;
            this.iterator = resources.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.nextKeyPairSet || this.setNextObject();
        }

        @Override
        public KeyPair next() {
            if (!this.nextKeyPairSet && !this.setNextObject()) {
                throw new NoSuchElementException("Out of files to try");
            }
            this.nextKeyPairSet = false;
            return this.nextKeyPair;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("loadKeys(files) Iterator#remove() N/A");
        }

        private boolean setNextObject() {
            this.nextKeyPair = KeyIdentityProvider.exhaustCurrentIdentities(this.currentIdentities);
            if (this.nextKeyPair != null) {
                this.nextKeyPairSet = true;
                return true;
            }
            while (this.iterator.hasNext()) {
                Object r = this.iterator.next();
                try {
                    Iterable<KeyPair> ids = AbstractResourceKeyPairProvider.this.doLoadKeys(this.session, r);
                    this.currentIdentities = ids == null ? null : ids.iterator();
                    this.nextKeyPair = KeyIdentityProvider.exhaustCurrentIdentities(this.currentIdentities);
                }
                catch (Throwable e) {
                    AbstractResourceKeyPairProvider.this.warn("Failed ({}) to load key resource={}: {}", e.getClass().getSimpleName(), r, e.getMessage(), e);
                    this.nextKeyPair = null;
                    continue;
                }
                if (this.nextKeyPair == null) continue;
                this.nextKeyPairSet = true;
                return true;
            }
            return false;
        }
    }
}

