/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.loader.KeyPairResourceLoader;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public interface KeyPairResourceParser
extends KeyPairResourceLoader {
    public static final KeyPairResourceParser EMPTY = new KeyPairResourceParser(){

        @Override
        public Collection<KeyPair> loadKeyPairs(SessionContext session, NamedResource resourceKey, FilePasswordProvider passwordProvider, List<String> lines2) throws IOException, GeneralSecurityException {
            return Collections.emptyList();
        }

        @Override
        public boolean canExtractKeyPairs(NamedResource resourceKey, List<String> lines2) throws IOException, GeneralSecurityException {
            return false;
        }

        public String toString() {
            return "EMPTY";
        }
    };

    public boolean canExtractKeyPairs(NamedResource var1, List<String> var2) throws IOException, GeneralSecurityException;

    public static byte[] extractDataBytes(Collection<String> lines2) {
        String data = KeyPairResourceParser.joinDataLines(lines2);
        Base64.Decoder decoder = Base64.getDecoder();
        return decoder.decode(data);
    }

    public static String joinDataLines(Collection<String> lines2) {
        String data = GenericUtils.join(lines2, ' ');
        data = data.replaceAll("\\s", "");
        data = data.trim();
        return data;
    }

    public static boolean containsMarkerLine(List<String> lines2, String marker) {
        return KeyPairResourceParser.containsMarkerLine(lines2, Collections.singletonList(ValidateUtils.checkNotNullAndNotEmpty(marker, "No marker")));
    }

    public static boolean containsMarkerLine(List<String> lines2, List<String> markers) {
        return KeyPairResourceParser.findMarkerLine(lines2, markers) != null;
    }

    public static AbstractMap.SimpleImmutableEntry<Integer, Integer> findMarkerLine(List<String> lines2, List<String> markers) {
        return KeyPairResourceParser.findMarkerLine(lines2, 0, markers);
    }

    public static AbstractMap.SimpleImmutableEntry<Integer, Integer> findMarkerLine(List<String> lines2, int startLine, List<String> markers) {
        if (GenericUtils.isEmpty(lines2) || GenericUtils.isEmpty(markers)) {
            return null;
        }
        for (int lineIndex = startLine; lineIndex < lines2.size(); ++lineIndex) {
            String l = lines2.get(lineIndex);
            for (int markerIndex = 0; markerIndex < markers.size(); ++markerIndex) {
                String m = markers.get(markerIndex);
                if (!l.contains(m)) continue;
                return new AbstractMap.SimpleImmutableEntry<Integer, Integer>(lineIndex, markerIndex);
            }
        }
        return null;
    }

    public static KeyPairResourceParser aggregate(KeyPairResourceParser ... parsers) {
        return KeyPairResourceParser.aggregate(Arrays.asList(ValidateUtils.checkNotNullAndNotEmpty(parsers, "No parsers to aggregate", new Object[0])));
    }

    public static KeyPairResourceParser aggregate(final Collection<? extends KeyPairResourceParser> parsers) {
        ValidateUtils.checkNotNullAndNotEmpty(parsers, "No parsers to aggregate", new Object[0]);
        return new KeyPairResourceParser(){

            @Override
            public Collection<KeyPair> loadKeyPairs(SessionContext session, NamedResource resourceKey, FilePasswordProvider passwordProvider, List<String> lines2) throws IOException, GeneralSecurityException {
                List<KeyPair> keyPairs = Collections.emptyList();
                for (KeyPairResourceParser p : parsers) {
                    Collection<KeyPair> kps;
                    if (!p.canExtractKeyPairs(resourceKey, lines2) || GenericUtils.isEmpty(kps = p.loadKeyPairs(session, resourceKey, passwordProvider, lines2))) continue;
                    if (GenericUtils.isEmpty(keyPairs)) {
                        keyPairs = new LinkedList<KeyPair>(kps);
                        continue;
                    }
                    keyPairs.addAll(kps);
                }
                return keyPairs;
            }

            @Override
            public boolean canExtractKeyPairs(NamedResource resourceKey, List<String> lines2) throws IOException, GeneralSecurityException {
                for (KeyPairResourceParser p : parsers) {
                    if (!p.canExtractKeyPairs(resourceKey, lines2)) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return KeyPairResourceParser.class.getSimpleName() + "[aggregate]";
            }
        };
    }
}

