/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.unix;

import java.io.File;
import java.io.IOException;
import org.apache.sshd.common.util.OsUtils;
import org.apache.tomcat.jni.Library;
import org.apache.tomcat.jni.Pool;

public final class AprLibrary {
    private static AprLibrary library;
    private final long pool;

    private AprLibrary() {
        try {
            Library.initialize(null);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Error loading Apache Portable Runtime (APR).", e);
        }
        this.pool = Pool.create((long)0L);
    }

    public static synchronized AprLibrary getInstance() {
        if (!AprLibrary.isInitialized()) {
            AprLibrary.initialize();
        }
        return library;
    }

    private static synchronized void initialize() {
        if (library == null) {
            library = new AprLibrary();
        }
    }

    public static synchronized boolean isInitialized() {
        return library != null;
    }

    protected void finalize() throws Throwable {
        library = null;
        Pool.destroy((long)this.pool);
        Library.terminate();
        super.finalize();
    }

    long getRootPool() {
        return this.pool;
    }

    static String createLocalSocketAddress() throws IOException {
        String name;
        AprLibrary.initialize();
        if (OsUtils.isUNIX()) {
            File dir = File.createTempFile("mina", "apr");
            if (!dir.delete() || !dir.mkdir()) {
                throw new IOException("Cannot create secure temp directory");
            }
            AprLibrary.chmodOwner(dir.getAbsolutePath(), true);
            File socket = File.createTempFile("mina", "apr", dir);
            socket.delete();
            name = socket.getAbsolutePath();
        } else {
            File socket = File.createTempFile("mina", "apr");
            socket.delete();
            name = "\\\\.\\pipe\\" + socket.getName();
        }
        return name;
    }

    static void secureLocalSocket(String authSocket, long handle) throws IOException {
        if (OsUtils.isUNIX()) {
            AprLibrary.chmodOwner(authSocket, false);
        }
    }

    private static void chmodOwner(String authSocket, boolean execute2) throws IOException {
        int perms = 1536;
        if (execute2) {
            perms |= 0x100;
        }
        if (org.apache.tomcat.jni.File.permsSet((String)authSocket, (int)perms) != 0) {
            throw new IOException("Unable to secure local socket");
        }
    }
}

