/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.flink.clickhouse.sink;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.flink.types.Row;
import org.apache.seatunnel.common.config.TypesafeConfigUtils;
import org.apache.seatunnel.flink.clickhouse.pojo.ClickhouseFileCopyMethod;
import org.apache.seatunnel.flink.clickhouse.pojo.Shard;
import org.apache.seatunnel.flink.clickhouse.pojo.ShardMetadata;
import org.apache.seatunnel.flink.clickhouse.sink.client.ClickhouseClient;
import org.apache.seatunnel.flink.clickhouse.sink.client.ShardRouter;
import org.apache.seatunnel.flink.clickhouse.sink.file.ClickhouseTable;
import org.apache.seatunnel.flink.clickhouse.sink.file.ScpFileTransfer;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.clickhouse.ClickHouseConnectionImpl;

public class ClickhouseFileOutputFormat {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClickhouseFileOutputFormat.class);
    private static final String CLICKHOUSE_LOCAL_FILE_PREFIX = "/tmp/clickhouse-local/flink-file";
    private static final int UUID_LENGTH = 10;
    private final Config config;
    private final String clickhouseLocalPath;
    private final List<String> fields;
    private final ShardMetadata shardMetadata;
    private final ClickhouseFileCopyMethod clickhouseFileCopyMethod;
    private final Map<String, String> nodePassword;
    private final ClickhouseClient clickhouseClient;
    private final ShardRouter shardRouter;
    private final ClickhouseTable clickhouseTable;
    private final Map<String, String> schemaMap;
    private final Map<Shard, List<String>> shardLocalDataPaths;
    private final Map<Shard, List<Row>> rowCache;

    public ClickhouseFileOutputFormat(Config config, ShardMetadata shardMetadata, List<String> fields) throws IOException {
        this.config = config;
        this.clickhouseLocalPath = config.getString("clickhouse_local_path");
        this.shardMetadata = shardMetadata;
        this.fields = fields;
        this.clickhouseFileCopyMethod = ClickhouseFileCopyMethod.from(config.getString("copy_method"));
        this.nodePassword = TypesafeConfigUtils.getConfig(config, "node_free_password", true) != false ? Collections.emptyMap() : config.getObjectList("node_pass").stream().collect(Collectors.toMap(configObject -> configObject.toConfig().getString("node_address"), configObject -> configObject.toConfig().getString("password")));
        this.clickhouseClient = new ClickhouseClient(config);
        this.shardRouter = new ShardRouter(this.clickhouseClient, shardMetadata);
        this.clickhouseTable = this.clickhouseClient.getClickhouseTable(config.getString("database"), config.getString("table"));
        this.schemaMap = this.clickhouseClient.getClickhouseTableSchema(config.getString("table"));
        this.rowCache = new HashMap<Shard, List<Row>>(this.shardRouter.getShards().keySet().size());
        if (!TypesafeConfigUtils.getConfig(config, "node_free_password", true).booleanValue()) {
            this.shardRouter.getShards().values().forEach(shard -> {
                if (!this.nodePassword.containsKey(shard.getHostAddress()) && !this.nodePassword.containsKey(shard.getHostname())) {
                    throw new RuntimeException("Cannot find password of shard " + shard.getHostAddress());
                }
            });
        }
        this.shardLocalDataPaths = this.shardRouter.getShards().values().stream().collect(Collectors.toMap(Function.identity(), shard -> {
            ClickhouseTable shardTable = this.clickhouseClient.getClickhouseTable(shard.getDatabase(), this.clickhouseTable.getLocalTableName());
            return shardTable.getDataPaths();
        }));
    }

    public void writeRecords(Iterable<Row> records) {
        Shard shard;
        for (Row row : records) {
            shard = this.shardRouter.getShard(row);
            this.rowCache.computeIfAbsent(shard, k -> new ArrayList()).add(row);
        }
        for (Map.Entry entry : this.rowCache.entrySet()) {
            shard = (Shard)entry.getKey();
            List rows = (List)entry.getValue();
            this.flush(shard, rows);
            rows.clear();
        }
    }

    private void flush(Shard shard, List<Row> rows) {
        try {
            List<String> clickhouseLocalFiles = this.generateClickhouseLocalFiles(shard, rows);
            this.attachClickhouseLocalFileToServer(shard, clickhouseLocalFiles);
            this.clearLocalFileDirectory(clickhouseLocalFiles);
        }
        catch (Exception e) {
            throw new RuntimeException("Flush data into clickhouse file error", e);
        }
    }

    private List<String> generateClickhouseLocalFiles(Shard shard, List<Row> rows) throws IOException, InterruptedException {
        if (CollectionUtils.isEmpty(rows)) {
            return Collections.emptyList();
        }
        String uuid = UUID.randomUUID().toString().substring(0, 10).replaceAll("-", "_");
        String clickhouseLocalFile = String.format("%s/%s", CLICKHOUSE_LOCAL_FILE_PREFIX, uuid);
        FileUtils.forceMkdir((File)new File(clickhouseLocalFile));
        String clickhouseLocalFileTmpFile = clickhouseLocalFile + "/local_data.log";
        FileChannel fileChannel = FileChannel.open(Paths.get(clickhouseLocalFileTmpFile, new String[0]), StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.CREATE_NEW);
        String data = rows.stream().map(row -> this.fields.stream().map(field2 -> row.getField(field2).toString()).collect(Collectors.joining("\t"))).collect(Collectors.joining("\n"));
        MappedByteBuffer buffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, fileChannel.size(), data.getBytes(StandardCharsets.UTF_8).length);
        buffer.put(data.getBytes(StandardCharsets.UTF_8));
        ArrayList<String> command = new ArrayList<String>();
        command.add("cat");
        command.add(clickhouseLocalFileTmpFile);
        command.add("|");
        command.addAll(Arrays.stream(this.clickhouseLocalPath.trim().split(" ")).collect(Collectors.toList()));
        command.add("local");
        command.add("-S");
        command.add("\"" + this.fields.stream().map(field2 -> field2 + " " + this.schemaMap.get(field2)).collect(Collectors.joining(",")) + "\"");
        command.add("-N");
        command.add("\"temp_table" + uuid + "\"");
        command.add("-q");
        command.add(String.format("\"%s; INSERT INTO TABLE %s SELECT %s FROM temp_table%s;\"", this.clickhouseTable.getCreateTableDDL().replace(this.clickhouseTable.getDatabase() + ".", "").replaceAll("`", ""), this.clickhouseTable.getLocalTableName(), this.schemaMap.entrySet().stream().map(entry -> {
            if (this.fields.contains(entry.getKey())) {
                return (String)entry.getKey();
            }
            return "NULL";
        }).collect(Collectors.joining(",")), uuid));
        command.add("--path");
        command.add("\"" + clickhouseLocalFile + "\"");
        LOGGER.info("Generate clickhouse local file command: {}", (Object)String.join((CharSequence)" ", command));
        ProcessBuilder processBuilder = new ProcessBuilder("bash", "-c", String.join((CharSequence)" ", command));
        Process start = processBuilder.start();
        try (InputStream inputStream = start.getInputStream();
             InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                LOGGER.info(line);
            }
        }
        start.waitFor();
        File file = new File(clickhouseLocalFile + "/data/_local/" + this.clickhouseTable.getLocalTableName());
        if (!file.exists()) {
            throw new RuntimeException("clickhouse local file not exists");
        }
        File[] files = file.listFiles();
        if (files == null) {
            throw new RuntimeException("clickhouse local file not exists");
        }
        return Arrays.stream(files).filter(File::isDirectory).filter(f -> !"detached".equals(f.getName())).map(File::getAbsolutePath).collect(Collectors.toList());
    }

    private void attachClickhouseLocalFileToServer(Shard shard, List<String> clickhouseLocalFiles) {
        if (!ClickhouseFileCopyMethod.SCP.equals((Object)this.clickhouseFileCopyMethod)) {
            throw new RuntimeException("unsupported clickhouse file copy method " + (Object)((Object)this.clickhouseFileCopyMethod));
        }
        String hostAddress = shard.getHostAddress();
        String password = this.nodePassword.getOrDefault(hostAddress, null);
        ScpFileTransfer fileTransfer = new ScpFileTransfer(hostAddress, password);
        fileTransfer.init();
        fileTransfer.transferAndChown(clickhouseLocalFiles, this.shardLocalDataPaths.get(shard).get(0) + "detached/");
        fileTransfer.close();
        try (ClickHouseConnectionImpl clickhouseConnection = this.clickhouseClient.getClickhouseConnection(shard);){
            for (String clickhouseLocalFile : clickhouseLocalFiles) {
                clickhouseConnection.createStatement().execute(String.format("ALTER TABLE %s ATTACH PART '%s'", this.clickhouseTable.getLocalTableName(), clickhouseLocalFile.substring(clickhouseLocalFile.lastIndexOf("/") + 1)));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to close connection", e);
        }
    }

    private void clearLocalFileDirectory(List<String> clickhouseLocalFiles) {
        String clickhouseLocalFile = clickhouseLocalFiles.get(0);
        String localFileDir = clickhouseLocalFile.substring(0, CLICKHOUSE_LOCAL_FILE_PREFIX.length() + 10 + 1);
        try {
            File file = new File(localFileDir);
            if (file.exists()) {
                FileUtils.deleteDirectory((File)new File(localFileDir));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to delete directory " + localFileDir, e);
        }
    }
}

