/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.flink.clickhouse.sink;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.types.Row;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.config.TypesafeConfigUtils;
import org.apache.seatunnel.flink.BaseFlinkSink;
import org.apache.seatunnel.flink.FlinkEnvironment;
import org.apache.seatunnel.flink.batch.FlinkBatchSink;
import org.apache.seatunnel.flink.clickhouse.pojo.Shard;
import org.apache.seatunnel.flink.clickhouse.pojo.ShardMetadata;
import org.apache.seatunnel.flink.clickhouse.sink.ClickhouseOutputFormat;
import org.apache.seatunnel.flink.clickhouse.sink.client.ClickhouseClient;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;
import ru.yandex.clickhouse.ClickHouseConnectionImpl;

@AutoService(value={BaseFlinkSink.class})
public class ClickhouseBatchSink
implements FlinkBatchSink {
    private ShardMetadata shardMetadata;
    private Config config;
    private Map<String, String> tableSchema = new HashMap<String, String>();
    private List<String> fields;

    public void setConfig(Config config) {
        this.config = config;
    }

    public Config getConfig() {
        return this.config;
    }

    @Nullable
    public void outputBatch(FlinkEnvironment env, DataSet<Row> dataSet) {
        ClickhouseOutputFormat clickhouseOutputFormat = new ClickhouseOutputFormat(this.config, this.shardMetadata, this.fields, this.tableSchema);
        dataSet.output((OutputFormat)clickhouseOutputFormat);
    }

    public CheckResult checkConfig() {
        return CheckConfigUtil.checkAllExists(this.config, "host", "table", "database", "username", "password");
    }

    public void prepare(FlinkEnvironment env) {
        ImmutableMap<String, Integer> defaultConfig = ImmutableMap.builder().put("bulk_size", 20000).put("retry_codes", (Integer)((Object)new ArrayList())).put("retry", 1).put("split_mode", (Integer)((Object)Boolean.valueOf(false))).build();
        this.config = this.config.withFallback(ConfigFactory.parseMap(defaultConfig));
        ClickhouseClient clickhouseClient = new ClickhouseClient(this.config);
        boolean splitMode = this.config.getBoolean("split_mode");
        String table = this.config.getString("table");
        String database = this.config.getString("database");
        String[] hostAndPort = this.config.getString("host").split(":");
        try (ClickHouseConnectionImpl connection = clickhouseClient.getClickhouseConnection();){
            this.tableSchema = clickhouseClient.getClickhouseTableSchema(connection, table);
            String shardKey = TypesafeConfigUtils.getConfig(this.config, "sharding_key", "");
            String shardKeyType = this.tableSchema.get(shardKey);
            this.shardMetadata = new ShardMetadata(shardKey, shardKeyType, database, table, splitMode, new Shard(1, 1, 1, hostAndPort[0], hostAndPort[0], hostAndPort[1], database));
            if (this.config.hasPath("fields")) {
                this.fields = this.config.getStringList("fields");
                for (String field2 : this.fields) {
                    if (this.tableSchema.containsKey(field2)) continue;
                    throw new RuntimeException("Field " + field2 + " does not exist in table " + table);
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to connect to clickhouse server", e);
        }
    }

    public void close() {
    }

    public String getPluginName() {
        return "Clickhouse";
    }
}

