/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.flink.clickhouse.pojo;

import java.io.Serializable;

public class Shard
implements Serializable {
    private static final long serialVersionUID = -1L;
    private final int shardNum;
    private final int shardWeight;
    private final int replicaNum;
    private final String hostname;
    private final String hostAddress;
    private final String port;
    private final String database;
    private int hashCode = -1;

    public Shard(int shardNum, int shardWeight, int replicaNum, String hostname, String hostAddress, String port, String database) {
        this.shardNum = shardNum;
        this.shardWeight = shardWeight;
        this.replicaNum = replicaNum;
        this.hostname = hostname;
        this.hostAddress = hostAddress;
        this.port = port;
        this.database = database;
    }

    public int getShardNum() {
        return this.shardNum;
    }

    public int getShardWeight() {
        return this.shardWeight;
    }

    public int getReplicaNum() {
        return this.replicaNum;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public String getPort() {
        return this.port;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getJdbcUrl() {
        return "jdbc:clickhouse://" + this.hostAddress + ":" + this.port + "/" + this.database;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Shard shard = (Shard)o;
        if (this.shardNum != shard.shardNum) {
            return false;
        }
        if (this.shardWeight != shard.shardWeight) {
            return false;
        }
        if (this.replicaNum != shard.replicaNum) {
            return false;
        }
        if (!this.hostname.equals(shard.hostname)) {
            return false;
        }
        if (!this.hostAddress.equals(shard.hostAddress)) {
            return false;
        }
        if (!this.port.equals(shard.port)) {
            return false;
        }
        return this.database.equals(shard.database);
    }

    public int hashCode() {
        if (this.hashCode != -1) {
            return this.hashCode;
        }
        int result2 = this.shardNum;
        result2 = 31 * result2 + this.shardWeight;
        result2 = 31 * result2 + this.replicaNum;
        result2 = 31 * result2 + this.hostname.hashCode();
        result2 = 31 * result2 + this.hostAddress.hashCode();
        result2 = 31 * result2 + this.port.hashCode();
        this.hashCode = result2 = 31 * result2 + this.database.hashCode();
        return this.hashCode;
    }
}

