/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.flink.console.sink;

import com.google.auto.service.AutoService;
import org.apache.flink.api.common.io.RichOutputFormat;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.types.Row;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.flink.BaseFlinkSink;
import org.apache.seatunnel.flink.FlinkEnvironment;
import org.apache.seatunnel.flink.batch.FlinkBatchSink;
import org.apache.seatunnel.flink.stream.FlinkStreamSink;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={BaseFlinkSink.class})
public class ConsoleSink
extends RichOutputFormat<Row>
implements FlinkBatchSink,
FlinkStreamSink {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsoleSink.class);
    private static final String LIMIT = "limit";
    private Integer limit = Integer.MAX_VALUE;
    private static final long serialVersionUID = 3482649370594181723L;
    private Config config;

    public void outputBatch(FlinkEnvironment env, DataSet<Row> rowDataSet) {
        try {
            rowDataSet.first(this.limit.intValue()).print();
        }
        catch (Exception e) {
            LOGGER.error("Failed to print result! ", (Throwable)e);
        }
    }

    public void outputStream(FlinkEnvironment env, DataStream<Row> dataStream) {
        dataStream.print();
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public Config getConfig() {
        return this.config;
    }

    public CheckResult checkConfig() {
        if (this.config.hasPath(LIMIT) && this.config.getInt(LIMIT) >= -1) {
            this.limit = this.config.getInt(LIMIT);
        }
        return CheckResult.success();
    }

    public void configure(Configuration parameters) {
    }

    public void open(int taskNumber, int numTasks) {
    }

    public void writeRecord(Row record) {
    }

    public void close() {
    }

    public String getPluginName() {
        return "ConsoleSink";
    }
}

