/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.flink.doris.sink;

import javax.annotation.Nonnull;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.streaming.api.checkpoint.CheckpointedFunction;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.util.Preconditions;
import org.apache.seatunnel.flink.doris.sink.DorisOutputFormat;

public class DorisSinkFunction<T>
extends RichSinkFunction<T>
implements CheckpointedFunction {
    private static final long serialVersionUID = -2259171589402599426L;
    private final DorisOutputFormat<Object> outputFormat;

    public DorisSinkFunction(@Nonnull DorisOutputFormat<Object> outputFormat) {
        this.outputFormat = (DorisOutputFormat)((Object)Preconditions.checkNotNull(outputFormat));
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        RuntimeContext ctx = this.getRuntimeContext();
        this.outputFormat.setRuntimeContext(ctx);
        this.outputFormat.open(ctx.getIndexOfThisSubtask(), ctx.getNumberOfParallelSubtasks());
    }

    public void invoke(T value, SinkFunction.Context context) throws Exception {
        this.outputFormat.writeRecord(value);
    }

    public void initializeState(FunctionInitializationContext context) {
    }

    public void snapshotState(FunctionSnapshotContext context) {
    }

    public void close() throws Exception {
        this.outputFormat.close();
        super.close();
    }
}

