/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.sql.streaming;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.sql.SparkSession;
import org.elasticsearch.hadoop.EsHadoopException;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.util.matching.Regex;

public final class StructuredStreamingVersionLock$ {
    public static final StructuredStreamingVersionLock$ MODULE$;
    private final Log LOG;
    private final Regex supported;

    static {
        new StructuredStreamingVersionLock$();
    }

    public void checkCompatibility(SparkSession session) {
        try {
            String string2 = session.version();
            Option<List<String>> option = this.supported.unapplySeq(string2);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                BoxedUnit boxedUnit;
                String version = (String)((LinearSeqOptimized)option.get()).apply(0);
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running against supported version of Spark [", "]"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{version})));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return;
            }
            throw new EsHadoopIllegalArgumentException(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Spark version mismatch. Expected at least Spark version [2.2.0] "})).s(Nil$.MODULE$)).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but found [", "]. Spark Structured Streaming is a feature that is only supported on Spark "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{session.version()}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[2.2.0] and up for this version of ES-Hadoop/Spark."})).s(Nil$.MODULE$)).toString());
        }
        catch (Throwable throwable) {
            throw new EsHadoopIllegalArgumentException("Could not determine the version of Spark for compatibility", throwable);
        }
        catch (EsHadoopException esHadoopException) {
            throw esHadoopException;
        }
    }

    private StructuredStreamingVersionLock$() {
        MODULE$ = this;
        this.LOG = LogFactory.getLog(this.getClass());
        this.supported = new StringOps(Predef$.MODULE$.augmentString("(2.[2-9].[0-9]|[3-9].[0-9].[0-9]).*")).r();
    }
}

