/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.sql.streaming;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.spark.sql.internal.SQLConf$;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.util.unit.TimeValue;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class SparkSqlStreamingConfigs$ {
    public static final SparkSqlStreamingConfigs$ MODULE$;
    private final String ES_SINK_LOG_ENABLE;
    private final boolean ES_SINK_LOG_ENABLE_DEFAULT;
    private final String ES_SINK_LOG_PATH;
    private final String ES_INTERNAL_APP_NAME;
    private final String ES_INTERNAL_APP_ID;
    private final String ES_INTERNAL_QUERY_NAME;
    private final String ES_INTERNAL_USER_CHECKPOINT_LOCATION;
    private final String ES_INTERNAL_SESSION_CHECKPOINT_LOCATION;
    private final String ES_SINK_LOG_CLEANUP_DELAY;
    private final long ES_SINK_LOG_CLEANUP_DELAY_DEFAULT;
    private final String ES_SINK_LOG_DELETION;
    private final boolean ES_SINK_LOG_DELETION_DEFAULT;
    private final String ES_SINK_LOG_COMPACT_INTERVAL;
    private final int ES_SINK_LOG_COMPACT_INTERVAL_DEFAULT;

    static {
        new SparkSqlStreamingConfigs$();
    }

    public String ES_SINK_LOG_ENABLE() {
        return this.ES_SINK_LOG_ENABLE;
    }

    public boolean ES_SINK_LOG_ENABLE_DEFAULT() {
        return this.ES_SINK_LOG_ENABLE_DEFAULT;
    }

    public String ES_SINK_LOG_PATH() {
        return this.ES_SINK_LOG_PATH;
    }

    public String ES_INTERNAL_APP_NAME() {
        return this.ES_INTERNAL_APP_NAME;
    }

    public String ES_INTERNAL_APP_ID() {
        return this.ES_INTERNAL_APP_ID;
    }

    public String ES_INTERNAL_QUERY_NAME() {
        return this.ES_INTERNAL_QUERY_NAME;
    }

    public String ES_INTERNAL_USER_CHECKPOINT_LOCATION() {
        return this.ES_INTERNAL_USER_CHECKPOINT_LOCATION;
    }

    public String ES_INTERNAL_SESSION_CHECKPOINT_LOCATION() {
        return this.ES_INTERNAL_SESSION_CHECKPOINT_LOCATION;
    }

    public String ES_SINK_LOG_CLEANUP_DELAY() {
        return this.ES_SINK_LOG_CLEANUP_DELAY;
    }

    public long ES_SINK_LOG_CLEANUP_DELAY_DEFAULT() {
        return this.ES_SINK_LOG_CLEANUP_DELAY_DEFAULT;
    }

    public String ES_SINK_LOG_DELETION() {
        return this.ES_SINK_LOG_DELETION;
    }

    public boolean ES_SINK_LOG_DELETION_DEFAULT() {
        return this.ES_SINK_LOG_DELETION_DEFAULT;
    }

    public String ES_SINK_LOG_COMPACT_INTERVAL() {
        return this.ES_SINK_LOG_COMPACT_INTERVAL;
    }

    public int ES_SINK_LOG_COMPACT_INTERVAL_DEFAULT() {
        return this.ES_SINK_LOG_COMPACT_INTERVAL_DEFAULT;
    }

    public boolean getSinkLogEnabled(Settings settings) {
        return BoxesRunTime.unboxToBoolean(Option$.MODULE$.apply(settings.getProperty(this.ES_SINK_LOG_ENABLE())).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).toBoolean();
            }
        }).getOrElse(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return SparkSqlStreamingConfigs$.MODULE$.ES_SINK_LOG_ENABLE_DEFAULT();
            }
        }));
    }

    public String constructCommitLogPath(Settings settings) {
        Tuple4<Option<String>, Option<String>, Option<String>, Option<String>> tuple4;
        block9: {
            String string2;
            block6: {
                block8: {
                    block7: {
                        block5: {
                            String explicitPath;
                            Option<String> option;
                            Option<String> queryName;
                            Option<String> sessionCheckpointLocation;
                            Option<String> userCheckpointLocation;
                            Option<String> logPath = this.getLogPath(settings);
                            tuple4 = new Tuple4<Option<String>, Option<String>, Option<String>, Option<String>>(logPath, userCheckpointLocation = this.getUserSpecifiedCheckpointLocation(settings), sessionCheckpointLocation = this.getSessionCheckpointLocation(settings), queryName = this.getQueryName(settings));
                            if (tuple4 == null || !((option = tuple4._1()) instanceof Some)) break block5;
                            Some some = (Some)option;
                            string2 = explicitPath = (String)some.x();
                            break block6;
                        }
                        if (tuple4 == null) break block7;
                        Option<String> option = tuple4._1();
                        Option<String> option2 = tuple4._2();
                        if (!None$.MODULE$.equals(option) || !(option2 instanceof Some)) break block7;
                        Some some = (Some)option2;
                        String userCheckpoint = (String)some.x();
                        string2 = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/sinks/elasticsearch"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{userCheckpoint}));
                        break block6;
                    }
                    if (tuple4 == null) break block8;
                    Option<String> option = tuple4._1();
                    Option<String> option3 = tuple4._2();
                    Option<String> option4 = tuple4._3();
                    Option<String> option5 = tuple4._4();
                    if (!None$.MODULE$.equals(option) || !None$.MODULE$.equals(option3) || !(option4 instanceof Some)) break block8;
                    Some some = (Some)option4;
                    String sessionCheckpoint = (String)some.x();
                    if (!None$.MODULE$.equals(option5)) break block8;
                    string2 = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/sinks/elasticsearch"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{sessionCheckpoint, UUID.randomUUID().toString()}));
                    break block6;
                }
                if (tuple4 == null) break block9;
                Option<String> option = tuple4._1();
                Option<String> option6 = tuple4._2();
                Option<String> option7 = tuple4._3();
                Option<String> option8 = tuple4._4();
                if (!None$.MODULE$.equals(option) || !None$.MODULE$.equals(option6) || !(option7 instanceof Some)) break block9;
                Some some = (Some)option7;
                String sessionCheckpoint = (String)some.x();
                if (!(option8 instanceof Some)) break block9;
                Some some2 = (Some)option8;
                String query = (String)some2.x();
                string2 = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/sinks/elasticsearch"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{sessionCheckpoint, query}));
            }
            return string2;
        }
        if (tuple4 != null) {
            Option<String> option = tuple4._1();
            Option<String> option9 = tuple4._2();
            Option<String> option10 = tuple4._3();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option9) && None$.MODULE$.equals(option10)) {
                throw new EsHadoopIllegalArgumentException(new StringBuilder().append((Object)"Could not determine path for the Elasticsearch commit log. Specify the commit log location by setting the [checkpointLocation] option on your DataStreamWriter. If you do not want to persist the Elasticsearch commit log in the regular checkpoint location for your streaming query then you can specify a location to ").append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"store the log with [", "], or disable the commit log by setting [", "] to false."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.ES_SINK_LOG_PATH(), this.ES_SINK_LOG_ENABLE()}))).toString());
            }
        }
        throw new MatchError(tuple4);
    }

    public Option<String> getLogPath(Settings settings) {
        return Option$.MODULE$.apply(settings.getProperty(this.ES_SINK_LOG_PATH()));
    }

    public Option<String> getAppName(Settings settings) {
        return Option$.MODULE$.apply(settings.getProperty(this.ES_INTERNAL_APP_NAME()));
    }

    public Option<String> getAppId(Settings settings) {
        return Option$.MODULE$.apply(settings.getProperty(this.ES_INTERNAL_APP_ID()));
    }

    public Option<String> getQueryName(Settings settings) {
        return Option$.MODULE$.apply(settings.getProperty(this.ES_INTERNAL_QUERY_NAME()));
    }

    public Option<String> getUserSpecifiedCheckpointLocation(Settings settings) {
        return Option$.MODULE$.apply(settings.getProperty(this.ES_INTERNAL_USER_CHECKPOINT_LOCATION()));
    }

    public Option<String> getSessionCheckpointLocation(Settings settings) {
        return Option$.MODULE$.apply(settings.getProperty(this.ES_INTERNAL_SESSION_CHECKPOINT_LOCATION()));
    }

    public long getFileCleanupDelayMs(Settings settings) {
        return BoxesRunTime.unboxToLong(Option$.MODULE$.apply(settings.getProperty(this.ES_SINK_LOG_CLEANUP_DELAY())).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(String x$2) {
                return TimeValue.parseTimeValue(x$2).getMillis();
            }
        }).orElse(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<Object> apply() {
                return SQLConf$.MODULE$.FILE_SINK_LOG_CLEANUP_DELAY().defaultValue();
            }
        }).getOrElse(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return SparkSqlStreamingConfigs$.MODULE$.ES_SINK_LOG_CLEANUP_DELAY_DEFAULT();
            }
        }));
    }

    public boolean getIsDeletingExpiredLog(Settings settings) {
        return BoxesRunTime.unboxToBoolean(Option$.MODULE$.apply(settings.getProperty(this.ES_SINK_LOG_DELETION())).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$3) {
                return new StringOps(Predef$.MODULE$.augmentString(x$3)).toBoolean();
            }
        }).orElse(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<Object> apply() {
                return SQLConf$.MODULE$.FILE_SINK_LOG_DELETION().defaultValue();
            }
        }).getOrElse(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return SparkSqlStreamingConfigs$.MODULE$.ES_SINK_LOG_DELETION_DEFAULT();
            }
        }));
    }

    public int getDefaultCompactInterval(Settings settings) {
        return BoxesRunTime.unboxToInt(Option$.MODULE$.apply(settings.getProperty(this.ES_SINK_LOG_COMPACT_INTERVAL())).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$4) {
                return new StringOps(Predef$.MODULE$.augmentString(x$4)).toInt();
            }
        }).orElse(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<Object> apply() {
                return SQLConf$.MODULE$.FILE_SINK_LOG_COMPACT_INTERVAL().defaultValue();
            }
        }).getOrElse(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return SparkSqlStreamingConfigs$.MODULE$.ES_SINK_LOG_COMPACT_INTERVAL_DEFAULT();
            }
        }));
    }

    private SparkSqlStreamingConfigs$() {
        MODULE$ = this;
        this.ES_SINK_LOG_ENABLE = "es.spark.sql.streaming.sink.log.enabled";
        this.ES_SINK_LOG_ENABLE_DEFAULT = true;
        this.ES_SINK_LOG_PATH = "es.spark.sql.streaming.sink.log.path";
        this.ES_INTERNAL_APP_NAME = "es.internal.spark.sql.streaming.appName";
        this.ES_INTERNAL_APP_ID = "es.internal.spark.sql.streaming.appID";
        this.ES_INTERNAL_QUERY_NAME = "es.internal.spark.sql.streaming.queryName";
        this.ES_INTERNAL_USER_CHECKPOINT_LOCATION = "es.internal.spark.sql.streaming.userCheckpointLocation";
        this.ES_INTERNAL_SESSION_CHECKPOINT_LOCATION = "es.internal.spark.sql.streaming.sessionCheckpointLocation";
        this.ES_SINK_LOG_CLEANUP_DELAY = "es.spark.sql.streaming.sink.log.cleanupDelay";
        this.ES_SINK_LOG_CLEANUP_DELAY_DEFAULT = TimeUnit.MINUTES.toMillis(10L);
        this.ES_SINK_LOG_DELETION = "es.spark.sql.streaming.sink.log.deletion";
        this.ES_SINK_LOG_DELETION_DEFAULT = true;
        this.ES_SINK_LOG_COMPACT_INTERVAL = "es.spark.sql.streaming.sink.log.compactInterval";
        this.ES_SINK_LOG_COMPACT_INTERVAL_DEFAULT = 10;
    }
}

