/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.EsHadoopIllegalStateException;
import org.elasticsearch.hadoop.util.Assert;

public abstract class ReflectionUtils {
    public static Field findField(Class<?> clazz, String name) {
        return ReflectionUtils.findField(clazz, name, null);
    }

    public static Field findField(Class<?> clazz, String name, Class<?> type) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.isTrue(name != null || type != null, "Either name or type of the field must be specified");
        for (Class<?> searchType = clazz; !Object.class.equals(searchType) && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields;
            for (Field field2 : fields = searchType.getDeclaredFields()) {
                if (name != null && !name.equals(field2.getName()) || type != null && !type.equals(field2.getType())) continue;
                return field2;
            }
        }
        return null;
    }

    public static <T> T getField(Field field2, Object target) {
        try {
            return (T)field2.get(target);
        }
        catch (IllegalAccessException ex) {
            throw new EsHadoopIllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    public static void setField(Field field2, Object target, Object value) {
        try {
            field2.set(target, value);
        }
        catch (IllegalAccessException ex) {
            throw new EsHadoopIllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    public static void makeAccessible(AccessibleObject accessible) {
        if (!accessible.isAccessible()) {
            accessible.setAccessible(true);
        }
    }

    public static Method findMethod(Class<?> targetClass, String name, Class<?> ... paramTypes) {
        while (targetClass != null) {
            Method[] methods;
            for (Method method : methods = targetClass.isInterface() ? targetClass.getMethods() : targetClass.getDeclaredMethods()) {
                if (!name.equals(method.getName()) || paramTypes != null && !Arrays.equals(paramTypes, method.getParameterTypes())) continue;
                return method;
            }
            targetClass = targetClass.getSuperclass();
        }
        return null;
    }

    public static <T> T invoke(Method method, Object target, Object ... args) {
        try {
            return (T)method.invoke(target, args);
        }
        catch (Exception ex) {
            throw new EsHadoopIllegalArgumentException("Cannot invoke method " + method, ex);
        }
    }
}

