/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.util;

import java.lang.reflect.Method;
import java.util.Calendar;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.util.ObjectUtils;
import org.elasticsearch.hadoop.util.ReflectionUtils;

public abstract class DateUtils {
    public static boolean printed = false;
    private static final boolean jodaTimeAvailable = ObjectUtils.isClassPresent("org.joda.time.format.ISODateTimeFormat", DateUtils.class.getClassLoader());

    public static Calendar parseDate(String value) {
        if (!printed) {
            printed = true;
            Log log = LogFactory.getLog(DateUtils.class);
            if (jodaTimeAvailable && JodaTime.INITIALIZED) {
                log.info((Object)"Joda library available in the classpath; using it for date/time handling...");
            }
        }
        return jodaTimeAvailable && JodaTime.INITIALIZED ? JodaTime.parseDate(value) : Jdk6.parseDate(value);
    }

    private static abstract class JodaTime {
        private static final Object DATE_OPTIONAL_TIME_FORMATTER;
        private static final Method PARSE_DATE_TIME;
        private static final Method TO_CALENDAR;
        private static final boolean INITIALIZED;

        private JodaTime() {
        }

        public static Calendar parseDate(String value) {
            Object dt = ReflectionUtils.invoke(PARSE_DATE_TIME, DATE_OPTIONAL_TIME_FORMATTER, value);
            return (Calendar)ReflectionUtils.invoke(TO_CALENDAR, dt, new Object[0]);
        }

        static {
            boolean init2 = false;
            Method parseDateTime = null;
            Method toCalendar = null;
            Object dotf = null;
            try {
                ClassLoader cl = JodaTime.class.getClassLoader();
                Class<?> FORMAT_CLASS = ObjectUtils.loadClass("org.joda.time.format.ISODateTimeFormat", cl);
                Method DATE_OPTIONAL_TIME = ReflectionUtils.findMethod(FORMAT_CLASS, "dateOptionalTimeParser", new Class[0]);
                dotf = ReflectionUtils.invoke(DATE_OPTIONAL_TIME, null, new Object[0]);
                parseDateTime = ReflectionUtils.findMethod(dotf.getClass(), "parseDateTime", String.class);
                Class<?> DATE_TIME_CLASS = ObjectUtils.loadClass("org.joda.time.DateTime", cl);
                toCalendar = ReflectionUtils.findMethod(DATE_TIME_CLASS, "toGregorianCalendar", new Class[0]);
                init2 = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            DATE_OPTIONAL_TIME_FORMATTER = dotf;
            PARSE_DATE_TIME = parseDateTime;
            TO_CALENDAR = toCalendar;
            INITIALIZED = init2;
        }
    }

    private static abstract class Jdk6 {
        private Jdk6() {
        }

        public static Calendar parseDate(String value) {
            int timeZoneIndex = value.indexOf("T");
            if (timeZoneIndex > 0) {
                int sign = value.indexOf("+", timeZoneIndex);
                if (sign < 0) {
                    sign = value.indexOf("-", timeZoneIndex);
                }
                if (sign > 0) {
                    int colonIndex = sign + 3;
                    if (colonIndex >= value.length()) {
                        value = value + ":00";
                    } else if (value.charAt(colonIndex) != ':') {
                        value = value.substring(0, colonIndex) + ":" + value.substring(colonIndex);
                    }
                }
            }
            return DatatypeConverter.parseDateTime((String)value);
        }
    }
}

