/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.json;

import java.lang.ref.SoftReference;
import org.codehaus.jackson.util.TextBuffer;

public class BackportedJsonStringEncoder {
    private static final char[] HEX_CHARS_SOURCE = "0123456789ABCDEF".toCharArray();
    private static final char[] HEX_CHARS = (char[])HEX_CHARS_SOURCE.clone();
    static final int[] sOutputEscapes128;
    protected static final ThreadLocal<SoftReference<BackportedJsonStringEncoder>> _threadEncoder;
    protected TextBuffer _textBuffer;
    protected final char[] _quoteBuffer = new char[6];

    public BackportedJsonStringEncoder() {
        this._quoteBuffer[0] = 92;
        this._quoteBuffer[2] = 48;
        this._quoteBuffer[3] = 48;
    }

    public static BackportedJsonStringEncoder getInstance() {
        BackportedJsonStringEncoder enc;
        SoftReference<BackportedJsonStringEncoder> ref = _threadEncoder.get();
        BackportedJsonStringEncoder backportedJsonStringEncoder = enc = ref == null ? null : ref.get();
        if (enc == null) {
            enc = new BackportedJsonStringEncoder();
            _threadEncoder.set(new SoftReference<BackportedJsonStringEncoder>(enc));
        }
        return enc;
    }

    public char[] quoteAsString(String input2) {
        TextBuffer textBuffer = this._textBuffer;
        if (textBuffer == null) {
            this._textBuffer = textBuffer = new TextBuffer(null);
        }
        char[] outputBuffer = textBuffer.emptyAndGetCurrentSegment();
        int[] escCodes = sOutputEscapes128;
        int escCodeCount = escCodes.length;
        int inPtr = 0;
        int inputLen = input2.length();
        int outPtr = 0;
        block0: while (inPtr < inputLen) {
            int escCode;
            int length;
            char c;
            while ((c = input2.charAt(inPtr)) >= escCodeCount || escCodes[c] == 0) {
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = textBuffer.finishCurrentSegment();
                    outPtr = 0;
                }
                outputBuffer[outPtr++] = c;
                if (++inPtr < inputLen) continue;
                break block0;
            }
            if (outPtr + (length = this._appendSingleEscape(escCode = escCodes[input2.charAt(inPtr++)], this._quoteBuffer)) > outputBuffer.length) {
                int first = outputBuffer.length - outPtr;
                if (first > 0) {
                    System.arraycopy(this._quoteBuffer, 0, outputBuffer, outPtr, first);
                }
                outputBuffer = textBuffer.finishCurrentSegment();
                int second = length - first;
                System.arraycopy(this._quoteBuffer, first, outputBuffer, outPtr, second);
                outPtr += second;
                continue;
            }
            System.arraycopy(this._quoteBuffer, 0, outputBuffer, outPtr, length);
            outPtr += length;
        }
        textBuffer.setCurrentLength(outPtr);
        return textBuffer.contentsAsArray();
    }

    private int _appendSingleEscape(int escCode, char[] quoteBuffer) {
        if (escCode < 0) {
            int value = -(escCode + 1);
            quoteBuffer[1] = 117;
            quoteBuffer[4] = HEX_CHARS[value >> 4];
            quoteBuffer[5] = HEX_CHARS[value & 0xF];
            return 6;
        }
        quoteBuffer[1] = (char)escCode;
        return 2;
    }

    static {
        int[] table = new int[128];
        for (int i = 0; i < 32; ++i) {
            table[i] = -1;
        }
        table[34] = 34;
        table[92] = 92;
        table[8] = 98;
        table[9] = 116;
        table[12] = 102;
        table[10] = 110;
        table[13] = 114;
        sOutputEscapes128 = table;
        _threadEncoder = new ThreadLocal();
    }
}

