/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.field;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.elasticsearch.hadoop.serialization.field.IndexFormatter;
import org.elasticsearch.hadoop.util.Constants;
import org.elasticsearch.hadoop.util.DateUtils;
import org.elasticsearch.hadoop.util.StringUtils;

public class DateIndexFormatter
implements IndexFormatter {
    private String format;
    private SimpleDateFormat dateFormat;

    @Override
    public void configure(String format2) {
        this.format = format2;
        format2 = this.fixDateForJdk(format2);
        this.dateFormat = new SimpleDateFormat(format2);
    }

    private String fixDateForJdk(String format2) {
        if (Constants.JRE_IS_MINIMUM_JAVA7) {
            return format2;
        }
        if (format2.contains("Y")) {
            format2 = format2.replace("Y", "y");
        }
        format2 = format2.replaceAll("((?<!y)(?:y|yyy)(?!y))", "yyyy");
        return format2;
    }

    @Override
    public String format(String value) {
        if (!StringUtils.hasText(value)) {
            return null;
        }
        Calendar calendar = DateUtils.parseDate(value);
        this.dateFormat.setCalendar(calendar);
        return this.dateFormat.format(calendar.getTime());
    }
}

