/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.builder;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.elasticsearch.hadoop.serialization.Generator;
import org.elasticsearch.hadoop.serialization.builder.FilteringValueWriter;
import org.elasticsearch.hadoop.serialization.builder.ValueWriter;
import org.elasticsearch.hadoop.util.ObjectUtils;

public class JdkValueWriter
extends FilteringValueWriter<Object> {
    protected final boolean writeUnknownTypes;

    public JdkValueWriter() {
        this.writeUnknownTypes = false;
    }

    public JdkValueWriter(boolean writeUnknownTypes) {
        this.writeUnknownTypes = writeUnknownTypes;
    }

    @Override
    public ValueWriter.Result write(Object value, Generator generator) {
        return this.doWrite(value, generator, null);
    }

    protected ValueWriter.Result doWrite(Object value, Generator generator, String parentField) {
        if (value == null) {
            generator.writeNull();
        } else if (value instanceof String) {
            generator.writeString((String)value);
        } else if (value instanceof Integer) {
            generator.writeNumber((Integer)value);
        } else if (value instanceof Long) {
            generator.writeNumber((Long)value);
        } else if (value instanceof Float) {
            generator.writeNumber(((Float)value).floatValue());
        } else if (value instanceof Double) {
            generator.writeNumber((Double)value);
        } else if (value instanceof Short) {
            generator.writeNumber((Short)value);
        } else if (value instanceof Byte) {
            generator.writeNumber((Byte)value);
        } else if (value instanceof Number) {
            Number n = (Number)value;
            double d = n.doubleValue();
            if (Math.floor(d) == d) {
                generator.writeNumber(n.longValue());
            } else {
                generator.writeNumber(d);
            }
        } else if (value instanceof Boolean) {
            generator.writeBoolean((Boolean)value);
        } else if (value instanceof byte[]) {
            generator.writeBinary((byte[])value);
        } else if (value.getClass().isArray()) {
            generator.writeBeginArray();
            for (Object o : ObjectUtils.toObjectArray(value)) {
                ValueWriter.Result result2 = this.doWrite(o, generator, parentField);
                if (result2.isSuccesful()) continue;
                return result2;
            }
            generator.writeEndArray();
        } else if (value instanceof Map) {
            generator.writeBeginObject();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                String fieldName = entry.getKey().toString();
                if (!this.shouldKeep(parentField, fieldName)) continue;
                generator.writeFieldName(fieldName);
                ValueWriter.Result result3 = this.doWrite(entry.getValue(), generator, fieldName);
                if (result3.isSuccesful()) continue;
                return result3;
            }
            generator.writeEndObject();
        } else if (value instanceof Iterable) {
            generator.writeBeginArray();
            for (Object o : (Iterable)value) {
                ValueWriter.Result result4 = this.doWrite(o, generator, parentField);
                if (result4.isSuccesful()) continue;
                return result4;
            }
            generator.writeEndArray();
        } else if (value instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)value);
            generator.writeString(DatatypeConverter.printDateTime((Calendar)cal));
        } else if (value instanceof Calendar) {
            generator.writeString(DatatypeConverter.printDateTime((Calendar)((Calendar)value)));
        } else {
            if (this.writeUnknownTypes) {
                return this.handleUnknown(value, generator);
            }
            return ValueWriter.Result.FAILED(value);
        }
        return ValueWriter.Result.SUCCESFUL();
    }

    protected ValueWriter.Result handleUnknown(Object value, Generator generator) {
        generator.writeString(value.toString());
        return ValueWriter.Result.SUCCESFUL();
    }
}

