/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.EsHadoopException;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.handler.EsHadoopAbortHandlerException;
import org.elasticsearch.hadoop.handler.HandlerResult;
import org.elasticsearch.hadoop.rest.EsHadoopParsingException;
import org.elasticsearch.hadoop.serialization.FieldType;
import org.elasticsearch.hadoop.serialization.Parser;
import org.elasticsearch.hadoop.serialization.ParsingUtils;
import org.elasticsearch.hadoop.serialization.ScrollReaderConfigBuilder;
import org.elasticsearch.hadoop.serialization.builder.ValueParsingCallback;
import org.elasticsearch.hadoop.serialization.builder.ValueReader;
import org.elasticsearch.hadoop.serialization.dto.mapping.Mapping;
import org.elasticsearch.hadoop.serialization.field.FieldFilter;
import org.elasticsearch.hadoop.serialization.handler.SerdeErrorCollector;
import org.elasticsearch.hadoop.serialization.handler.read.DeserializationFailure;
import org.elasticsearch.hadoop.serialization.handler.read.IDeserializationErrorHandler;
import org.elasticsearch.hadoop.serialization.json.BlockAwareJsonParser;
import org.elasticsearch.hadoop.serialization.json.JacksonJsonParser;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.FastByteArrayInputStream;
import org.elasticsearch.hadoop.util.IOUtils;
import org.elasticsearch.hadoop.util.StringUtils;

public class ScrollReader
implements Closeable {
    private static final Log log = LogFactory.getLog(ScrollReader.class);
    private final ValueReader reader;
    private final ValueParsingCallback parsingCallback;
    private final Map<String, FieldType> esMapping;
    private final boolean trace = log.isTraceEnabled();
    private final boolean readMetadata;
    private boolean inMetadataSection;
    private final String metadataField;
    private final boolean returnRawJson;
    private final boolean ignoreUnmappedFields;
    private boolean insideGeo = false;
    private final List<FieldFilter.NumberedInclude> includeFields;
    private final List<String> excludeFields;
    private final List<FieldFilter.NumberedInclude> includeArrayFields;
    private List<IDeserializationErrorHandler> deserializationErrorHandlers;
    private static final String[] SCROLL_ID = new String[]{"_scroll_id"};
    private static final String[] HITS = new String[]{"hits"};
    private static final String ID_FIELD = "_id";
    private static final String[] ID = new String[]{"_id"};
    private static final String[] FIELDS = new String[]{"fields"};
    private static final String[] SOURCE = new String[]{"_source"};
    private static final String[] TOTAL = new String[]{"hits", "total"};

    public ScrollReader(ScrollReaderConfigBuilder scrollConfig) {
        this.reader = scrollConfig.getReader();
        this.parsingCallback = this.reader instanceof ValueParsingCallback ? (ValueParsingCallback)((Object)this.reader) : null;
        this.readMetadata = scrollConfig.getReadMetadata();
        this.metadataField = scrollConfig.getMetadataName();
        this.returnRawJson = scrollConfig.getReturnRawJson();
        this.ignoreUnmappedFields = scrollConfig.getIgnoreUnmappedFields();
        this.includeFields = FieldFilter.toNumberedFilter(scrollConfig.getIncludeFields());
        this.excludeFields = scrollConfig.getExcludeFields();
        this.includeArrayFields = FieldFilter.toNumberedFilter(scrollConfig.getIncludeArrayFields());
        Mapping mapping = scrollConfig.getResolvedMapping();
        if (mapping != null) {
            if (this.ignoreUnmappedFields) {
                mapping = mapping.filter(scrollConfig.getIncludeFields(), scrollConfig.getExcludeFields());
            }
            this.esMapping = mapping.flatten();
        } else {
            this.esMapping = Collections.emptyMap();
        }
        this.deserializationErrorHandlers = scrollConfig.getErrorHandlerLoader().loadHandlers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scroll read(InputStream content) throws IOException {
        Assert.notNull(content);
        BytesArray copy = IOUtils.asBytes(content);
        content = new FastByteArrayInputStream(copy);
        if (log.isTraceEnabled()) {
            log.trace((Object)("About to parse scroll content " + copy));
        }
        JacksonJsonParser parser = new JacksonJsonParser(content);
        try {
            Scroll scroll = this.read(parser, copy);
            return scroll;
        }
        finally {
            parser.close();
        }
    }

    private Scroll read(Parser parser, BytesArray input2) {
        Parser.Token token = ParsingUtils.seek(parser, SCROLL_ID);
        Assert.isTrue(token == Parser.Token.VALUE_STRING, "invalid response");
        String scrollId = parser.text();
        long totalHits = this.hitsTotal(parser);
        if (totalHits == 0L) {
            return Scroll.empty(scrollId);
        }
        token = ParsingUtils.seek(parser, HITS);
        Assert.isTrue(token == Parser.Token.START_ARRAY, "invalid response");
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        int responseHits = 0;
        int skippedHits = 0;
        int readHits = 0;
        token = parser.nextToken();
        while (token != Parser.Token.END_ARRAY) {
            ++responseHits;
            Object[] hit = this.readHit(parser, input2);
            if (hit != null) {
                ++readHits;
                results.add(hit);
            } else {
                ++skippedHits;
            }
            token = parser.nextToken();
        }
        if (this.returnRawJson) {
            int[] pos = new int[results.size() * 6];
            int offset = 0;
            ArrayList<int[]> fragmentsPos = new ArrayList<int[]>(results.size());
            for (Object[] result2 : results) {
                int[] asCharPos = ((JsonResult)result2[1]).asCharPos();
                fragmentsPos.add(asCharPos);
                System.arraycopy(asCharPos, 0, pos, offset, asCharPos.length);
                offset += asCharPos.length;
            }
            int[] bytesPosition = pos;
            int bytesPositionIndex = 0;
            BytesArray doc = new BytesArray(128);
            for (int fragmentIndex = 0; fragmentIndex < fragmentsPos.size(); ++fragmentIndex) {
                int rangeStart;
                int rangeStop;
                Object[] result3 = (Object[])results.get(fragmentIndex);
                JsonResult jsonPointers = (JsonResult)result3[1];
                int[] fragmentPos = (int[])fragmentsPos.get(fragmentIndex);
                int currentFragmentIndex = 0;
                doc.add(123);
                if (jsonPointers.hasDoc()) {
                    rangeStop = bytesPosition[bytesPositionIndex + 1];
                    rangeStart = bytesPosition[bytesPositionIndex];
                    if (rangeStop - rangeStart < 0) {
                        throw new IllegalArgumentException(String.format("Invalid position given=%s %s", rangeStart, rangeStop));
                    }
                    doc.add(input2.bytes(), rangeStart, rangeStop - rangeStart);
                    currentFragmentIndex += 2;
                    bytesPositionIndex += 2;
                }
                if (this.readMetadata) {
                    if (jsonPointers.hasDoc()) {
                        doc.add(44);
                    }
                    doc.add(34);
                    doc.add(StringUtils.jsonEncoding(this.metadataField));
                    doc.add(34);
                    doc.add(58);
                    doc.add(123);
                    while (currentFragmentIndex < fragmentPos.length) {
                        rangeStop = bytesPosition[bytesPositionIndex + 1];
                        rangeStart = bytesPosition[bytesPositionIndex];
                        if (rangeStop - rangeStart < 0) {
                            throw new IllegalArgumentException(String.format("Invalid position given=%s %s", rangeStart, rangeStop));
                        }
                        doc.add(input2.bytes(), rangeStart, rangeStop - rangeStart);
                        bytesPositionIndex += 2;
                        currentFragmentIndex += 2;
                    }
                    doc.add(125);
                }
                doc.add(125);
                result3[1] = this.reader.wrapString(doc.toString());
                doc.reset();
            }
        }
        if (responseHits > 0) {
            return new Scroll(scrollId, totalHits, results, responseHits, skippedHits);
        }
        return new Scroll(scrollId, totalHits, true);
    }

    private Object[] readHit(Parser parser, BytesArray input2) {
        Parser.Token t = parser.currentToken();
        Assert.isTrue(t == Parser.Token.START_OBJECT, "expected object, found " + (Object)((Object)t));
        int hitStartPos = parser.tokenCharOffset();
        BlockAwareJsonParser blockAwareJsonParser = new BlockAwareJsonParser(parser);
        Parser workingParser = blockAwareJsonParser;
        Object[] readResult = null;
        boolean retryRead = false;
        boolean skip = false;
        int attempts = 0;
        do {
            try {
                retryRead = false;
                if (this.returnRawJson) {
                    readResult = this.readHitAsJson(workingParser);
                    continue;
                }
                readResult = this.readHitAsMap(workingParser);
            }
            catch (Exception deserializationException) {
                if (workingParser == blockAwareJsonParser) {
                    blockAwareJsonParser.exitBlock();
                    t = blockAwareJsonParser.currentToken();
                    Assert.isTrue(t == Parser.Token.END_OBJECT, "expected end of object, found " + (Object)((Object)t));
                }
                int hitEndPos = parser.tokenCharOffset();
                BytesArray hitSection = new BytesArray(input2.bytes(), hitStartPos, hitEndPos - hitStartPos + 1);
                ArrayList<String> passReasons = new ArrayList<String>();
                DeserializationFailure event = new DeserializationFailure(deserializationException, hitSection, passReasons);
                SerdeErrorCollector errorCollector = new SerdeErrorCollector();
                retryRead = false;
                Exception abortException = deserializationException;
                block11: for (IDeserializationErrorHandler deserializationErrorHandler : this.deserializationErrorHandlers) {
                    HandlerResult result2;
                    try {
                        result2 = deserializationErrorHandler.onError(event, errorCollector);
                    }
                    catch (EsHadoopAbortHandlerException ahe) {
                        result2 = HandlerResult.ABORT;
                        abortException = new EsHadoopParsingException(ahe.getMessage(), ahe.getCause());
                    }
                    catch (Exception e) {
                        log.error((Object)"Could not handle deserialization error event due to an exception in error handler. Deserialization exception:", (Throwable)deserializationException);
                        throw new EsHadoopException("Encountered unexpected exception during error handler execution.", e);
                    }
                    switch (result2) {
                        case HANDLED: {
                            Assert.isTrue(errorCollector.getAndClearMessage() == null, "Found pass message with Handled response. Be sure to return the value returned from the pass(String) call.");
                            if (errorCollector.receivedRetries()) {
                                byte[] retryDataBuffer = (byte[])errorCollector.getAndClearRetryValue();
                                workingParser = retryDataBuffer == null || hitSection.bytes() == retryDataBuffer ? new JacksonJsonParser(event.getHitContents()) : new JacksonJsonParser(retryDataBuffer);
                                if (attempts >= 50) {
                                    throw new EsHadoopException("Maximum retry attempts (50) reached for deserialization errors.");
                                }
                                retryRead = true;
                                workingParser.nextToken();
                                ++attempts;
                                break block11;
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Skipping a scroll search hit that resulted in error while reading: [" + StringUtils.asUTFString(hitSection.bytes(), hitSection.offset(), hitSection.length()) + "]"));
                            } else {
                                log.info((Object)"Skipping a scroll search hit that resulted in error while reading. (DEBUG for more info).");
                            }
                            skip = true;
                            break block11;
                        }
                        case PASS: {
                            String reason = errorCollector.getAndClearMessage();
                            if (reason == null) continue block11;
                            passReasons.add(reason);
                            continue block11;
                        }
                        case ABORT: {
                            errorCollector.getAndClearMessage();
                            if (abortException instanceof EsHadoopParsingException) {
                                throw (EsHadoopParsingException)abortException;
                            }
                            throw new EsHadoopParsingException(abortException);
                        }
                        default: {
                            continue block11;
                        }
                    }
                }
            }
        } while (retryRead);
        if (readResult == null && !skip) {
            throw new EsHadoopParsingException("Could not read hit from scroll response.");
        }
        return readResult;
    }

    private Object[] readHitAsMap(Parser parser) {
        String name;
        Object[] result2 = new Object[2];
        Object metadata = null;
        Object id = null;
        Parser.Token t = parser.currentToken();
        if (this.parsingCallback != null) {
            this.parsingCallback.beginDoc();
        }
        if (this.readMetadata) {
            if (this.parsingCallback != null) {
                this.parsingCallback.beginLeadMetadata();
            }
            this.inMetadataSection = true;
            result2[1] = metadata = this.reader.createMap();
            t = parser.nextToken();
            while ((t = parser.currentToken()) != null) {
                name = parser.currentName();
                String absoluteName = StringUtils.stripFieldNameSourcePrefix(parser.absoluteName());
                Object value = null;
                if (t == Parser.Token.FIELD_NAME) {
                    if (!"fields".equals(name) && !"_source".equals(name)) {
                        this.reader.beginField(absoluteName);
                        value = this.read(absoluteName, parser.nextToken(), null, parser);
                        if (ID_FIELD.equals(name)) {
                            id = value;
                        }
                        this.reader.addToMap(metadata, this.reader.wrapString(name), value);
                        this.reader.endField(absoluteName);
                        continue;
                    }
                    t = parser.nextToken();
                    break;
                }
                t = null;
                break;
            }
            this.inMetadataSection = false;
            if (this.parsingCallback != null) {
                this.parsingCallback.endLeadMetadata();
            }
            Assert.notNull(id, "no id found");
            result2[0] = id;
        } else {
            Assert.notNull((Object)ParsingUtils.seek(parser, ID), "no id found");
            result2[0] = this.reader.wrapString(parser.text());
            t = ParsingUtils.seek(parser, SOURCE, FIELDS);
        }
        Object data = Collections.emptyMap();
        if (t != null) {
            if (this.parsingCallback != null) {
                this.parsingCallback.beginSource();
            }
            data = this.read("", t, null, parser);
            if (this.parsingCallback != null) {
                this.parsingCallback.endSource();
            }
            if (this.readMetadata) {
                this.reader.addToMap(data, this.reader.wrapString(this.metadataField), metadata);
            }
        } else if (this.readMetadata) {
            if (this.parsingCallback != null) {
                this.parsingCallback.excludeSource();
            }
            data = this.reader.createMap();
            this.reader.addToMap(data, this.reader.wrapString(this.metadataField), metadata);
        }
        result2[1] = data;
        if (this.readMetadata) {
            if (this.parsingCallback != null) {
                this.parsingCallback.beginTrailMetadata();
            }
            this.inMetadataSection = true;
        }
        while (parser.currentToken() == Parser.Token.FIELD_NAME) {
            name = parser.currentName();
            String absoluteName = StringUtils.stripFieldNameSourcePrefix(parser.absoluteName());
            if (this.readMetadata) {
                if (!"sort".equals(name)) {
                    this.reader.addToMap(data, this.reader.wrapString(name), this.read(absoluteName, parser.nextToken(), null, parser));
                    continue;
                }
                parser.nextToken();
                parser.skipChildren();
                parser.nextToken();
                continue;
            }
            parser.nextToken();
            parser.skipChildren();
            parser.nextToken();
        }
        if (this.readMetadata) {
            this.inMetadataSection = false;
            if (this.parsingCallback != null) {
                this.parsingCallback.endTrailMetadata();
            }
        }
        if (this.parsingCallback != null) {
            this.parsingCallback.endDoc();
        }
        if (this.trace) {
            log.trace((Object)String.format("Read hit result [%s]", result2));
        }
        return result2;
    }

    private boolean shouldSkip(String absoluteName) {
        if (this.insideGeo) {
            return false;
        }
        if (this.ignoreUnmappedFields) {
            return !this.esMapping.containsKey(absoluteName);
        }
        return !FieldFilter.filter((String)absoluteName, this.includeFields, this.excludeFields).matched;
    }

    private Object[] readHitAsJson(Parser parser) {
        Object[] result2 = new Object[2];
        Object id = null;
        Parser.Token t = parser.currentToken();
        JsonResult snippet = new JsonResult();
        if (this.readMetadata) {
            result2[1] = snippet;
            t = parser.nextToken();
            int metadataStartChar = parser.tokenCharOffset();
            int metadataStopChar = -1;
            int endCharOfLastElement = -1;
            while ((t = parser.currentToken()) != null) {
                String name = parser.currentName();
                String absoluteName = StringUtils.stripFieldNameSourcePrefix(parser.absoluteName());
                if (t == Parser.Token.FIELD_NAME) {
                    if (ID_FIELD.equals(name)) {
                        this.reader.beginField(absoluteName);
                        t = parser.nextToken();
                        id = this.reader.wrapString(parser.text());
                        endCharOfLastElement = parser.tokenCharOffset();
                        this.reader.endField(absoluteName);
                        t = parser.nextToken();
                        continue;
                    }
                    if ("fields".equals(name) || "_source".equals(name)) {
                        metadataStopChar = endCharOfLastElement;
                        t = parser.nextToken();
                        break;
                    }
                    parser.skipChildren();
                    parser.nextToken();
                    t = parser.nextToken();
                    endCharOfLastElement = parser.tokenCharOffset();
                    continue;
                }
                metadataStopChar = endCharOfLastElement;
                t = null;
                break;
            }
            Assert.notNull(id, "no id found");
            result2[0] = id;
            if (metadataStartChar >= 0 && metadataStopChar >= 0) {
                snippet.addMetadata(new JsonFragment(metadataStartChar, metadataStopChar));
            }
        } else {
            Assert.notNull((Object)ParsingUtils.seek(parser, ID), "no id found");
            String absoluteName = StringUtils.stripFieldNameSourcePrefix(parser.absoluteName());
            this.reader.beginField(absoluteName);
            result2[0] = this.reader.wrapString(parser.text());
            this.reader.endField(absoluteName);
            t = ParsingUtils.seek(parser, SOURCE, FIELDS);
        }
        if (t != null) {
            t = parser.nextToken();
            switch (t) {
                case FIELD_NAME: {
                    int charStart = parser.tokenCharOffset();
                    ParsingUtils.skipCurrentBlock(parser);
                    int charStop = parser.tokenCharOffset();
                    t = parser.nextToken();
                    snippet.addDoc(new JsonFragment(charStart, charStop));
                    break;
                }
                case END_OBJECT: {
                    t = parser.nextToken();
                    snippet.addDoc(JsonFragment.EMPTY);
                    break;
                }
                default: {
                    throw new EsHadoopIllegalArgumentException("unexpected token in _source: " + (Object)((Object)t));
                }
            }
        }
        int metadataSuffixStartCharPos = parser.tokenCharOffset();
        int metadataSuffixStopCharPos = -1;
        while ((t = parser.currentToken()) == Parser.Token.FIELD_NAME) {
            t = parser.nextToken();
            ParsingUtils.skipCurrentBlock(parser);
            t = parser.nextToken();
            if (!this.readMetadata) continue;
            metadataSuffixStopCharPos = parser.tokenCharOffset();
        }
        if (this.readMetadata && metadataSuffixStartCharPos >= 0 && metadataSuffixStopCharPos >= 0) {
            snippet.addMetadata(new JsonFragment(metadataSuffixStartCharPos, metadataSuffixStopCharPos));
        }
        result2[1] = snippet;
        if (this.trace) {
            log.trace((Object)String.format("Read hit result [%s]", result2));
        }
        return result2;
    }

    private long hitsTotal(Parser parser) {
        ParsingUtils.seek(parser, TOTAL);
        long hits = Long.MIN_VALUE;
        Parser.Token token = parser.currentToken();
        if (token == Parser.Token.START_OBJECT) {
            String relation = null;
            token = parser.nextToken();
            while (token != Parser.Token.END_OBJECT) {
                if (token == Parser.Token.FIELD_NAME) {
                    if ("value".equals(parser.currentName())) {
                        parser.nextToken();
                        hits = parser.longValue();
                    } else if ("relation".equals(parser.currentName())) {
                        parser.nextToken();
                        relation = parser.text();
                    } else {
                        parser.nextToken();
                    }
                } else if (token == Parser.Token.START_OBJECT || token == Parser.Token.START_ARRAY) {
                    parser.skipChildren();
                }
                token = parser.nextToken();
            }
            if (relation == null) {
                throw new EsHadoopParsingException("Could not discern relative value of total hits. Response missing [relation] field.");
            }
            if (!"eq".equals(relation)) {
                throw new EsHadoopParsingException(String.format("Could not discern exact hit count for search response. Received [%s][%s]", relation, hits));
            }
        } else if (token == Parser.Token.VALUE_NUMBER) {
            hits = parser.longValue();
        }
        if (hits == Long.MIN_VALUE) {
            throw new EsHadoopParsingException("Could not locate total number of hits for search result.");
        }
        return hits;
    }

    protected Object read(String fieldName, Parser.Token t, String fieldMapping, Parser parser) {
        if (t == Parser.Token.START_ARRAY) {
            return this.list(fieldName, fieldMapping, parser);
        }
        if (t == Parser.Token.START_OBJECT) {
            FieldType esType = this.mapping(fieldMapping, parser);
            if (esType != null && esType.equals((Object)FieldType.NESTED) || this.isArrayField(fieldMapping)) {
                return this.singletonList(fieldMapping, this.map(fieldMapping, parser), parser);
            }
            return this.map(fieldMapping, parser);
        }
        FieldType esType = this.mapping(fieldMapping, parser);
        if (t.isValue()) {
            String rawValue = parser.text();
            try {
                if (this.isArrayField(fieldMapping)) {
                    return this.singletonList(fieldMapping, this.parseValue(parser, esType), parser);
                }
                return this.parseValue(parser, esType);
            }
            catch (Exception ex) {
                throw new EsHadoopParsingException(String.format(Locale.ROOT, "Cannot parse value [%s] for field [%s]", rawValue, fieldName), ex);
            }
        }
        return null;
    }

    protected Object readListItem(String fieldName, Parser.Token t, String fieldMapping, Parser parser) {
        if (t == Parser.Token.START_ARRAY) {
            return this.list(fieldName, fieldMapping, parser);
        }
        if (t == Parser.Token.START_OBJECT) {
            return this.map(fieldMapping, parser);
        }
        FieldType esType = this.mapping(fieldMapping, parser);
        if (t.isValue()) {
            String rawValue = parser.text();
            try {
                return this.parseValue(parser, esType);
            }
            catch (Exception ex) {
                throw new EsHadoopParsingException(String.format(Locale.ROOT, "Cannot parse value [%s] for field [%s]", rawValue, fieldName), ex);
            }
        }
        return null;
    }

    private boolean isArrayField(String fieldName) {
        if (fieldName != null && this.includeArrayFields != null && !this.includeArrayFields.isEmpty()) {
            return FieldFilter.filter((String)fieldName, this.includeArrayFields, null, (boolean)false).matched;
        }
        return false;
    }

    private Object parseValue(Parser parser, FieldType esType) {
        Object obj = parser.currentToken() == Parser.Token.VALUE_NULL ? null : this.reader.readValue(parser, parser.text(), esType);
        parser.nextToken();
        return obj;
    }

    protected Object list(String fieldName, String fieldMapping, Parser parser) {
        Parser.Token t = parser.currentToken();
        if (t == null) {
            t = parser.nextToken();
        }
        if (t == Parser.Token.START_ARRAY) {
            t = parser.nextToken();
        }
        Object array = this.reader.createArray(this.mapping(fieldMapping, parser));
        ArrayList<Object> content = new ArrayList<Object>(1);
        while (parser.currentToken() != Parser.Token.END_ARRAY) {
            content.add(this.readListItem(fieldName, parser.currentToken(), fieldMapping, parser));
        }
        parser.nextToken();
        array = this.reader.addToArray(array, content);
        return array;
    }

    protected Object singletonList(String fieldMapping, Object value, Parser parser) {
        Object array = this.reader.createArray(this.mapping(fieldMapping, parser));
        ArrayList<Object> content = new ArrayList<Object>(1);
        content.add(value);
        array = this.reader.addToArray(array, content);
        return array;
    }

    protected Object map(String fieldMapping, Parser parser) {
        Parser.Token t = parser.currentToken();
        if (t == null) {
            t = parser.nextToken();
        }
        if (t == Parser.Token.START_OBJECT) {
            t = parser.nextToken();
        }
        boolean toggleGeo = false;
        if (fieldMapping != null && FieldType.isGeo(this.mapping(fieldMapping, parser))) {
            toggleGeo = true;
            this.insideGeo = true;
            if (this.parsingCallback != null) {
                this.parsingCallback.beginGeoField();
            }
        }
        Object map2 = this.reader.createMap();
        while (parser.currentToken() != Parser.Token.END_OBJECT) {
            String currentName = parser.currentName();
            String nodeMapping = fieldMapping;
            nodeMapping = nodeMapping != null ? fieldMapping + "." + currentName : currentName;
            String absoluteName = StringUtils.stripFieldNameSourcePrefix(parser.absoluteName());
            if (!absoluteName.equals(nodeMapping)) {
                throw new EsHadoopParsingException("Different node mapping " + absoluteName + "|" + nodeMapping);
            }
            if (this.shouldSkip(absoluteName)) {
                Parser.Token nt = parser.nextToken();
                if (nt.isValue()) {
                    parser.nextToken();
                    continue;
                }
                ParsingUtils.skipCurrentBlock(parser);
                parser.nextToken();
                continue;
            }
            this.reader.beginField(absoluteName);
            Object fieldName = this.reader.readValue(parser, currentName, FieldType.STRING);
            this.reader.addToMap(map2, fieldName, this.read(absoluteName, parser.nextToken(), nodeMapping, parser));
            this.reader.endField(absoluteName);
        }
        if (toggleGeo) {
            this.insideGeo = false;
            if (this.parsingCallback != null) {
                this.parsingCallback.endGeoField();
            }
        }
        parser.nextToken();
        return map2;
    }

    private FieldType mapping(String fieldMapping, Parser parser) {
        FieldType esType = this.esMapping.get(fieldMapping);
        if (esType != null) {
            return esType;
        }
        Parser.Token currentToken = parser.currentToken();
        if (!currentToken.isValue()) {
            return FieldType.OBJECT;
        }
        if (this.inMetadataSection) {
            return FieldType.STRING;
        }
        block0 : switch (currentToken) {
            case VALUE_NULL: {
                esType = FieldType.NULL;
                break;
            }
            case VALUE_BOOLEAN: {
                esType = FieldType.BOOLEAN;
                break;
            }
            case VALUE_STRING: {
                esType = FieldType.STRING;
                break;
            }
            case VALUE_NUMBER: {
                Parser.NumberType numberType = parser.numberType();
                switch (numberType) {
                    case INT: {
                        esType = FieldType.INTEGER;
                        break block0;
                    }
                    case LONG: {
                        esType = FieldType.LONG;
                        break block0;
                    }
                    case FLOAT: {
                        esType = FieldType.FLOAT;
                        break block0;
                    }
                    case DOUBLE: {
                        esType = FieldType.DOUBLE;
                        break block0;
                    }
                    case BIG_DECIMAL: {
                        throw new UnsupportedOperationException();
                    }
                    case BIG_INTEGER: {
                        throw new UnsupportedOperationException();
                    }
                }
                break;
            }
        }
        return esType;
    }

    @Override
    public void close() {
        for (IDeserializationErrorHandler handler : this.deserializationErrorHandlers) {
            handler.close();
        }
    }

    public static class Scroll {
        private final String scrollId;
        private final long total;
        private final List<Object[]> hits;
        private final boolean concluded;
        private final int numberOfHits;
        private final int numberOfSkippedHits;

        static Scroll empty(String scrollId) {
            return new Scroll(scrollId, 0L, true);
        }

        public Scroll(String scrollId, long total, boolean concluded) {
            this.scrollId = scrollId;
            this.total = total;
            this.hits = Collections.emptyList();
            this.concluded = concluded;
            this.numberOfHits = 0;
            this.numberOfSkippedHits = 0;
        }

        public Scroll(String scrollId, long total, List<Object[]> hits, int responseHits, int skippedHits) {
            this.scrollId = scrollId;
            this.hits = hits;
            this.total = total;
            this.concluded = false;
            this.numberOfHits = responseHits;
            this.numberOfSkippedHits = skippedHits;
        }

        public String getScrollId() {
            return this.scrollId;
        }

        public long getTotalHits() {
            return this.total;
        }

        public List<Object[]> getHits() {
            return this.hits;
        }

        public boolean isConcluded() {
            return this.concluded;
        }

        public int getNumberOfHits() {
            return this.numberOfHits;
        }

        public int getNumberOfSkippedHits() {
            return this.numberOfSkippedHits;
        }
    }

    private static class JsonResult {
        private JsonFragment doc = JsonFragment.EMPTY;
        private final List<JsonFragment> fragments = new ArrayList<JsonFragment>(2);

        private JsonResult() {
        }

        void addMetadata(JsonFragment fragment) {
            if (fragment != null && fragment.isValid()) {
                this.fragments.add(fragment);
            }
        }

        void addDoc(JsonFragment fragment) {
            if (fragment != null && fragment.isValid()) {
                this.doc = fragment;
            }
        }

        boolean hasDoc() {
            return this.doc.isValid();
        }

        int[] asCharPos() {
            int positions = this.fragments.size() << 1;
            if (this.doc.isValid()) {
                positions += 2;
            }
            int[] pos = new int[positions];
            int index = 0;
            if (this.doc.isValid()) {
                pos[index++] = this.doc.charStart;
                pos[index++] = this.doc.charStop;
            }
            for (JsonFragment fragment : this.fragments) {
                pos[index++] = fragment.charStart;
                pos[index++] = fragment.charStop;
            }
            return pos;
        }

        public String toString() {
            return "doc=" + this.doc + "metadata=" + this.fragments;
        }
    }

    private static class JsonFragment {
        static final JsonFragment EMPTY = new JsonFragment(-1, -1){

            @Override
            public String toString() {
                return "Empty";
            }
        };
        final int charStart;
        final int charStop;

        JsonFragment(int charStart, int charStop) {
            this.charStart = charStart;
            this.charStop = charStop;
        }

        boolean isValid() {
            return this.charStart >= 0 && this.charStop >= 0;
        }

        public String toString() {
            return "[" + this.charStart + "," + this.charStop + "]";
        }
    }
}

