/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.security;

import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.elasticsearch.hadoop.EsHadoopException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.security.EsToken;
import org.elasticsearch.hadoop.security.JdkUserProvider;
import org.elasticsearch.hadoop.security.User;
import org.elasticsearch.hadoop.security.UserProvider;

public class JdkUser
implements User {
    private final Subject subject;
    private final Settings providerSettings;

    public JdkUser(Subject subject, Settings providerSettings) {
        this.subject = subject;
        this.providerSettings = providerSettings;
    }

    @Override
    public <T> T doAs(PrivilegedAction<T> action) {
        return Subject.doAs(this.subject, action);
    }

    @Override
    public <T> T doAs(PrivilegedExceptionAction<T> action) throws EsHadoopException {
        try {
            return Subject.doAs(this.subject, action);
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof EsHadoopException) {
                throw (EsHadoopException)e.getCause();
            }
            throw new EsHadoopException(e.getCause());
        }
    }

    @Override
    public EsToken getEsToken(String clusterName) {
        if (clusterName == null || clusterName.equals("") || clusterName.equals("!UNNAMED!")) {
            return null;
        }
        Set<EsTokenHolder> credSet = this.subject.getPrivateCredentials(EsTokenHolder.class);
        if (credSet.isEmpty()) {
            return null;
        }
        EsTokenHolder holder = credSet.iterator().next();
        return holder.getCred(clusterName);
    }

    @Override
    public Iterable<EsToken> getAllEsTokens() {
        Set<EsTokenHolder> credSet = this.subject.getPrivateCredentials(EsTokenHolder.class);
        if (credSet.isEmpty()) {
            return Collections.emptyList();
        }
        EsTokenHolder holder = credSet.iterator().next();
        ArrayList<EsToken> tokens = new ArrayList<EsToken>();
        tokens.addAll(holder.getCreds());
        return Collections.unmodifiableList(tokens);
    }

    @Override
    public void addEsToken(EsToken esToken) {
        Iterator<EsTokenHolder> credSet = this.subject.getPrivateCredentials(EsTokenHolder.class).iterator();
        EsTokenHolder creds = null;
        if (credSet.hasNext()) {
            creds = credSet.next();
        } else {
            creds = new EsTokenHolder();
            this.subject.getPrivateCredentials().add(creds);
        }
        creds.setCred(esToken.getClusterName(), esToken);
    }

    @Override
    public String getUserName() {
        KerberosPrincipal principal = this.getKerberosPrincipal();
        if (principal == null) {
            return null;
        }
        return principal.getName();
    }

    @Override
    public KerberosPrincipal getKerberosPrincipal() {
        Iterator<KerberosPrincipal> iter2 = this.subject.getPrincipals(KerberosPrincipal.class).iterator();
        if (iter2.hasNext()) {
            return iter2.next();
        }
        return null;
    }

    @Override
    public boolean isProxyUser() {
        return false;
    }

    @Override
    public UserProvider getRealUserProvider() {
        JdkUserProvider sameProvider = new JdkUserProvider();
        sameProvider.setSettings(this.providerSettings);
        return sameProvider;
    }

    public String toString() {
        return "JdkUser{subject=" + this.subject + '}';
    }

    static class EsTokenHolder {
        private Map<String, EsToken> creds = new HashMap<String, EsToken>();

        EsTokenHolder() {
        }

        EsToken getCred(String alias) {
            return this.creds.get(alias);
        }

        Collection<EsToken> getCreds() {
            return this.creds.values();
        }

        void setCred(String alias, EsToken cred) {
            this.creds.put(alias, cred);
        }
    }
}

