/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest.query;

import java.io.IOException;
import org.elasticsearch.hadoop.rest.query.QueryBuilder;
import org.elasticsearch.hadoop.rest.query.QueryStringQueryBuilder;
import org.elasticsearch.hadoop.rest.query.RawQueryBuilder;
import org.elasticsearch.hadoop.util.Assert;

public class SimpleQueryParser {
    public static QueryBuilder parse(String raw2, boolean isQuery) throws IOException {
        if (raw2.startsWith("?")) {
            return SimpleQueryParser.parseURI(raw2.substring(1));
        }
        if (raw2.startsWith("{")) {
            return new RawQueryBuilder(raw2, isQuery);
        }
        throw new IllegalArgumentException("Failed to parse query: " + raw2);
    }

    static QueryBuilder parseURI(String raw2) {
        QueryStringQueryBuilder builder = new QueryStringQueryBuilder();
        for (String token : raw2.split("&")) {
            int indexOf2 = token.indexOf("=");
            Assert.isTrue(indexOf2 > 0, String.format("Cannot token [%s] in uri query [%s]", token, raw2));
            String name = token.substring(0, indexOf2);
            String value = token.substring(indexOf2 + 1);
            SimpleQueryParser.applyURIParameter(builder, name, value);
        }
        return builder;
    }

    static void applyURIParameter(QueryStringQueryBuilder builder, String name, String value) {
        if (name.equals("q") || name.equals("query")) {
            builder.query(value);
        } else if (name.equals("df") || name.equals("default_field")) {
            builder.defaultField(value);
        } else if (name.equals("analyzer") || name.equals("analyzer")) {
            builder.analyzer(value);
        } else if (name.equals("lowercase_expanded_terms") || name.equals("lowercase_expanded_terms")) {
            builder.lowercaseExpandedTerms(Boolean.parseBoolean(value.trim()));
        } else if (name.equals("analyze_wildcard") || name.equals("analyze_wildcard")) {
            builder.analyzeWildcard(Boolean.parseBoolean(value.trim()));
        } else if (name.equals("default_operator") || name.equals("default_operator")) {
            builder.defaultOperator(value);
        } else if (name.equals("lenient") || name.equals("lenient")) {
            builder.lenient(Boolean.parseBoolean(value.trim()));
        } else {
            throw new IllegalArgumentException("Unknown " + name + " parameter; please change the URI query into a Query DLS (see 'Query String Query')");
        }
    }
}

