/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.hadoop.rest.query.BoolQueryBuilder;
import org.elasticsearch.hadoop.rest.query.QueryBuilder;
import org.elasticsearch.hadoop.serialization.Generator;

public class FilteredQueryBuilder
extends QueryBuilder {
    private QueryBuilder query;
    private final List<QueryBuilder> filters = new ArrayList<QueryBuilder>();

    public FilteredQueryBuilder query(QueryBuilder value) {
        if (value == null) {
            throw new IllegalArgumentException("inner clause [query] cannot be null.");
        }
        this.query = value;
        return this;
    }

    public FilteredQueryBuilder filters(Collection<QueryBuilder> values2) {
        this.filters.addAll(values2);
        return this;
    }

    @Override
    public void toJson(Generator out) {
        if (this.query == null) {
            throw new IllegalArgumentException("inner clause [query] cannot be null.");
        }
        out.writeFieldName("filtered");
        out.writeBeginObject();
        out.writeFieldName("query");
        out.writeBeginObject();
        this.query.toJson(out);
        out.writeEndObject();
        if (!this.filters.isEmpty()) {
            out.writeFieldName("filter");
            out.writeBeginObject();
            if (this.filters.size() == 1) {
                this.filters.get(0).toJson(out);
            } else {
                BoolQueryBuilder inner2 = new BoolQueryBuilder();
                for (QueryBuilder filter2 : this.filters) {
                    inner2.must(filter2);
                }
                inner2.toJson(out);
            }
            out.writeEndObject();
        }
        out.writeEndObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilteredQueryBuilder that = (FilteredQueryBuilder)o;
        if (this.query != null ? !this.query.equals(that.query) : that.query != null) {
            return false;
        }
        return this.filters != null ? this.filters.equals(that.filters) : that.filters == null;
    }

    public int hashCode() {
        int result2 = this.query != null ? this.query.hashCode() : 0;
        result2 = 31 * result2 + (this.filters != null ? this.filters.hashCode() : 0);
        return result2;
    }
}

