/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.util.StringUtils;

public final class HeaderProcessor {
    private static final Log LOG = LogFactory.getLog(HeaderProcessor.class);
    private final List<Header> headers;

    public HeaderProcessor(Settings settings) {
        HashMap<String, String> workingHeaders = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : settings.asProperties().entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith("es.net.http.header.")) continue;
            String string2 = key.substring("es.net.http.header.".length());
            this.validateName(string2, entry);
            this.ensureNotReserved(string2, workingHeaders);
            workingHeaders.put(string2, this.extractHeaderValue(entry.getValue()));
        }
        this.headers = new ArrayList<Header>(workingHeaders.keySet().size());
        for (Map.Entry<Object, Object> entry : workingHeaders.entrySet()) {
            this.headers.add(new Header((String)entry.getKey(), (String)entry.getValue()));
        }
        for (Iterator<Map.Entry<Object, Object>> iterator2 : ReservedHeaders.values()) {
            this.headers.add(new Header(((ReservedHeaders)((Object)iterator2)).getName(), ((ReservedHeaders)((Object)iterator2)).getDefaultValue()));
        }
    }

    private void validateName(String headerName, Map.Entry<Object, Object> property) {
        if (!StringUtils.hasText(headerName)) {
            throw new EsHadoopIllegalArgumentException(String.format("Found configuration entry denoting a header prefix, but no header was given after the prefix. Please add a header name for the configuration entry : [%s] = [%s]", property.getKey(), property.getValue()));
        }
    }

    private void ensureNotReserved(String headerName, Map<String, String> existingHeaders) {
        if (existingHeaders.containsKey(headerName)) {
            throw new EsHadoopIllegalArgumentException(String.format("Could not set header [%s]: Header value [%s] is already present from a previous setting. Please submit multiple header values as a comma (,) separated list on the propertyvalue.", headerName, existingHeaders.get(headerName)));
        }
        if (ReservedHeaders.byName().containsKey(headerName)) {
            throw new EsHadoopIllegalArgumentException(String.format("Could not set header [%s]: This header is a reserved header. Reason: %s.", headerName, ReservedHeaders.byName().get(headerName).getReasonReserved()));
        }
    }

    private String extractHeaderValue(Object object) {
        String value;
        if (object instanceof Object[]) {
            StringBuilder sb = new StringBuilder();
            for (Object o : (Object[])object) {
                sb.append(o.toString()).append(',');
            }
            value = sb.substring(0, sb.length() - 1);
        } else {
            value = object.toString();
        }
        return value;
    }

    public HttpMethod applyTo(HttpMethod method) {
        for (Header header : this.headers) {
            method.setRequestHeader(header);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Added HTTP Headers to method: " + Arrays.toString(method.getRequestHeaders())));
        }
        return method;
    }

    private static enum ReservedHeaders {
        CONTENT_TYPE("Content-Type", "application/json", "ES-Hadoop communicates in JSON format only"),
        ACCEPT("Accept", "application/json", "ES-Hadoop communicates in JSON format only");

        private static final Map<String, ReservedHeaders> NAME_MAP;
        private final String name;
        private final String defaultValue;
        private final String reasonReserved;

        public static Map<String, ReservedHeaders> byName() {
            return NAME_MAP;
        }

        private ReservedHeaders(String name, String defaultValue, String reasonReserved) {
            this.name = name;
            this.defaultValue = defaultValue;
            this.reasonReserved = reasonReserved;
        }

        public String getName() {
            return this.name;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getReasonReserved() {
            return this.reasonReserved;
        }

        public String toString() {
            return "ReservedHeaders{name='" + this.name + '\'' + '}';
        }

        static {
            NAME_MAP = new HashMap<String, ReservedHeaders>();
            for (ReservedHeaders reservedHeaders : ReservedHeaders.values()) {
                NAME_MAP.put(reservedHeaders.name, reservedHeaders);
            }
        }
    }
}

