/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.io.IOException;
import java.io.InputStream;
import org.elasticsearch.hadoop.rest.stats.Stats;
import org.elasticsearch.hadoop.rest.stats.StatsAware;

public class DelegatingInputStream
extends InputStream
implements StatsAware {
    private final InputStream delegate;
    private final Stats stats = new Stats();

    public DelegatingInputStream(InputStream delegate) {
        this.delegate = delegate;
    }

    @Override
    public int read() throws IOException {
        return this.delegate != null ? this.delegate.read() : -1;
    }

    public int hashCode() {
        return this.delegate != null ? this.delegate.hashCode() : 0;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int result2;
        int n = result2 = this.delegate != null ? this.delegate.read(b) : -1;
        if (result2 > 0) {
            this.stats.bytesReceived += (long)result2;
        }
        return result2;
    }

    public boolean equals(Object obj) {
        return this.delegate != null ? this.delegate.equals(obj) : obj == null;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result2;
        int n = result2 = this.delegate != null ? this.delegate.read(b, off, len) : -1;
        if (result2 > 0) {
            this.stats.bytesReceived += (long)result2;
        }
        return result2;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.delegate != null ? this.delegate.skip(n) : -1L;
    }

    @Override
    public int available() throws IOException {
        return this.delegate != null ? this.delegate.available() : 0;
    }

    public String toString() {
        return this.delegate != null ? this.delegate.toString() : "null";
    }

    @Override
    public void close() throws IOException {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    @Override
    public void mark(int readlimit) {
        if (this.delegate != null) {
            this.delegate.mark(readlimit);
        }
    }

    @Override
    public void reset() throws IOException {
        if (this.delegate != null) {
            this.delegate.reset();
        }
    }

    @Override
    public boolean markSupported() {
        return this.delegate != null ? this.delegate.markSupported() : false;
    }

    public boolean isNull() {
        return this.delegate == null;
    }

    public InputStream delegate() {
        return this.delegate;
    }

    @Override
    public Stats stats() {
        return this.stats;
    }
}

