/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.mr;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;

public abstract class HadoopIOUtils {
    private static Log log = LogFactory.getLog(HadoopIOUtils.class);

    public static InputStream open(String resource, Configuration conf) {
        ClassLoader loader = conf.getClassLoader();
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if (loader == null) {
            loader = HadoopIOUtils.class.getClassLoader();
        }
        boolean trace = log.isTraceEnabled();
        try {
            if (!resource.contains(":")) {
                InputStream result2 = loader.getResourceAsStream(resource);
                if (result2 != null) {
                    if (trace) {
                        log.trace((Object)String.format("Loaded resource %s from classpath", resource));
                    }
                    return result2;
                }
                URI[] uris = DistributedCache.getCacheFiles((Configuration)conf);
                if (uris != null) {
                    for (URI uri : uris) {
                        if (!uri.toString().contains(resource)) continue;
                        if (trace) {
                            log.trace((Object)String.format("Loaded resource %s from distributed cache", resource));
                        }
                        return uri.toURL().openStream();
                    }
                }
            }
            Path p = new Path(resource);
            FileSystem fs = p.getFileSystem(conf);
            return fs.open(p);
        }
        catch (IOException ex) {
            throw new EsHadoopIllegalArgumentException(String.format("Cannot open stream for resource %s", resource));
        }
    }
}

