/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.spark.feishu;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001B\u0001\u0003\u00015\u0011ABR3jg\",8\t\\5f]RT!a\u0001\u0003\u0002\r\u0019,\u0017n\u001d5v\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u0005I1/Z1uk:tW\r\u001c\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0003\u0005\u0016\u0001\t\u0005\t\u0015!\u0003\u0017\u0003\u0015\t\u0007\u000f]%e!\t9\"D\u0004\u0002\u00101%\u0011\u0011\u0004E\u0001\u0007!J,G-\u001a4\n\u0005ma\"AB*ue&twM\u0003\u0002\u001a!!Aa\u0004\u0001B\u0001B\u0003%a#A\u0005baB\u001cVm\u0019:fi\")\u0001\u0005\u0001C\u0001C\u00051A(\u001b8jiz\"2A\t\u0013&!\t\u0019\u0003!D\u0001\u0003\u0011\u0015)r\u00041\u0001\u0017\u0011\u0015qr\u00041\u0001\u0017\u0011\u001d9\u0003A1A\u0005\u0002!\na\u0001\\8hO\u0016\u0014X#A\u0015\u0011\u0005)jS\"A\u0016\u000b\u00051R\u0011!B:mMRR\u0017B\u0001\u0018,\u0005\u0019aunZ4fe\"1\u0001\u0007\u0001Q\u0001\n%\nq\u0001\\8hO\u0016\u0014\b\u0005C\u00033\u0001\u0011\u00051'\u0001\u0005hKR$vn[3o+\u00051\u0002\"B\u001b\u0001\t\u00031\u0014AC4fiNCW-\u001a;JIR\u0019acN\u001d\t\u000ba\"\u0004\u0019\u0001\f\u0002\u0015MDW-\u001a;U_.,g\u000eC\u0003;i\u0001\u00071(\u0001\u0005tQ\u0016,GOT;n!\tyA(\u0003\u0002>!\t\u0019\u0011J\u001c;\t\u000b}\u0002A\u0011\u0001!\u0002\u0019\u001d,Go\u00155fKR$\u0015\r^1\u0015\t\u0005{\u0005K\u0015\t\u0003\u00056k\u0011a\u0011\u0006\u0003\t\u0016\u000bAA\\8eK*\u0011aiR\u0001\tI\u0006$\u0018MY5oI*\u0011\u0001*S\u0001\bU\u0006\u001c7n]8o\u0015\tQ5*A\u0005gCN$XM\u001d=nY*\tA*A\u0002d_6L!AT\"\u0003\u0013\u0005\u0013(/Y=O_\u0012,\u0007\"\u0002\u001d?\u0001\u00041\u0002\"B)?\u0001\u00041\u0012!\u0002:b]\u001e,\u0007\"B*?\u0001\u00041\u0012aB:iK\u0016$\u0018\n\u001a\u0005\u0006+\u0002!\tAV\u0001\u000bO\u0016$H)\u0019;bg\u0016$HCB,paF\u001c\b\u0010\u0005\u0003\u00101jK\u0017BA-\u0011\u0005\u0019!V\u000f\u001d7feA\u00191\f\u00192\u000e\u0003qS!!\u00180\u0002\u000f5,H/\u00192mK*\u0011q\fE\u0001\u000bG>dG.Z2uS>t\u0017BA1]\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0005\r<W\"\u00013\u000b\u0005\u00154\u0017aA:rY*\u0011Q\u0001C\u0005\u0003Q\u0012\u00141AU8x!\tQW.D\u0001l\u0015\taG-A\u0003usB,7/\u0003\u0002oW\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000ba\"\u0006\u0019\u0001\f\t\u000bE#\u0006\u0019\u0001\f\t\u000bI$\u0006\u0019A\u001e\u0002\u0019QLG\u000f\\3MS:,g*^7\t\u000bQ$\u0006\u0019A;\u0002\u001f%<gn\u001c:f)&$H.\u001a'j]\u0016\u0004\"a\u0004<\n\u0005]\u0004\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006uQ\u0003\ra\u000f\u0005\u0006u\u0002!\ta_\u0001\u001be\u0016\fX/Z:u\r\u0016L7\u000f[;Ba&\fe\u000eZ$fi\u0012\u000bG/\u0019\u000b\u0004y\u0006\u0005\u0001CA?\u007f\u001b\u0005)\u0015BA@F\u0005!Q5o\u001c8O_\u0012,\u0007BBA\u0002s\u0002\u0007a#A\u0002ve2Dq!a\u0002\u0001\t\u0003\tI!\u0001\tsKF,Xm\u001d;GK&\u001c\b.^!qSR1\u00111BA\t\u0003'\u00012AQA\u0007\u0013\r\tya\u0011\u0002\u000b\u001f\nTWm\u0019;O_\u0012,\u0007bBA\u0002\u0003\u000b\u0001\rA\u0006\u0005\b\u0003+\t)\u00011\u0001\u0017\u0003\u0015!xn[3o\u0001")
public class FeishuClient {
    private final String appId;
    private final String appSecret;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public String getToken() {
        String url = new StringOps(Predef$.MODULE$.augmentString("https://open.feishu.cn/open-apis/auth/v3/tenant_access_token/internal?app_id=%s&app_secret=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.appId, this.appSecret}));
        ObjectNode result = this.requestFeishuApi(url, null);
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request token and get result ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{result})));
        return result.get("tenant_access_token").toString();
    }

    public String getSheetId(String sheetToken, int sheetNum) {
        String url = new StringOps(Predef$.MODULE$.augmentString("https://open.feishu.cn/open-apis/sheets/v2/spreadsheets/%s/metainfo")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sheetToken}));
        JsonNode data = this.requestFeishuApiAndGetData(url);
        if (data == null) {
            throw new RuntimeException("Did not get any sheet in Feishu, please make sure there is correct sheet token!");
        }
        JsonNode sheets = data.get("sheets");
        if (sheets == null || sheets.size() < sheetNum) {
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The sheet ", " is does not exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sheetNum)})));
        }
        JsonNode sheetInfo = sheets.get(sheetNum - 1);
        return sheetInfo.get("sheetId").toString();
    }

    public ArrayNode getSheetData(String sheetToken, String range, String sheetId) {
        String url;
        ArrayNode data;
        String rangeNew = range;
        if (!"".equals(rangeNew)) {
            rangeNew = new StringBuilder().append((Object)"!").append((Object)rangeNew).toString();
        }
        if ((data = (ArrayNode)this.requestFeishuApiAndGetData(url = new StringOps(Predef$.MODULE$.augmentString("https://open.feishu.cn/open-apis/sheets/v2/spreadsheets/%s/values/%s%s?valueRenderOption=ToString&dateTimeRenderOption=FormattedString")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sheetToken, sheetId, rangeNew})))) == null) {
            throw new RuntimeException("The data is empty, please make sure some data in sheet.");
        }
        JsonNode valueRange = data.get("valueRange");
        if (valueRange == null) {
            throw new RuntimeException("The data is empty, please make sure some data in sheet.");
        }
        return (ArrayNode)valueRange.get("values");
    }

    public Tuple2<ArrayBuffer<Row>, StructType> getDataset(String sheetToken, String range, int titleLineNum, boolean ignoreTitleLine, int sheetNum) {
        String sheetId = this.getSheetId(sheetToken, sheetNum);
        ArrayNode values = this.getSheetData(sheetToken, range, sheetId);
        if (values.size() < titleLineNum) {
            throw new RuntimeException("The title line number is larger than data rows");
        }
        int start = titleLineNum - 1;
        if (ignoreTitleLine) {
            ++start;
        }
        StructType schema = null;
        ArrayNode schemaData = (ArrayNode)values.get(titleLineNum - 1);
        ArrayBuffer fields = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), schemaData.size()).foreach((Function1)new Serializable(this, schemaData, fields){
            public static final long serialVersionUID = 0L;
            private final ArrayNode schemaData$1;
            private final ArrayBuffer fields$1;

            public final ArrayBuffer<StructField> apply(int index) {
                JsonNode titleName = this.schemaData$1.get(index);
                if (titleName == null) {
                    throw new RuntimeException("The title name is not allowed null");
                }
                StructField field = DataTypes.createStructField((String)titleName.toString(), (DataType)DataTypes.StringType, (boolean)true);
                return this.fields$1.$plus$eq((Object)field);
            }
            {
                this.schemaData$1 = schemaData$1;
                this.fields$1 = fields$1;
            }
        });
        schema = DataTypes.createStructType((StructField[])((StructField[])fields.toArray(ClassTag$.MODULE$.apply(StructField.class))));
        ArrayBuffer rows = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), values.size()).foreach((Function1)new Serializable(this, values, rows){
            public static final long serialVersionUID = 0L;
            private final ArrayNode values$1;
            private final ArrayBuffer rows$1;

            public final ArrayBuffer<Row> apply(int index) {
                ArrayNode jsonArr = (ArrayNode)this.values$1.get(index);
                ArrayBuffer arr = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), jsonArr.size()).foreach((Function1)new Serializable(this, jsonArr, arr){
                    public static final long serialVersionUID = 0L;
                    private final ArrayNode jsonArr$1;
                    private final ArrayBuffer arr$1;

                    public final ArrayBuffer<String> apply(int indexInner) {
                        return this.arr$1.$plus$eq((Object)this.jsonArr$1.get(indexInner).toString());
                    }
                    {
                        this.jsonArr$1 = jsonArr$1;
                        this.arr$1 = arr$1;
                    }
                });
                Row row = Row$.MODULE$.fromSeq((Seq)arr);
                return this.rows$1.$plus$eq((Object)row);
            }
            {
                this.values$1 = values$1;
                this.rows$1 = rows$1;
            }
        });
        return new Tuple2((Object)rows, (Object)schema);
    }

    public JsonNode requestFeishuApiAndGetData(String url) {
        ObjectNode result = this.requestFeishuApi(url, this.getToken());
        return result.get("data");
    }

    /*
     * WARNING - void declaration
     */
    public ObjectNode requestFeishuApi(String url, String token) {
        ObjectNode result;
        int code;
        String resultStr;
        block7: {
            HttpUriRequest httpGet = RequestBuilder.get().setUri(url).setHeader("Authorization", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Bearer ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{token}))).build();
            CloseableHttpClient httpClient = null;
            resultStr = null;
            try {
                httpClient = HttpClients.createDefault();
                CloseableHttpResponse response = httpClient.execute(httpGet);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request feishu api failed! statusCode is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)statusCode)})));
                }
                HttpEntity entity = response.getEntity();
                resultStr = EntityUtils.toString(entity);
                if (httpClient == null) break block7;
            }
            catch (Exception exception) {
                try {
                    throw exception;
                }
                catch (Throwable throwable) {
                    void var4_4;
                    if (var4_4 != null) {
                        var4_4.close();
                    }
                    throw throwable;
                }
            }
            httpClient.close();
        }
        if ((code = (result = JsonUtils.parseObject((String)resultStr)).get("code").asInt()) != 0) {
            String errorMessage = result.get("msg").toString();
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request feishu api error, the code is: ", " and msg is: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)code), errorMessage})));
        }
        return result;
    }

    public FeishuClient(String appId, String appSecret) {
        this.appId = appId;
        this.appSecret = appSecret;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }
}

