/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.SearchSortValues;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.lookup.SourceLookup;
import org.elasticsearch.transport.RemoteClusterAware;

public final class SearchHit
implements Streamable,
ToXContentObject,
Iterable<DocumentField> {
    private transient int docId;
    private static final float DEFAULT_SCORE = Float.NEGATIVE_INFINITY;
    private float score = Float.NEGATIVE_INFINITY;
    private Text id;
    private Text type;
    private NestedIdentity nestedIdentity;
    private long version = -1L;
    private BytesReference source;
    private Map<String, DocumentField> fields = Collections.emptyMap();
    private Map<String, HighlightField> highlightFields = null;
    private SearchSortValues sortValues = SearchSortValues.EMPTY;
    private String[] matchedQueries = Strings.EMPTY_ARRAY;
    private Explanation explanation;
    @Nullable
    private SearchShardTarget shard;
    private transient String index;
    private transient String clusterAlias;
    private Map<String, Object> sourceAsMap;
    private Map<String, SearchHits> innerHits;
    private static ObjectParser<Map<String, Object>, Void> MAP_PARSER = new ObjectParser("innerHitParser", true, HashMap::new);

    private SearchHit() {
    }

    public SearchHit(int docId) {
        this(docId, null, null, null);
    }

    public SearchHit(int docId, String id, Text type, Map<String, DocumentField> fields) {
        this(docId, id, type, null, fields);
    }

    public SearchHit(int nestedTopDocId, String id, Text type, NestedIdentity nestedIdentity, Map<String, DocumentField> fields) {
        this.docId = nestedTopDocId;
        this.id = id != null ? new Text(id) : null;
        this.type = type;
        this.nestedIdentity = nestedIdentity;
        this.fields = fields;
    }

    public int docId() {
        return this.docId;
    }

    public void score(float score) {
        this.score = score;
    }

    public float getScore() {
        return this.score;
    }

    public void version(long version) {
        this.version = version;
    }

    public long getVersion() {
        return this.version;
    }

    public String getIndex() {
        return this.index;
    }

    public String getId() {
        return this.id != null ? this.id.string() : null;
    }

    public String getType() {
        return this.type != null ? this.type.string() : null;
    }

    public NestedIdentity getNestedIdentity() {
        return this.nestedIdentity;
    }

    public BytesReference getSourceRef() {
        if (this.source == null) {
            return null;
        }
        try {
            this.source = CompressorFactory.uncompressIfNeeded(this.source);
            return this.source;
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to decompress source", (Throwable)e, new Object[0]);
        }
    }

    public SearchHit sourceRef(BytesReference source) {
        this.source = source;
        this.sourceAsMap = null;
        return this;
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public String getSourceAsString() {
        if (this.source == null) {
            return null;
        }
        try {
            return XContentHelper.convertToJson(this.getSourceRef(), false);
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to convert source to a json string", new Object[0]);
        }
    }

    public Map<String, Object> getSourceAsMap() {
        if (this.source == null) {
            return null;
        }
        if (this.sourceAsMap != null) {
            return this.sourceAsMap;
        }
        this.sourceAsMap = SourceLookup.sourceAsMap(this.source);
        return this.sourceAsMap;
    }

    @Override
    public Iterator<DocumentField> iterator() {
        return this.fields.values().iterator();
    }

    public DocumentField field(String fieldName) {
        return this.getFields().get(fieldName);
    }

    public Map<String, DocumentField> getFields() {
        return this.fields == null ? Collections.emptyMap() : this.fields;
    }

    public Map<String, DocumentField> fieldsOrNull() {
        return this.fields;
    }

    public void fields(Map<String, DocumentField> fields) {
        this.fields = fields;
    }

    public Map<String, HighlightField> getHighlightFields() {
        return this.highlightFields == null ? Collections.emptyMap() : this.highlightFields;
    }

    public void highlightFields(Map<String, HighlightField> highlightFields) {
        this.highlightFields = highlightFields;
    }

    public void sortValues(Object[] sortValues, DocValueFormat[] sortValueFormats) {
        this.sortValues(new SearchSortValues(sortValues, sortValueFormats));
    }

    public void sortValues(SearchSortValues sortValues) {
        this.sortValues = sortValues;
    }

    public Object[] getSortValues() {
        return this.sortValues.sortValues();
    }

    public Explanation getExplanation() {
        return this.explanation;
    }

    public void explanation(Explanation explanation) {
        this.explanation = explanation;
    }

    public SearchShardTarget getShard() {
        return this.shard;
    }

    public void shard(SearchShardTarget target) {
        if (this.innerHits != null) {
            for (SearchHits innerHits : this.innerHits.values()) {
                for (SearchHit innerHit : innerHits) {
                    innerHit.shard(target);
                }
            }
        }
        this.shard = target;
        if (target != null) {
            this.index = target.getIndex();
            this.clusterAlias = target.getClusterAlias();
        }
    }

    public String getClusterAlias() {
        return this.clusterAlias;
    }

    public void matchedQueries(String[] matchedQueries) {
        this.matchedQueries = matchedQueries;
    }

    public String[] getMatchedQueries() {
        return this.matchedQueries;
    }

    public Map<String, SearchHits> getInnerHits() {
        return this.innerHits;
    }

    public void setInnerHits(Map<String, SearchHits> innerHits) {
        this.innerHits = innerHits;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toInnerXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public XContentBuilder toInnerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        ArrayList<DocumentField> metaFields = new ArrayList<DocumentField>();
        ArrayList<DocumentField> otherFields = new ArrayList<DocumentField>();
        if (this.fields != null && !this.fields.isEmpty()) {
            for (DocumentField documentField : this.fields.values()) {
                if (documentField.getValues().isEmpty()) continue;
                if (documentField.isMetadataField()) {
                    metaFields.add(documentField);
                    continue;
                }
                otherFields.add(documentField);
            }
        }
        if (this.getExplanation() != null && this.shard != null) {
            builder.field("_shard", this.shard.getShardId());
            builder.field("_node", this.shard.getNodeIdText());
        }
        if (this.index != null) {
            builder.field("_index", RemoteClusterAware.buildRemoteIndexName(this.clusterAlias, this.index));
        }
        if (this.type != null) {
            builder.field("_type", this.type);
        }
        if (this.id != null) {
            builder.field("_id", this.id);
        }
        if (this.nestedIdentity != null) {
            this.nestedIdentity.toXContent(builder, params);
        }
        if (this.version != -1L) {
            builder.field("_version", this.version);
        }
        if (Float.isNaN(this.score)) {
            builder.nullField("_score");
        } else {
            builder.field("_score", this.score);
        }
        for (DocumentField documentField : metaFields) {
            Object value = documentField.getValue();
            builder.field(documentField.getName(), value);
        }
        if (this.source != null) {
            XContentHelper.writeRawField("_source", this.source, builder, params);
        }
        if (!otherFields.isEmpty()) {
            builder.startObject("fields");
            for (DocumentField documentField : otherFields) {
                documentField.toXContent(builder, params);
            }
            builder.endObject();
        }
        if (this.highlightFields != null && !this.highlightFields.isEmpty()) {
            builder.startObject("highlight");
            for (HighlightField highlightField : this.highlightFields.values()) {
                highlightField.toXContent(builder, params);
            }
            builder.endObject();
        }
        this.sortValues.toXContent(builder, params);
        if (this.matchedQueries.length > 0) {
            builder.startArray("matched_queries");
            for (Iterator<Object> iterator : this.matchedQueries) {
                builder.value((String)((Object)iterator));
            }
            builder.endArray();
        }
        if (this.getExplanation() != null) {
            builder.field("_explanation");
            this.buildExplanation(builder, this.getExplanation());
        }
        if (this.innerHits != null) {
            builder.startObject("inner_hits");
            for (Map.Entry entry : this.innerHits.entrySet()) {
                builder.startObject((String)entry.getKey());
                ((SearchHits)entry.getValue()).toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        }
        return builder;
    }

    public static SearchHit fromXContent(XContentParser parser) {
        return SearchHit.createFromMap(MAP_PARSER.apply(parser, null));
    }

    public static void declareInnerHitsParseFields(ObjectParser<Map<String, Object>, Void> parser) {
        SearchHit.declareMetaDataFields(parser);
        parser.declareString((map, value) -> map.put("_type", new Text((String)value)), new ParseField("_type", new String[0]));
        parser.declareString((map, value) -> map.put("_index", value), new ParseField("_index", new String[0]));
        parser.declareString((map, value) -> map.put("_id", value), new ParseField("_id", new String[0]));
        parser.declareString((map, value) -> map.put("_node", value), new ParseField("_node", new String[0]));
        parser.declareField((map, value) -> map.put("_score", value), SearchHit::parseScore, new ParseField("_score", new String[0]), ObjectParser.ValueType.FLOAT_OR_NULL);
        parser.declareLong((map, value) -> map.put("_version", value), new ParseField("_version", new String[0]));
        parser.declareField((map, value) -> map.put("_shard", value), (p, c) -> ShardId.fromString(p.text()), new ParseField("_shard", new String[0]), ObjectParser.ValueType.STRING);
        parser.declareObject((map, value) -> map.put("_source", value), (p, c) -> SearchHit.parseSourceBytes(p), new ParseField("_source", new String[0]));
        parser.declareObject((map, value) -> map.put("highlight", value), (p, c) -> SearchHit.parseHighlightFields(p), new ParseField("highlight", new String[0]));
        parser.declareObject((map, value) -> {
            Map fieldMap = SearchHit.get("fields", map, new HashMap());
            fieldMap.putAll(value);
            map.put("fields", fieldMap);
        }, (p, c) -> SearchHit.parseFields(p), new ParseField("fields", new String[0]));
        parser.declareObject((map, value) -> map.put("_explanation", value), (p, c) -> SearchHit.parseExplanation(p), new ParseField("_explanation", new String[0]));
        parser.declareObject((map, value) -> map.put("_nested", value), NestedIdentity::fromXContent, new ParseField("_nested", new String[0]));
        parser.declareObject((map, value) -> map.put("inner_hits", value), (p, c) -> SearchHit.parseInnerHits(p), new ParseField("inner_hits", new String[0]));
        parser.declareStringArray((map, list) -> map.put("matched_queries", list), new ParseField("matched_queries", new String[0]));
        parser.declareField((map, list) -> map.put("sort", list), SearchSortValues::fromXContent, new ParseField("sort", new String[0]), ObjectParser.ValueType.OBJECT_ARRAY);
    }

    public static SearchHit createFromMap(Map<String, Object> values) {
        String id = SearchHit.get("_id", values, null);
        Text type = SearchHit.get("_type", values, null);
        NestedIdentity nestedIdentity = SearchHit.get("_nested", values, null);
        Map<String, DocumentField> fields = SearchHit.get("fields", values, Collections.emptyMap());
        SearchHit searchHit = new SearchHit(-1, id, type, nestedIdentity, fields);
        searchHit.index = SearchHit.get("_index", values, null);
        searchHit.score(SearchHit.get("_score", values, Float.valueOf(Float.NEGATIVE_INFINITY)).floatValue());
        searchHit.version(SearchHit.get("_version", values, -1L));
        searchHit.sortValues(SearchHit.get("sort", values, SearchSortValues.EMPTY));
        searchHit.highlightFields(SearchHit.get("highlight", values, null));
        searchHit.sourceRef(SearchHit.get("_source", values, null));
        searchHit.explanation(SearchHit.get("_explanation", values, null));
        searchHit.setInnerHits(SearchHit.get("inner_hits", values, null));
        List matchedQueries = SearchHit.get("matched_queries", values, null);
        if (matchedQueries != null) {
            searchHit.matchedQueries(matchedQueries.toArray(new String[matchedQueries.size()]));
        }
        ShardId shardId = SearchHit.get("_shard", values, null);
        String nodeId = SearchHit.get("_node", values, null);
        if (shardId != null && nodeId != null) {
            searchHit.shard(new SearchShardTarget(nodeId, shardId, null, OriginalIndices.NONE));
        }
        return searchHit;
    }

    private static <T> T get(String key, Map<String, Object> map, T defaultValue) {
        return (T)map.getOrDefault(key, defaultValue);
    }

    private static float parseScore(XContentParser parser) throws IOException {
        if (parser.currentToken() == XContentParser.Token.VALUE_NUMBER || parser.currentToken() == XContentParser.Token.VALUE_STRING) {
            return parser.floatValue();
        }
        return Float.NaN;
    }

    private static BytesReference parseSourceBytes(XContentParser parser) throws IOException {
        try (XContentBuilder builder = XContentBuilder.builder(parser.contentType().xContent());){
            builder.copyCurrentStructure(parser);
            BytesReference bytesReference = BytesReference.bytes(builder);
            return bytesReference;
        }
    }

    private static void declareMetaDataFields(ObjectParser<Map<String, Object>, Void> parser) {
        for (String metadatafield : MapperService.getAllMetaFields()) {
            if (metadatafield.equals("_id") || metadatafield.equals("_index") || metadatafield.equals("_type")) continue;
            parser.declareField((map, field) -> {
                Map fieldMap = (Map)map.computeIfAbsent("fields", v -> new HashMap());
                fieldMap.put(field.getName(), field);
            }, (p, c) -> {
                ArrayList<Object> values = new ArrayList<Object>();
                values.add(XContentParserUtils.parseFieldsValue(p));
                return new DocumentField(metadatafield, values);
            }, new ParseField(metadatafield, new String[0]), ObjectParser.ValueType.VALUE);
        }
    }

    private static Map<String, DocumentField> parseFields(XContentParser parser) throws IOException {
        HashMap<String, DocumentField> fields = new HashMap<String, DocumentField>();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            DocumentField field = DocumentField.fromXContent(parser);
            fields.put(field.getName(), field);
        }
        return fields;
    }

    private static Map<String, SearchHits> parseInnerHits(XContentParser parser) throws IOException {
        HashMap<String, SearchHits> innerHits = new HashMap<String, SearchHits>();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.currentToken(), parser::getTokenLocation);
            String name = parser.currentName();
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser::getTokenLocation);
            XContentParserUtils.ensureFieldName(parser, parser.nextToken(), "hits");
            innerHits.put(name, SearchHits.fromXContent(parser));
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.END_OBJECT, parser.nextToken(), parser::getTokenLocation);
        }
        return innerHits;
    }

    private static Map<String, HighlightField> parseHighlightFields(XContentParser parser) throws IOException {
        HashMap<String, HighlightField> highlightFields = new HashMap<String, HighlightField>();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            HighlightField highlightField = HighlightField.fromXContent(parser);
            highlightFields.put(highlightField.getName(), highlightField);
        }
        return highlightFields;
    }

    private static Explanation parseExplanation(XContentParser parser) throws IOException {
        XContentParser.Token token;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser::getTokenLocation);
        Float value = null;
        String description = null;
        ArrayList<Explanation> details = new ArrayList<Explanation>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser::getTokenLocation);
            String currentFieldName = parser.currentName();
            token = parser.nextToken();
            if ("value".equals(currentFieldName)) {
                value = Float.valueOf(parser.floatValue());
                continue;
            }
            if ("description".equals(currentFieldName)) {
                description = parser.textOrNull();
                continue;
            }
            if ("details".equals(currentFieldName)) {
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, token, parser::getTokenLocation);
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    details.add(SearchHit.parseExplanation(parser));
                }
                continue;
            }
            parser.skipChildren();
        }
        if (value == null) {
            throw new ParsingException(parser.getTokenLocation(), "missing explanation value", new Object[0]);
        }
        if (description == null) {
            throw new ParsingException(parser.getTokenLocation(), "missing explanation description", new Object[0]);
        }
        return Explanation.match(value.floatValue(), description, details);
    }

    private void buildExplanation(XContentBuilder builder, Explanation explanation) throws IOException {
        builder.startObject();
        builder.field("value", explanation.getValue());
        builder.field("description", explanation.getDescription());
        Explanation[] innerExps = explanation.getDetails();
        if (innerExps != null) {
            builder.startArray("details");
            for (Explanation exp : innerExps) {
                this.buildExplanation(builder, exp);
            }
            builder.endArray();
        }
        builder.endObject();
    }

    public static SearchHit readSearchHit(StreamInput in) throws IOException {
        SearchHit hit = new SearchHit();
        hit.readFrom(in);
        return hit;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int i;
        int size;
        this.score = in.readFloat();
        this.id = in.readOptionalText();
        this.type = in.readOptionalText();
        this.nestedIdentity = in.readOptionalWriteable(NestedIdentity::new);
        this.version = in.readLong();
        this.source = in.readBytesReference();
        if (this.source.length() == 0) {
            this.source = null;
        }
        if (in.readBoolean()) {
            this.explanation = Lucene.readExplanation(in);
        }
        if ((size = in.readVInt()) == 0) {
            this.fields = Collections.emptyMap();
        } else if (size == 1) {
            DocumentField hitField = DocumentField.readDocumentField(in);
            this.fields = Collections.singletonMap(hitField.getName(), hitField);
        } else {
            HashMap<String, DocumentField> fields = new HashMap<String, DocumentField>();
            for (i = 0; i < size; ++i) {
                DocumentField hitField = DocumentField.readDocumentField(in);
                fields.put(hitField.getName(), hitField);
            }
            this.fields = Collections.unmodifiableMap(fields);
        }
        size = in.readVInt();
        if (size == 0) {
            this.highlightFields = Collections.emptyMap();
        } else if (size == 1) {
            HighlightField field = HighlightField.readHighlightField(in);
            this.highlightFields = Collections.singletonMap(field.name(), field);
        } else {
            HashMap<String, HighlightField> highlightFields = new HashMap<String, HighlightField>();
            for (i = 0; i < size; ++i) {
                HighlightField field = HighlightField.readHighlightField(in);
                highlightFields.put(field.name(), field);
            }
            this.highlightFields = Collections.unmodifiableMap(highlightFields);
        }
        this.sortValues = new SearchSortValues(in);
        size = in.readVInt();
        if (size > 0) {
            this.matchedQueries = new String[size];
            for (int i2 = 0; i2 < size; ++i2) {
                this.matchedQueries[i2] = in.readString();
            }
        }
        this.shard(in.readOptionalWriteable(SearchShardTarget::new));
        size = in.readVInt();
        if (size > 0) {
            this.innerHits = new HashMap<String, SearchHits>(size);
            for (int i3 = 0; i3 < size; ++i3) {
                String key = in.readString();
                SearchHits value = SearchHits.readSearchHits(in);
                this.innerHits.put(key, value);
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeFloat(this.score);
        out.writeOptionalText(this.id);
        out.writeOptionalText(this.type);
        out.writeOptionalWriteable(this.nestedIdentity);
        out.writeLong(this.version);
        out.writeBytesReference(this.source);
        if (this.explanation == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Lucene.writeExplanation(out, this.explanation);
        }
        if (this.fields == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.fields.size());
            for (DocumentField documentField : this.getFields().values()) {
                documentField.writeTo(out);
            }
        }
        if (this.highlightFields == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.highlightFields.size());
            for (HighlightField highlightField : this.highlightFields.values()) {
                highlightField.writeTo(out);
            }
        }
        this.sortValues.writeTo(out);
        if (this.matchedQueries.length == 0) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.matchedQueries.length);
            for (Iterator<Streamable> iterator : this.matchedQueries) {
                out.writeString((String)((Object)iterator));
            }
        }
        out.writeOptionalWriteable(this.shard);
        if (this.innerHits == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.innerHits.size());
            for (Map.Entry entry : this.innerHits.entrySet()) {
                out.writeString((String)entry.getKey());
                ((SearchHits)entry.getValue()).writeTo(out);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SearchHit other = (SearchHit)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.type, other.type) && Objects.equals(this.nestedIdentity, other.nestedIdentity) && Objects.equals(this.version, other.version) && Objects.equals(this.source, other.source) && Objects.equals(this.fields, other.fields) && Objects.equals(this.getHighlightFields(), other.getHighlightFields()) && Arrays.equals(this.matchedQueries, other.matchedQueries) && Objects.equals(this.explanation, other.explanation) && Objects.equals(this.shard, other.shard) && Objects.equals(this.innerHits, other.innerHits);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type, this.nestedIdentity, this.version, this.source, this.fields, this.getHighlightFields(), Arrays.hashCode(this.matchedQueries), this.explanation, this.shard, this.innerHits);
    }

    static {
        SearchHit.declareInnerHitsParseFields(MAP_PARSER);
    }

    public static final class NestedIdentity
    implements Writeable,
    ToXContentFragment {
        private static final String _NESTED = "_nested";
        private static final String FIELD = "field";
        private static final String OFFSET = "offset";
        private final Text field;
        private final int offset;
        private final NestedIdentity child;
        private static final ConstructingObjectParser<NestedIdentity, Void> PARSER = new ConstructingObjectParser("nested_identity", true, ctorArgs -> new NestedIdentity((String)ctorArgs[0], (Integer)ctorArgs[1], (NestedIdentity)ctorArgs[2]));

        public NestedIdentity(String field, int offset, NestedIdentity child) {
            this.field = new Text(field);
            this.offset = offset;
            this.child = child;
        }

        NestedIdentity(StreamInput in) throws IOException {
            this.field = in.readOptionalText();
            this.offset = in.readInt();
            this.child = in.readOptionalWriteable(NestedIdentity::new);
        }

        public Text getField() {
            return this.field;
        }

        public int getOffset() {
            return this.offset;
        }

        public NestedIdentity getChild() {
            return this.child;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalText(this.field);
            out.writeInt(this.offset);
            out.writeOptionalWriteable(this.child);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(_NESTED);
            return this.innerToXContent(builder, params);
        }

        XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.field != null) {
                builder.field(FIELD, this.field);
            }
            if (this.offset != -1) {
                builder.field(OFFSET, this.offset);
            }
            if (this.child != null) {
                builder = this.child.toXContent(builder, params);
            }
            builder.endObject();
            return builder;
        }

        static NestedIdentity fromXContent(XContentParser parser, Void context) {
            return NestedIdentity.fromXContent(parser);
        }

        public static NestedIdentity fromXContent(XContentParser parser) {
            return PARSER.apply(parser, null);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            NestedIdentity other = (NestedIdentity)obj;
            return Objects.equals(this.field, other.field) && Objects.equals(this.offset, other.offset) && Objects.equals(this.child, other.child);
        }

        public int hashCode() {
            return Objects.hash(this.field, this.offset, this.child);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(FIELD, new String[0]));
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(OFFSET, new String[0]));
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), PARSER, new ParseField(_NESTED, new String[0]));
        }
    }

    public static class Fields {
        static final String _INDEX = "_index";
        static final String _TYPE = "_type";
        static final String _ID = "_id";
        static final String _VERSION = "_version";
        static final String _SCORE = "_score";
        static final String FIELDS = "fields";
        static final String HIGHLIGHT = "highlight";
        static final String SORT = "sort";
        static final String MATCHED_QUERIES = "matched_queries";
        static final String _EXPLANATION = "_explanation";
        static final String VALUE = "value";
        static final String DESCRIPTION = "description";
        static final String DETAILS = "details";
        static final String INNER_HITS = "inner_hits";
        static final String _SHARD = "_shard";
        static final String _NODE = "_node";
    }
}

