/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.all;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.analysis.payloads.PayloadHelper;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SmallFloat;

public final class AllTermQuery
extends Query {
    private final Term term;

    public AllTermQuery(Term term) {
        this.term = term;
    }

    public Term getTerm() {
        return this.term;
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        return Objects.equals(this.term, ((AllTermQuery)obj).term);
    }

    @Override
    public int hashCode() {
        return 31 * this.classHash() + this.term.hashCode();
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = super.rewrite(reader);
        if (rewritten != this) {
            return rewritten;
        }
        boolean hasPayloads = false;
        for (LeafReaderContext context : reader.leaves()) {
            Terms terms = context.reader().terms(this.term.field());
            if (terms == null || !terms.hasPayloads()) continue;
            hasPayloads = true;
            break;
        }
        if (!hasPayloads) {
            return new TermQuery(this.term);
        }
        return this;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        if (!needsScores) {
            return new TermQuery(this.term).createWeight(searcher, needsScores, boost);
        }
        final TermContext termStates = TermContext.build(searcher.getTopReaderContext(), this.term);
        CollectionStatistics collectionStats = searcher.collectionStatistics(this.term.field());
        TermStatistics termStats = searcher.termStatistics(this.term, termStates);
        final Similarity similarity = searcher.getSimilarity(needsScores);
        final Similarity.SimWeight stats = similarity.computeWeight(boost, collectionStats, termStats);
        return new Weight(this){

            @Override
            public void extractTerms(Set<Term> terms) {
                terms.add(AllTermQuery.this.term);
            }

            @Override
            public boolean isCacheable(LeafReaderContext context) {
                return true;
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                int newDoc;
                AllTermScorer scorer = this.scorer(context);
                if (scorer != null && (newDoc = scorer.iterator().advance(doc)) == doc) {
                    float score = scorer.score();
                    float freq = scorer.freq();
                    Similarity.SimScorer docScorer = similarity.simScorer(stats, context);
                    Explanation freqExplanation = Explanation.match(freq, "termFreq=" + freq, new Explanation[0]);
                    Explanation termScoreExplanation = docScorer.explain(doc, freqExplanation);
                    Explanation payloadBoostExplanation = Explanation.match(scorer.payloadBoost(), "payloadBoost=" + scorer.payloadBoost(), new Explanation[0]);
                    return Explanation.match(score, "weight(" + this.getQuery() + " in " + doc + ") [" + similarity.getClass().getSimpleName() + "], product of:", termScoreExplanation, payloadBoostExplanation);
                }
                return Explanation.noMatch("no matching term", new Explanation[0]);
            }

            @Override
            public AllTermScorer scorer(LeafReaderContext context) throws IOException {
                Terms terms = context.reader().terms(AllTermQuery.this.term.field());
                if (terms == null) {
                    return null;
                }
                TermsEnum termsEnum = terms.iterator();
                if (termsEnum == null) {
                    return null;
                }
                TermState state = termStates.get(context.ord);
                if (state == null) {
                    return null;
                }
                termsEnum.seekExact(AllTermQuery.this.term.bytes(), state);
                PostingsEnum docs = termsEnum.postings(null, 88);
                assert (docs != null);
                return new AllTermScorer(this, docs, similarity.simScorer(stats, context));
            }
        };
    }

    @Override
    public String toString(String field) {
        return new TermQuery(this.term).toString(field);
    }

    private static class AllTermScorer
    extends Scorer {
        final PostingsEnum postings;
        final Similarity.SimScorer docScorer;
        int doc = -1;
        float payloadBoost;

        AllTermScorer(Weight weight, PostingsEnum postings, Similarity.SimScorer docScorer) {
            super(weight);
            this.postings = postings;
            this.docScorer = docScorer;
        }

        float payloadBoost() throws IOException {
            if (this.doc != this.docID()) {
                int freq = this.postings.freq();
                this.payloadBoost = 0.0f;
                for (int i = 0; i < freq; ++i) {
                    float boost;
                    this.postings.nextPosition();
                    BytesRef payload = this.postings.getPayload();
                    if (payload == null) {
                        boost = 1.0f;
                    } else if (payload.length == 1) {
                        boost = SmallFloat.byte315ToFloat(payload.bytes[payload.offset]);
                    } else if (payload.length == 4) {
                        boost = PayloadHelper.decodeFloat(payload.bytes, payload.offset);
                    } else {
                        throw new IllegalStateException("Payloads are expected to have a length of 1 or 4 but got: " + payload);
                    }
                    this.payloadBoost += boost;
                }
                this.payloadBoost /= (float)freq;
                this.doc = this.docID();
            }
            return this.payloadBoost;
        }

        @Override
        public float score() throws IOException {
            return this.payloadBoost() * this.docScorer.score(this.postings.docID(), this.postings.freq());
        }

        int freq() throws IOException {
            return this.postings.freq();
        }

        @Override
        public int docID() {
            return this.postings.docID();
        }

        @Override
        public DocIdSetIterator iterator() {
            return this.postings;
        }
    }
}

