/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.uhighlight;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.lucene.queries.function.FunctionScoreQuery;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanBoostQuery;
import org.apache.lucene.search.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanNotQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanPositionCheckQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.LevenshteinAutomata;

class MultiTermHighlighting {
    private MultiTermHighlighting() {
    }

    public static CharacterRunAutomaton[] extractAutomata(Query query, Predicate<String> fieldMatcher, boolean lookInSpan, Function<Query, Collection<Query>> preRewriteFunc) {
        AutomatonQuery aq;
        ArrayList<CharacterRunAutomaton> list = new ArrayList<CharacterRunAutomaton>();
        Collection<Query> customSubQueries = preRewriteFunc.apply(query);
        if (customSubQueries != null) {
            for (Query sub : customSubQueries) {
                list.addAll(Arrays.asList(MultiTermHighlighting.extractAutomata(sub, fieldMatcher, lookInSpan, preRewriteFunc)));
            }
        } else if (query instanceof BooleanQuery) {
            for (BooleanClause clause : (BooleanQuery)query) {
                if (clause.isProhibited()) continue;
                list.addAll(Arrays.asList(MultiTermHighlighting.extractAutomata(clause.getQuery(), fieldMatcher, lookInSpan, preRewriteFunc)));
            }
        } else if (query instanceof ConstantScoreQuery) {
            list.addAll(Arrays.asList(MultiTermHighlighting.extractAutomata(((ConstantScoreQuery)query).getQuery(), fieldMatcher, lookInSpan, preRewriteFunc)));
        } else if (query instanceof BoostQuery) {
            list.addAll(Arrays.asList(MultiTermHighlighting.extractAutomata(((BoostQuery)query).getQuery(), fieldMatcher, lookInSpan, preRewriteFunc)));
        } else if (query instanceof FunctionScoreQuery) {
            list.addAll(Arrays.asList(MultiTermHighlighting.extractAutomata(((FunctionScoreQuery)query).getWrappedQuery(), fieldMatcher, lookInSpan, preRewriteFunc)));
        } else if (query instanceof DisjunctionMaxQuery) {
            for (Query sub : ((DisjunctionMaxQuery)query).getDisjuncts()) {
                list.addAll(Arrays.asList(MultiTermHighlighting.extractAutomata(sub, fieldMatcher, lookInSpan, preRewriteFunc)));
            }
        } else if (lookInSpan && query instanceof SpanOrQuery) {
            for (SpanQuery sub : ((SpanOrQuery)query).getClauses()) {
                list.addAll(Arrays.asList(MultiTermHighlighting.extractAutomata(sub, fieldMatcher, lookInSpan, preRewriteFunc)));
            }
        } else if (lookInSpan && query instanceof SpanNearQuery) {
            for (SpanQuery sub : ((SpanNearQuery)query).getClauses()) {
                list.addAll(Arrays.asList(MultiTermHighlighting.extractAutomata(sub, fieldMatcher, lookInSpan, preRewriteFunc)));
            }
        } else if (lookInSpan && query instanceof SpanNotQuery) {
            list.addAll(Arrays.asList(MultiTermHighlighting.extractAutomata(((SpanNotQuery)query).getInclude(), fieldMatcher, lookInSpan, preRewriteFunc)));
        } else if (lookInSpan && query instanceof SpanPositionCheckQuery) {
            list.addAll(Arrays.asList(MultiTermHighlighting.extractAutomata(((SpanPositionCheckQuery)query).getMatch(), fieldMatcher, lookInSpan, preRewriteFunc)));
        } else if (lookInSpan && query instanceof SpanBoostQuery) {
            list.addAll(Arrays.asList(MultiTermHighlighting.extractAutomata(((SpanBoostQuery)query).getQuery(), fieldMatcher, lookInSpan, preRewriteFunc)));
        } else if (lookInSpan && query instanceof SpanMultiTermQueryWrapper) {
            list.addAll(Arrays.asList(MultiTermHighlighting.extractAutomata(((SpanMultiTermQueryWrapper)query).getWrappedQuery(), fieldMatcher, lookInSpan, preRewriteFunc)));
        } else if (query instanceof FuzzyQuery) {
            final FuzzyQuery fq = (FuzzyQuery)query;
            if (fieldMatcher.test(fq.getField())) {
                int cp;
                String utf16 = fq.getTerm().text();
                int[] termText = new int[utf16.codePointCount(0, utf16.length())];
                int j = 0;
                for (int i = 0; i < utf16.length(); i += Character.charCount(cp)) {
                    termText[j++] = cp = utf16.codePointAt(i);
                }
                int termLength = termText.length;
                int prefixLength = Math.min(fq.getPrefixLength(), termLength);
                String suffix = UnicodeUtil.newString(termText, prefixLength, termText.length - prefixLength);
                LevenshteinAutomata builder = new LevenshteinAutomata(suffix, fq.getTranspositions());
                String prefix = UnicodeUtil.newString(termText, 0, prefixLength);
                Automaton automaton = builder.toAutomaton(fq.getMaxEdits(), prefix);
                list.add(new CharacterRunAutomaton(automaton){

                    @Override
                    public String toString() {
                        return fq.toString();
                    }
                });
            }
        } else if (query instanceof AutomatonQuery && fieldMatcher.test((aq = (AutomatonQuery)query).getField())) {
            if (!aq.isAutomatonBinary()) {
                list.add(new CharacterRunAutomaton(aq.getAutomaton()){

                    @Override
                    public String toString() {
                        return aq.toString();
                    }
                });
            } else {
                list.add(new CharacterRunAutomaton(Automata.makeEmpty()){
                    ByteRunAutomaton byteRunAutomaton;
                    {
                        super(x0);
                        this.byteRunAutomaton = new ByteRunAutomaton(aq.getAutomaton(), true, 10000);
                    }

                    @Override
                    public boolean run(char[] chars, int offset, int length) {
                        int state = 0;
                        int maxIdx = offset + length;
                        for (int i = offset; i < maxIdx; ++i) {
                            char code = chars[i];
                            if (code < '\u0080') {
                                if ((state = this.byteRunAutomaton.step(state, code)) != -1) continue;
                                return false;
                            }
                            if (code < '\u0800') {
                                int b = 0xC0 | code >> 6;
                                if ((state = this.byteRunAutomaton.step(state, b)) == -1) {
                                    return false;
                                }
                                b = 0x80 | code & 0x3F;
                                if ((state = this.byteRunAutomaton.step(state, b)) != -1) continue;
                                return false;
                            }
                            byte[] utf8Bytes = new byte[4 * (maxIdx - i)];
                            int utf8Len = UnicodeUtil.UTF16toUTF8(chars, i, maxIdx - i, utf8Bytes);
                            for (int utfIdx = 0; utfIdx < utf8Len; ++utfIdx) {
                                if ((state = this.byteRunAutomaton.step(state, utf8Bytes[utfIdx] & 0xFF)) != -1) continue;
                                return false;
                            }
                            break;
                        }
                        return this.byteRunAutomaton.isAccept(state);
                    }

                    @Override
                    public String toString() {
                        return aq.toString();
                    }
                });
            }
        }
        return list.toArray(new CharacterRunAutomaton[list.size()]);
    }
}

