/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.net.InetAddress;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.document.RangeFieldQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.StringHelper;

public class InetAddressRange
extends Field {
    public static final int BYTES = 16;
    private static final FieldType TYPE = new FieldType();

    public InetAddressRange(String name, InetAddress min, InetAddress max) {
        super(name, TYPE);
        this.setRangeValues(min, max);
    }

    public void setRangeValues(InetAddress min, InetAddress max) {
        byte[] bytes;
        if (this.fieldsData == null) {
            bytes = new byte[32];
            this.fieldsData = new BytesRef(bytes);
        } else {
            bytes = ((BytesRef)this.fieldsData).bytes;
        }
        InetAddressRange.encode(min, max, bytes);
    }

    private static void encode(InetAddress min, InetAddress max, byte[] bytes) {
        byte[] maxEncoded;
        byte[] minEncoded = InetAddressPoint.encode(min);
        if (StringHelper.compare(16, minEncoded, 0, maxEncoded = InetAddressPoint.encode(max), 0) > 0) {
            throw new IllegalArgumentException("min value cannot be greater than max value for InetAddressRange field");
        }
        System.arraycopy(minEncoded, 0, bytes, 0, 16);
        System.arraycopy(maxEncoded, 0, bytes, 16, 16);
    }

    private static byte[] encode(InetAddress min, InetAddress max) {
        byte[] b = new byte[32];
        InetAddressRange.encode(min, max, b);
        return b;
    }

    public static Query newIntersectsQuery(String field, InetAddress min, InetAddress max) {
        return InetAddressRange.newRelationQuery(field, min, max, RangeFieldQuery.QueryType.INTERSECTS);
    }

    public static Query newContainsQuery(String field, InetAddress min, InetAddress max) {
        return InetAddressRange.newRelationQuery(field, min, max, RangeFieldQuery.QueryType.CONTAINS);
    }

    public static Query newWithinQuery(String field, InetAddress min, InetAddress max) {
        return InetAddressRange.newRelationQuery(field, min, max, RangeFieldQuery.QueryType.WITHIN);
    }

    public static Query newCrossesQuery(String field, InetAddress min, InetAddress max) {
        return InetAddressRange.newRelationQuery(field, min, max, RangeFieldQuery.QueryType.CROSSES);
    }

    private static Query newRelationQuery(String field, InetAddress min, InetAddress max, RangeFieldQuery.QueryType relation) {
        return new RangeFieldQuery(field, InetAddressRange.encode(min, max), 1, relation){

            @Override
            protected String toString(byte[] ranges, int dimension) {
                return InetAddressRange.toString(ranges, dimension);
            }
        };
    }

    private static String toString(byte[] ranges, int dimension) {
        byte[] min = new byte[16];
        System.arraycopy(ranges, 0, min, 0, 16);
        byte[] max = new byte[16];
        System.arraycopy(ranges, 16, max, 0, 16);
        return "[" + InetAddressPoint.decode(min) + " : " + InetAddressPoint.decode(max) + "]";
    }

    static {
        TYPE.setDimensions(2, 16);
        TYPE.freeze();
    }
}

