/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.spark.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Properties;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.UnsafeMapData;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.ArrayData$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Functions;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.PropertyContainer;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.exceptions.SessionExpiredException;
import org.neo4j.driver.exceptions.TransientException;
import org.neo4j.driver.internal.InternalIsoDuration;
import org.neo4j.driver.internal.InternalNode;
import org.neo4j.driver.internal.InternalPoint2D;
import org.neo4j.driver.internal.InternalPoint3D;
import org.neo4j.driver.internal.InternalRelationship;
import org.neo4j.driver.types.Entity;
import org.neo4j.driver.types.Path;
import org.neo4j.spark.service.SchemaService;
import org.neo4j.spark.service.SchemaService$;
import org.neo4j.spark.util.DriverCache;
import org.neo4j.spark.util.Neo4jImplicits$;
import org.neo4j.spark.util.Neo4jOptions;
import org.neo4j.spark.util.QueryType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class Neo4jUtil$ {
    public static final Neo4jUtil$ MODULE$;
    private final String NODE_ALIAS;
    private final String INTERNAL_ID_FIELD;
    private final String INTERNAL_LABELS_FIELD;
    private final String INTERNAL_REL_ID_FIELD;
    private final String INTERNAL_REL_TYPE_FIELD;
    private final String RELATIONSHIP_SOURCE_ALIAS;
    private final String RELATIONSHIP_TARGET_ALIAS;
    private final String INTERNAL_REL_SOURCE_ID_FIELD;
    private final String INTERNAL_REL_TARGET_ID_FIELD;
    private final String RELATIONSHIP_ALIAS;
    private final Properties properties;
    private final ObjectMapper mapper;
    private final SimpleModule module;

    static {
        new Neo4jUtil$();
    }

    public String NODE_ALIAS() {
        return this.NODE_ALIAS;
    }

    public String INTERNAL_ID_FIELD() {
        return this.INTERNAL_ID_FIELD;
    }

    public String INTERNAL_LABELS_FIELD() {
        return this.INTERNAL_LABELS_FIELD;
    }

    public String INTERNAL_REL_ID_FIELD() {
        return this.INTERNAL_REL_ID_FIELD;
    }

    public String INTERNAL_REL_TYPE_FIELD() {
        return this.INTERNAL_REL_TYPE_FIELD;
    }

    public String RELATIONSHIP_SOURCE_ALIAS() {
        return this.RELATIONSHIP_SOURCE_ALIAS;
    }

    public String RELATIONSHIP_TARGET_ALIAS() {
        return this.RELATIONSHIP_TARGET_ALIAS;
    }

    public String INTERNAL_REL_SOURCE_ID_FIELD() {
        return this.INTERNAL_REL_SOURCE_ID_FIELD;
    }

    public String INTERNAL_REL_TARGET_ID_FIELD() {
        return this.INTERNAL_REL_TARGET_ID_FIELD;
    }

    public String RELATIONSHIP_ALIAS() {
        return this.RELATIONSHIP_ALIAS;
    }

    private Properties properties() {
        return this.properties;
    }

    public void closeSafety(AutoCloseable autoCloseable, Logger logger) {
        block12: {
            try {
                AutoCloseable autoCloseable2 = autoCloseable;
                if (autoCloseable2 instanceof Session) {
                    BoxedUnit boxedUnit;
                    Session session = (Session)autoCloseable2;
                    if (session.isOpen()) {
                        session.close();
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else if (autoCloseable2 instanceof Transaction) {
                    BoxedUnit boxedUnit;
                    Transaction transaction = (Transaction)autoCloseable2;
                    if (transaction.isOpen()) {
                        transaction.close();
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit;
                } else if (autoCloseable2 == null) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    autoCloseable.close();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (Throwable throwable) {
                if (logger == null) break block12;
                logger.warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot close ", " because of the following exception:"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{autoCloseable.getClass().getSimpleName()})), throwable);
            }
        }
    }

    public Logger closeSafety$default$2() {
        return null;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    private SimpleModule module() {
        return this.module;
    }

    public Object convertFromNeo4j(Object value2, DataType schema) {
        Object object;
        Object object2;
        while (schema != null) {
            DataType dataType = schema;
            DataType dataType2 = DataTypes.StringType;
            if (dataType != null ? !dataType.equals(dataType2) : dataType2 != null) break;
            if (value2 == null || value2 instanceof String) break;
            value2 = this.mapper().writeValueAsString(value2);
        }
        if ((object2 = value2) instanceof InternalNode) {
            InternalNode internalNode = (InternalNode)object2;
            java.util.Map<String, Object> map = internalNode.asMap();
            StructType structType = this.extractStructType(schema);
            Seq fields = (Seq)((TraversableLike)structType.filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean apply(StructField field) {
                    String string = field.name();
                    String string2 = Neo4jUtil$.MODULE$.INTERNAL_ID_FIELD();
                    if (string == null) {
                        if (string2 == null) return false;
                    } else if (string.equals(string2)) return false;
                    String string3 = field.name();
                    String string4 = Neo4jUtil$.MODULE$.INTERNAL_LABELS_FIELD();
                    if (string3 != null) {
                        if (!string3.equals(string4)) return true;
                        return false;
                    }
                    if (string4 == null) return false;
                    return true;
                }
            })).map((Function1)new Serializable(map){
                public static final long serialVersionUID = 0L;
                private final java.util.Map map$1;

                public final Object apply(StructField field) {
                    return Neo4jUtil$.MODULE$.convertFromNeo4j(this.map$1.get(field.name()), field.dataType());
                }
                {
                    this.map$1 = map$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
            object = InternalRow$.MODULE$.fromSeq((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.convertFromNeo4j(BoxesRunTime.boxToLong((long)internalNode.id()), this.convertFromNeo4j$default$2()), this.convertFromNeo4j(internalNode.labels(), this.convertFromNeo4j$default$2())}))).$plus$plus((GenTraversableOnce)fields, Seq$.MODULE$.canBuildFrom()));
        } else if (object2 instanceof InternalRelationship) {
            InternalRelationship internalRelationship = (InternalRelationship)object2;
            java.util.Map<String, Object> map = internalRelationship.asMap();
            StructType structType = this.extractStructType(schema);
            Seq fields = (Seq)((TraversableLike)structType.filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean apply(StructField field) {
                    String string = field.name();
                    String string2 = Neo4jUtil$.MODULE$.INTERNAL_REL_ID_FIELD();
                    if (string == null) {
                        if (string2 == null) return false;
                    } else if (string.equals(string2)) return false;
                    String string3 = field.name();
                    String string4 = Neo4jUtil$.MODULE$.INTERNAL_REL_TYPE_FIELD();
                    if (string3 == null) {
                        if (string4 == null) return false;
                    } else if (string3.equals(string4)) return false;
                    String string5 = field.name();
                    String string6 = Neo4jUtil$.MODULE$.INTERNAL_REL_SOURCE_ID_FIELD();
                    if (string5 == null) {
                        if (string6 == null) return false;
                    } else if (string5.equals(string6)) return false;
                    String string7 = field.name();
                    String string8 = Neo4jUtil$.MODULE$.INTERNAL_REL_TARGET_ID_FIELD();
                    if (string7 != null) {
                        if (!string7.equals(string8)) return true;
                        return false;
                    }
                    if (string8 == null) return false;
                    return true;
                }
            })).map((Function1)new Serializable(map){
                public static final long serialVersionUID = 0L;
                private final java.util.Map map$2;

                public final Object apply(StructField field) {
                    return Neo4jUtil$.MODULE$.convertFromNeo4j(this.map$2.get(field.name()), field.dataType());
                }
                {
                    this.map$2 = map$2;
                }
            }, Seq$.MODULE$.canBuildFrom());
            object = InternalRow$.MODULE$.fromSeq((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.convertFromNeo4j(BoxesRunTime.boxToLong((long)internalRelationship.id()), this.convertFromNeo4j$default$2()), this.convertFromNeo4j(internalRelationship.type(), this.convertFromNeo4j$default$2()), this.convertFromNeo4j(BoxesRunTime.boxToLong((long)internalRelationship.startNodeId()), this.convertFromNeo4j$default$2()), this.convertFromNeo4j(BoxesRunTime.boxToLong((long)internalRelationship.endNodeId()), this.convertFromNeo4j$default$2())}))).$plus$plus((GenTraversableOnce)fields, Seq$.MODULE$.canBuildFrom()));
        } else if (object2 instanceof InternalIsoDuration) {
            InternalIsoDuration internalIsoDuration = (InternalIsoDuration)object2;
            long months = internalIsoDuration.months();
            long days = internalIsoDuration.days();
            Integer nanoseconds = Predef$.MODULE$.int2Integer(internalIsoDuration.nanoseconds());
            long seconds = internalIsoDuration.seconds();
            object = InternalRow$.MODULE$.fromSeq((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)SchemaService$.MODULE$.DURATION_TYPE()), BoxesRunTime.boxToLong((long)months), BoxesRunTime.boxToLong((long)days), BoxesRunTime.boxToLong((long)seconds), nanoseconds, UTF8String.fromString((String)internalIsoDuration.toString())})));
        } else if (object2 instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)object2;
            object = BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.instantToMicros(zonedDateTime.toInstant()));
        } else if (object2 instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object2;
            object = BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.instantToMicros(localDateTime.toInstant(ZoneOffset.UTC)));
        } else if (object2 instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object2;
            object = BoxesRunTime.boxToInteger((int)((int)localDate.toEpochDay()));
        } else if (object2 instanceof LocalTime) {
            LocalTime localTime = (LocalTime)object2;
            object = InternalRow$.MODULE$.fromSeq((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UTF8String[]{UTF8String.fromString((String)SchemaService$.MODULE$.TIME_TYPE_LOCAL()), UTF8String.fromString((String)localTime.format(DateTimeFormatter.ISO_TIME))})));
        } else if (object2 instanceof OffsetTime) {
            OffsetTime offsetTime = (OffsetTime)object2;
            object = InternalRow$.MODULE$.fromSeq((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UTF8String[]{UTF8String.fromString((String)SchemaService$.MODULE$.TIME_TYPE_OFFSET()), UTF8String.fromString((String)offsetTime.format(DateTimeFormatter.ISO_TIME))})));
        } else if (object2 instanceof InternalPoint2D) {
            InternalPoint2D internalPoint2D = (InternalPoint2D)object2;
            Integer srid = Predef$.MODULE$.int2Integer(internalPoint2D.srid());
            object = InternalRow$.MODULE$.fromSeq((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)SchemaService$.MODULE$.POINT_TYPE_2D()), srid, BoxesRunTime.boxToDouble((double)internalPoint2D.x()), BoxesRunTime.boxToDouble((double)internalPoint2D.y()), null})));
        } else if (object2 instanceof InternalPoint3D) {
            InternalPoint3D internalPoint3D = (InternalPoint3D)object2;
            Integer srid = Predef$.MODULE$.int2Integer(internalPoint3D.srid());
            object = InternalRow$.MODULE$.fromSeq((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)SchemaService$.MODULE$.POINT_TYPE_3D()), srid, BoxesRunTime.boxToDouble((double)internalPoint3D.x()), BoxesRunTime.boxToDouble((double)internalPoint3D.y()), BoxesRunTime.boxToDouble((double)internalPoint3D.z())})));
        } else if (object2 instanceof List) {
            List list = (List)object2;
            DataType elementType = schema == null ? null : ((ArrayType)schema).elementType();
            object = ArrayData$.MODULE$.toArrayData(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).map((Function1)new Serializable(elementType){
                public static final long serialVersionUID = 0L;
                private final DataType elementType$1;

                public final Object apply(Object e) {
                    return Neo4jUtil$.MODULE$.convertFromNeo4j(e, this.elementType$1);
                }
                {
                    this.elementType$1 = elementType$1;
                }
            }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any()));
        } else if (object2 instanceof java.util.Map) {
            ArrayBasedMapData arrayBasedMapData;
            java.util.Map map = (java.util.Map)object2;
            if (schema == null) {
                arrayBasedMapData = ArrayBasedMapData$.MODULE$.apply((Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(Tuple2<Object, Object> t) {
                        return new Tuple2(Neo4jUtil$.MODULE$.convertFromNeo4j(t._1(), Neo4jUtil$.MODULE$.convertFromNeo4j$default$2()), Neo4jUtil$.MODULE$.convertFromNeo4j(t._2(), Neo4jUtil$.MODULE$.convertFromNeo4j$default$2()));
                    }
                }, Map$.MODULE$.canBuildFrom()), ArrayBasedMapData$.MODULE$.apply$default$2(), ArrayBasedMapData$.MODULE$.apply$default$3());
            } else {
                MapType mapType = (MapType)schema;
                arrayBasedMapData = ArrayBasedMapData$.MODULE$.apply((Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).map((Function1)new Serializable(mapType){
                    public static final long serialVersionUID = 0L;
                    private final MapType mapType$1;

                    public final Tuple2<Object, Object> apply(Tuple2<Object, Object> t) {
                        return new Tuple2(Neo4jUtil$.MODULE$.convertFromNeo4j(t._1(), this.mapType$1.keyType()), Neo4jUtil$.MODULE$.convertFromNeo4j(t._2(), this.mapType$1.valueType()));
                    }
                    {
                        this.mapType$1 = mapType$1;
                    }
                }, Map$.MODULE$.canBuildFrom()), ArrayBasedMapData$.MODULE$.apply$default$2(), ArrayBasedMapData$.MODULE$.apply$default$3());
            }
            object = arrayBasedMapData;
        } else if (object2 instanceof String) {
            String string = (String)object2;
            object = UTF8String.fromString((String)string);
        } else {
            object = value2;
        }
        return object;
    }

    public DataType convertFromNeo4j$default$2() {
        return null;
    }

    private StructType extractStructType(DataType dataType) {
        while (true) {
            DataType dataType2;
            if ((dataType2 = dataType) instanceof StructType) {
                StructType structType;
                StructType structType2 = structType = (StructType)dataType2;
                return structType2;
            }
            if (dataType2 instanceof MapType) {
                MapType mapType = (MapType)dataType2;
                dataType = mapType.valueType();
                continue;
            }
            if (!(dataType2 instanceof ArrayType)) break;
            ArrayType arrayType = (ArrayType)dataType2;
            dataType = arrayType.elementType();
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType})));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object convertFromSpark(Object value2, StructField schema) {
        while (true) {
            Object object;
            if ((object = value2) instanceof Date) {
                Date date = (Date)object;
                value2 = date.toLocalDate();
                continue;
            }
            if (object instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)object;
                value2 = timestamp.toInstant().atZone(ZoneOffset.UTC);
                continue;
            }
            if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                if (schema != null) {
                    DataType dataType = schema.dataType();
                    DataType dataType2 = DataTypes.DateType;
                    if (!(dataType != null ? !dataType.equals(dataType2) : dataType2 != null)) {
                        value2 = DateTimeUtils$.MODULE$.toJavaDate(n);
                        continue;
                    }
                }
            }
            if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                if (schema != null) {
                    DataType dataType = schema.dataType();
                    DataType dataType3 = DataTypes.TimestampType;
                    if (!(dataType != null ? !dataType.equals(dataType3) : dataType3 != null)) {
                        value2 = DateTimeUtils$.MODULE$.toJavaTimestamp(l);
                        continue;
                    }
                }
            }
            if (object instanceof UnsafeRow) {
                UnsafeRow unsafeRow = (UnsafeRow)object;
                StructType structType = this.extractStructType(schema.dataType());
                GenericRowWithSchema row = new GenericRowWithSchema((Object[])unsafeRow.toSeq(structType).toArray(ClassTag$.MODULE$.Any()), structType);
                schema = this.convertFromSpark$default$2();
                value2 = row;
                continue;
            }
            if (object instanceof GenericRowWithSchema) {
                Value value3;
                GenericRowWithSchema genericRowWithSchema = (GenericRowWithSchema)object;
                try {
                    Value value5;
                    String string = ((UTF8String)genericRowWithSchema.getAs("type")).toString();
                    String string2 = SchemaService$.MODULE$.POINT_TYPE_2D();
                    String string3 = string;
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        value5 = Values.point(((Number)genericRowWithSchema.getAs("srid")).intValue(), ((Number)genericRowWithSchema.getAs("x")).doubleValue(), ((Number)genericRowWithSchema.getAs("y")).doubleValue());
                    } else {
                        String string4 = SchemaService$.MODULE$.POINT_TYPE_3D();
                        String string5 = string;
                        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                            value5 = Values.point(((Number)genericRowWithSchema.getAs("srid")).intValue(), ((Number)genericRowWithSchema.getAs("x")).doubleValue(), ((Number)genericRowWithSchema.getAs("y")).doubleValue(), ((Number)genericRowWithSchema.getAs("z")).doubleValue());
                        } else {
                            String string6 = SchemaService$.MODULE$.DURATION_TYPE();
                            String string7 = string;
                            if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                                value5 = Values.isoDuration(((Number)genericRowWithSchema.getAs("months")).longValue(), ((Number)genericRowWithSchema.getAs("days")).longValue(), ((Number)genericRowWithSchema.getAs("seconds")).longValue(), ((Number)genericRowWithSchema.getAs("nanoseconds")).intValue());
                            } else {
                                String string8 = SchemaService$.MODULE$.TIME_TYPE_OFFSET();
                                String string9 = string;
                                if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                                    value5 = Values.value(OffsetTime.parse((CharSequence)genericRowWithSchema.getAs("value")));
                                } else {
                                    String string10 = SchemaService$.MODULE$.TIME_TYPE_LOCAL();
                                    String string11 = string;
                                    value5 = !(string10 != null ? !string10.equals(string11) : string11 != null) ? Values.value(LocalTime.parse((CharSequence)genericRowWithSchema.getAs("value"))) : this.toMap$1(genericRowWithSchema);
                                }
                            }
                        }
                    }
                    value3 = value5;
                    return value3;
                }
                catch (Throwable throwable) {
                    value3 = this.toMap$1(genericRowWithSchema);
                }
                return value3;
            }
            if (object instanceof UnsafeArrayData) {
                DataType dataType;
                UnsafeArrayData unsafeArrayData = (UnsafeArrayData)object;
                DataType dataType4 = schema.dataType();
                if (dataType4 instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType4;
                    dataType = arrayType.elementType();
                } else {
                    dataType = schema.dataType();
                }
                DataType sparkType = dataType;
                List javaList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)unsafeArrayData.toSeq(sparkType).map((Function1)new Serializable(schema){
                    public static final long serialVersionUID = 0L;
                    private final StructField schema$1;

                    public final Object apply(Object elem) {
                        return Neo4jUtil$.MODULE$.convertFromSpark(elem, this.schema$1);
                    }
                    {
                        this.schema$1 = schema$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).asJava();
                return Values.value(javaList);
            }
            if (object instanceof UnsafeMapData) {
                UnsafeMapData unsafeMapData = (UnsafeMapData)object;
                MapType mapType = (MapType)schema.dataType();
                return Values.value((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), unsafeMapData.numElements() - 1).map((Function1)new Serializable(mapType, unsafeMapData){
                    public static final long serialVersionUID = 0L;
                    private final MapType mapType$2;
                    private final UnsafeMapData x9$1;

                    public final Tuple2<String, Object> apply(int i) {
                        return new Tuple2((Object)this.x9$1.keyArray().getUTF8String(i).toString(), this.x9$1.valueArray().get(i, this.mapType$2.valueType()));
                    }
                    {
                        this.mapType$2 = mapType$2;
                        this.x9$1 = x9$1;
                    }
                }, scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).mapValues((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(Object value2) {
                        return Neo4jUtil$.MODULE$.convertFromSpark(value2, Neo4jUtil$.MODULE$.convertFromSpark$default$2());
                    }
                })).asJava());
            }
            if (!(object instanceof UTF8String)) {
                return Values.value(value2);
            }
            UTF8String uTF8String = (UTF8String)object;
            schema = this.convertFromSpark$default$2();
            value2 = uTF8String.toString();
        }
    }

    public StructField convertFromSpark$default$2() {
        return null;
    }

    public java.util.Map<String, Object> flattenMap(java.util.Map<String, Object> map, String prefix) {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).flatMap((Function1)new Serializable(prefix){
            public static final long serialVersionUID = 0L;
            private final String prefix$1;

            public final Seq<Tuple2<String, Object>> apply(Tuple2<String, Object> t) {
                Seq seq;
                String string = this.prefix$1;
                String string2 = "";
                String key = !(string != null ? !string.equals(string2) : string2 != null) ? Neo4jImplicits$.MODULE$.CypherImplicits((String)t._1()).quote() : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Neo4jImplicits$.MODULE$.CypherImplicits(this.prefix$1).quote(), Neo4jImplicits$.MODULE$.CypherImplicits((String)t._1()).quote()}));
                Object object = t._2();
                if (object instanceof scala.collection.immutable.Map) {
                    scala.collection.immutable.Map map = (scala.collection.immutable.Map)object;
                    seq = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Neo4jUtil$.MODULE$.flattenMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)map).asJava(), key)).asScala()).toSeq();
                } else {
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)key, t._2())}));
                }
                return seq;
            }
            {
                this.prefix$1 = prefix$1;
            }
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
    }

    public String flattenMap$default$2() {
        return "";
    }

    public boolean isLong(String str) {
        boolean bl;
        if (str == null) {
            bl = false;
        } else {
            try {
                new StringOps(Predef$.MODULE$.augmentString(str.trim())).toLong();
                bl = true;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        return bl;
    }

    public String connectorVersion() {
        return this.properties().getOrDefault((Object)"version", "UNKNOWN").toString();
    }

    public Property getCorrectProperty(PropertyContainer container, String attribute) {
        return container.property(new StringOps(Predef$.MODULE$.augmentString(attribute)).split('.'));
    }

    public scala.collection.immutable.Map<String, Object> paramsFromFilters(Filter[] filters) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])filters).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<Filter> apply(Filter f) {
                return Predef$.MODULE$.refArrayOps((Object[])Neo4jImplicits$.MODULE$.FilterImplicit(f).flattenFilters());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Filter.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Filter x$1) {
                return Neo4jImplicits$.MODULE$.FilterImplicit(x$1).getAttributeAndValue();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)))).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<Object> x$2) {
                return x$2.nonEmpty();
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(Seq<Object> valAndAtt) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Neo4jImplicits$.MODULE$.CypherImplicits(valAndAtt.head().toString()).unquote()), Neo4jUtil$.MODULE$.toParamValue(valAndAtt.apply(1)));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
    }

    public Object toParamValue(Object value2) {
        Object object;
        Object object2 = value2;
        if (object2 instanceof Date) {
            Date date = (Date)object2;
            object = date.toString();
        } else if (object2 instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object2;
            object = timestamp.toLocalDateTime().toString();
        } else {
            object = value2;
        }
        return object;
    }

    public Expression valueToCypherExpression(String attribute, Object value2) {
        Parameter parameter = Cypher.parameter(Neo4jImplicits$.MODULE$.CypherImplicits(attribute).toParameterName(value2));
        Object object = value2;
        Expression expression = object instanceof Date ? Functions.date(parameter) : (object instanceof Timestamp ? Functions.localdatetime(parameter) : parameter);
        return expression;
    }

    public Condition mapSparkFiltersToCypher(Filter filter, PropertyContainer container, Option<String> attributeAlias) {
        Filter filter2;
        block17: {
            Condition condition;
            block5: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        block10: {
                                            block9: {
                                                block8: {
                                                    block7: {
                                                        block6: {
                                                            block4: {
                                                                filter2 = filter;
                                                                if (!(filter2 instanceof EqualNullSafe)) break block4;
                                                                EqualNullSafe equalNullSafe = (EqualNullSafe)filter2;
                                                                Expression parameter = this.valueToCypherExpression(equalNullSafe.attribute(), equalNullSafe.value());
                                                                Property property = this.getCorrectProperty(container, (String)attributeAlias.getOrElse((Function0)new Serializable(equalNullSafe){
                                                                    public static final long serialVersionUID = 0L;
                                                                    private final EqualNullSafe x2$1;

                                                                    public final String apply() {
                                                                        return this.x2$1.attribute();
                                                                    }
                                                                    {
                                                                        this.x2$1 = x2$1;
                                                                    }
                                                                }));
                                                                condition = property.isNull().and(parameter.isNull()).or(property.isEqualTo(parameter));
                                                                break block5;
                                                            }
                                                            if (!(filter2 instanceof EqualTo)) break block6;
                                                            EqualTo equalTo = (EqualTo)filter2;
                                                            condition = this.getCorrectProperty(container, (String)attributeAlias.getOrElse((Function0)new Serializable(equalTo){
                                                                public static final long serialVersionUID = 0L;
                                                                private final EqualTo x3$1;

                                                                public final String apply() {
                                                                    return this.x3$1.attribute();
                                                                }
                                                                {
                                                                    this.x3$1 = x3$1;
                                                                }
                                                            })).isEqualTo(this.valueToCypherExpression(equalTo.attribute(), equalTo.value()));
                                                            break block5;
                                                        }
                                                        if (!(filter2 instanceof GreaterThan)) break block7;
                                                        GreaterThan greaterThan = (GreaterThan)filter2;
                                                        condition = this.getCorrectProperty(container, (String)attributeAlias.getOrElse((Function0)new Serializable(greaterThan){
                                                            public static final long serialVersionUID = 0L;
                                                            private final GreaterThan x4$1;

                                                            public final String apply() {
                                                                return this.x4$1.attribute();
                                                            }
                                                            {
                                                                this.x4$1 = x4$1;
                                                            }
                                                        })).gt(this.valueToCypherExpression(greaterThan.attribute(), greaterThan.value()));
                                                        break block5;
                                                    }
                                                    if (!(filter2 instanceof GreaterThanOrEqual)) break block8;
                                                    GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter2;
                                                    condition = this.getCorrectProperty(container, (String)attributeAlias.getOrElse((Function0)new Serializable(greaterThanOrEqual){
                                                        public static final long serialVersionUID = 0L;
                                                        private final GreaterThanOrEqual x5$1;

                                                        public final String apply() {
                                                            return this.x5$1.attribute();
                                                        }
                                                        {
                                                            this.x5$1 = x5$1;
                                                        }
                                                    })).gte(this.valueToCypherExpression(greaterThanOrEqual.attribute(), greaterThanOrEqual.value()));
                                                    break block5;
                                                }
                                                if (!(filter2 instanceof LessThan)) break block9;
                                                LessThan lessThan = (LessThan)filter2;
                                                condition = this.getCorrectProperty(container, (String)attributeAlias.getOrElse((Function0)new Serializable(lessThan){
                                                    public static final long serialVersionUID = 0L;
                                                    private final LessThan x6$1;

                                                    public final String apply() {
                                                        return this.x6$1.attribute();
                                                    }
                                                    {
                                                        this.x6$1 = x6$1;
                                                    }
                                                })).lt(this.valueToCypherExpression(lessThan.attribute(), lessThan.value()));
                                                break block5;
                                            }
                                            if (!(filter2 instanceof LessThanOrEqual)) break block10;
                                            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter2;
                                            condition = this.getCorrectProperty(container, (String)attributeAlias.getOrElse((Function0)new Serializable(lessThanOrEqual){
                                                public static final long serialVersionUID = 0L;
                                                private final LessThanOrEqual x7$1;

                                                public final String apply() {
                                                    return this.x7$1.attribute();
                                                }
                                                {
                                                    this.x7$1 = x7$1;
                                                }
                                            })).lte(this.valueToCypherExpression(lessThanOrEqual.attribute(), lessThanOrEqual.value()));
                                            break block5;
                                        }
                                        if (!(filter2 instanceof In)) break block11;
                                        In in = (In)filter2;
                                        condition = this.getCorrectProperty(container, (String)attributeAlias.getOrElse((Function0)new Serializable(in){
                                            public static final long serialVersionUID = 0L;
                                            private final In x8$1;

                                            public final String apply() {
                                                return this.x8$1.attribute();
                                            }
                                            {
                                                this.x8$1 = x8$1;
                                            }
                                        })).in(this.valueToCypherExpression(in.attribute(), in.values()));
                                        break block5;
                                    }
                                    if (!(filter2 instanceof StringStartsWith)) break block12;
                                    StringStartsWith stringStartsWith = (StringStartsWith)filter2;
                                    condition = this.getCorrectProperty(container, (String)attributeAlias.getOrElse((Function0)new Serializable(stringStartsWith){
                                        public static final long serialVersionUID = 0L;
                                        private final StringStartsWith x9$2;

                                        public final String apply() {
                                            return this.x9$2.attribute();
                                        }
                                        {
                                            this.x9$2 = x9$2;
                                        }
                                    })).startsWith(this.valueToCypherExpression(stringStartsWith.attribute(), stringStartsWith.value()));
                                    break block5;
                                }
                                if (!(filter2 instanceof StringEndsWith)) break block13;
                                StringEndsWith stringEndsWith = (StringEndsWith)filter2;
                                condition = this.getCorrectProperty(container, (String)attributeAlias.getOrElse((Function0)new Serializable(stringEndsWith){
                                    public static final long serialVersionUID = 0L;
                                    private final StringEndsWith x10$1;

                                    public final String apply() {
                                        return this.x10$1.attribute();
                                    }
                                    {
                                        this.x10$1 = x10$1;
                                    }
                                })).endsWith(this.valueToCypherExpression(stringEndsWith.attribute(), stringEndsWith.value()));
                                break block5;
                            }
                            if (!(filter2 instanceof StringContains)) break block14;
                            StringContains stringContains = (StringContains)filter2;
                            condition = this.getCorrectProperty(container, (String)attributeAlias.getOrElse((Function0)new Serializable(stringContains){
                                public static final long serialVersionUID = 0L;
                                private final StringContains x11$1;

                                public final String apply() {
                                    return this.x11$1.attribute();
                                }
                                {
                                    this.x11$1 = x11$1;
                                }
                            })).contains(this.valueToCypherExpression(stringContains.attribute(), stringContains.value()));
                            break block5;
                        }
                        if (!(filter2 instanceof IsNotNull)) break block15;
                        IsNotNull isNotNull = (IsNotNull)filter2;
                        condition = this.getCorrectProperty(container, (String)attributeAlias.getOrElse((Function0)new Serializable(isNotNull){
                            public static final long serialVersionUID = 0L;
                            private final IsNotNull x12$1;

                            public final String apply() {
                                return this.x12$1.attribute();
                            }
                            {
                                this.x12$1 = x12$1;
                            }
                        })).isNotNull();
                        break block5;
                    }
                    if (!(filter2 instanceof IsNull)) break block16;
                    IsNull isNull = (IsNull)filter2;
                    condition = this.getCorrectProperty(container, (String)attributeAlias.getOrElse((Function0)new Serializable(isNull){
                        public static final long serialVersionUID = 0L;
                        private final IsNull x13$1;

                        public final String apply() {
                            return this.x13$1.attribute();
                        }
                        {
                            this.x13$1 = x13$1;
                        }
                    })).isNull();
                    break block5;
                }
                if (!(filter2 instanceof Not)) break block17;
                Not not = (Not)filter2;
                condition = this.mapSparkFiltersToCypher(not.child(), container, attributeAlias).not();
            }
            return condition;
        }
        if (filter2 != null) {
            Filter filter3 = filter2;
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Filter of type `", "` is not supported."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filter3})));
        }
        throw new MatchError((Object)filter2);
    }

    public Option<String> mapSparkFiltersToCypher$default$3() {
        return None$.MODULE$;
    }

    public String getStreamingPropertyName(Neo4jOptions options) {
        Enumeration.Value value2 = options.query().queryType();
        Enumeration.Value value3 = QueryType$.MODULE$.RELATIONSHIP();
        Enumeration.Value value4 = value2;
        String string = !(value3 != null ? !value3.equals(value4) : value4 != null) ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rel.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{options.streamingOptions().propertyName()})) : options.streamingOptions().propertyName();
        return string;
    }

    public <T> T callSchemaService(Neo4jOptions neo4jOptions, String jobId, Filter[] filters, Function1<SchemaService, T> function) {
        Object object;
        block5: {
            DriverCache driverCache = new DriverCache(neo4jOptions.connection(), jobId);
            SchemaService schemaService = new SchemaService(neo4jOptions, driverCache, filters);
            boolean hasError = false;
            try {
                object = function.apply((Object)schemaService);
                schemaService.close();
                if (!hasError) break block5;
                driverCache.close();
            }
            catch (Throwable throwable) {
                try {
                    hasError = true;
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    schemaService.close();
                    if (hasError) {
                        driverCache.close();
                    }
                    throw throwable2;
                }
            }
        }
        return (T)object;
    }

    public boolean isRetryableException(Neo4jException neo4jTransientException) {
        return neo4jTransientException instanceof SessionExpiredException || neo4jTransientException instanceof TransientException || neo4jTransientException instanceof ServiceUnavailableException;
    }

    private final Value toMap$1(GenericRowWithSchema struct) {
        return Values.value((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])struct.schema().fields()).map((Function1)new Serializable(struct){
            public static final long serialVersionUID = 0L;
            private final GenericRowWithSchema struct$1;

            public final Tuple2<String, Object> apply(StructField f) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name()), Neo4jUtil$.MODULE$.convertFromSpark(this.struct$1.getAs(f.name()), f));
            }
            {
                this.struct$1 = struct$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms())).asJava());
    }

    private Neo4jUtil$() {
        MODULE$ = this;
        this.NODE_ALIAS = "n";
        this.INTERNAL_ID_FIELD = "<id>";
        this.INTERNAL_LABELS_FIELD = "<labels>";
        this.INTERNAL_REL_ID_FIELD = "<rel.id>";
        this.INTERNAL_REL_TYPE_FIELD = "<rel.type>";
        this.RELATIONSHIP_SOURCE_ALIAS = "source";
        this.RELATIONSHIP_TARGET_ALIAS = "target";
        this.INTERNAL_REL_SOURCE_ID_FIELD = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<", ".id>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.RELATIONSHIP_SOURCE_ALIAS()}));
        this.INTERNAL_REL_TARGET_ID_FIELD = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<", ".id>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.RELATIONSHIP_TARGET_ALIAS()}));
        this.RELATIONSHIP_ALIAS = "rel";
        this.properties = new Properties();
        this.properties().load(Thread.currentThread().getContextClassLoader().getResourceAsStream("neo4j-spark-connector.properties"));
        this.mapper = new ObjectMapper();
        this.module = new SimpleModule("Neo4jApocSerializer");
        this.module().addSerializer(Path.class, (JsonSerializer)new JsonSerializer<Path>(){

            public void serialize(Path path, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
                jsonGenerator.writeString(path.toString());
            }
        });
        this.module().addSerializer(Entity.class, (JsonSerializer)new JsonSerializer<Entity>(){

            public void serialize(Entity entity, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
                jsonGenerator.writeObject(Neo4jImplicits$.MODULE$.EntityImplicits(entity).toMap());
            }
        });
        this.mapper().registerModule((Module)this.module());
    }
}

