/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.spark;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.MicroBatchReadSupport;
import org.apache.spark.sql.sources.v2.ReadSupport;
import org.apache.spark.sql.sources.v2.StreamWriteSupport;
import org.apache.spark.sql.sources.v2.WriteSupport;
import org.apache.spark.sql.sources.v2.reader.DataSourceReader;
import org.apache.spark.sql.sources.v2.reader.streaming.MicroBatchReader;
import org.apache.spark.sql.sources.v2.writer.DataSourceWriter;
import org.apache.spark.sql.sources.v2.writer.streaming.StreamWriter;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.StructType;
import org.neo4j.spark.reader.Neo4jDataSourceReader;
import org.neo4j.spark.reader.Neo4jDataSourceReader$;
import org.neo4j.spark.streaming.Neo4jDataSourceStreamWriter;
import org.neo4j.spark.streaming.Neo4jMicroBatchReader;
import org.neo4j.spark.util.Neo4jOptions$;
import org.neo4j.spark.util.StorageType$;
import org.neo4j.spark.util.ValidateSaveMode;
import org.neo4j.spark.util.ValidateSparkVersion;
import org.neo4j.spark.util.Validation;
import org.neo4j.spark.util.Validations$;
import org.neo4j.spark.writer.Neo4jDataSourceWriter;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001B\u0001\u0003\u0001%\u0011!\u0002R1uCN{WO]2f\u0015\t\u0019A!A\u0003ta\u0006\u00148N\u0003\u0002\u0006\r\u0005)a.Z85U*\tq!A\u0002pe\u001e\u001c\u0001aE\u0005\u0001\u0015Iy\"%\n\u0015-_A\u00111\u0002E\u0007\u0002\u0019)\u0011QBD\u0001\u0005Y\u0006twMC\u0001\u0010\u0003\u0011Q\u0017M^1\n\u0005Ea!AB(cU\u0016\u001cG\u000f\u0005\u0002\u0014;5\tAC\u0003\u0002\u0016-\u0005\u0011aO\r\u0006\u0003/a\tqa]8ve\u000e,7O\u0003\u0002\u001a5\u0005\u00191/\u001d7\u000b\u0005\rY\"B\u0001\u000f\u0007\u0003\u0019\t\u0007/Y2iK&\u0011a\u0004\u0006\u0002\r\t\u0006$\u0018mU8ve\u000e,gK\r\t\u0003'\u0001J!!\t\u000b\u0003%M#(/Z1n/JLG/Z*vaB|'\u000f\u001e\t\u0003'\rJ!\u0001\n\u000b\u0003+5K7M]8CCR\u001c\u0007NU3bIN+\b\u000f]8siB\u00111CJ\u0005\u0003OQ\u00111BU3bIN+\b\u000f]8siB\u0011\u0011FK\u0007\u0002-%\u00111F\u0006\u0002\u0013\t\u0006$\u0018mU8ve\u000e,'+Z4jgR,'\u000f\u0005\u0002\u0014[%\u0011a\u0006\u0006\u0002\r/JLG/Z*vaB|'\u000f\u001e\t\u0003aMj\u0011!\r\u0006\u0003ei\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003iE\u0012q\u0001T8hO&tw\rC\u00037\u0001\u0011\u0005q'\u0001\u0004=S:LGO\u0010\u000b\u0002qA\u0011\u0011\bA\u0007\u0002\u0005!91\b\u0001b\u0001\n\u0013a\u0014!\u00026pE&#W#A\u001f\u0011\u0005y\"eBA C\u001b\u0005\u0001%\"A!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0003\u0015A\u0002)sK\u0012,g-\u0003\u0002F\r\n11\u000b\u001e:j]\u001eT!a\u0011!\t\r!\u0003\u0001\u0015!\u0003>\u0003\u0019QwNY%eA!)!\n\u0001C\u0001\u0017\u0006a1M]3bi\u0016\u0014V-\u00193feR\u0011AJ\u0015\t\u0003\u001bBk\u0011A\u0014\u0006\u0003\u001f\n\taA]3bI\u0016\u0014\u0018BA)O\u0005UqUm\u001c\u001bk\t\u0006$\u0018mU8ve\u000e,'+Z1eKJDQaU%A\u0002Q\u000bqa\u001c9uS>t7\u000f\u0005\u0002\u0014+&\u0011a\u000b\u0006\u0002\u0012\t\u0006$\u0018mU8ve\u000e,w\n\u001d;j_:\u001c\b\"\u0002&\u0001\t\u0003BFcA-_MB\u0011!\fX\u0007\u00027*\u0011q\nF\u0005\u0003;n\u0013\u0001\u0003R1uCN{WO]2f%\u0016\fG-\u001a:\t\u000b};\u0006\u0019\u00011\u0002\rM\u001c\u0007.Z7b!\t\tG-D\u0001c\u0015\t\u0019\u0007$A\u0003usB,7/\u0003\u0002fE\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000bM;\u0006\u0019\u0001+\t\u000b!\u0004A\u0011I5\u0002\u0013MDwN\u001d;OC6,G#A\u001f\t\u000b-\u0004A\u0011\t7\u0002\u0019\r\u0014X-\u0019;f/JLG/\u001a:\u0015\r5L(\u0010`A\u0003!\rq\u0017o]\u0007\u0002_*\u0011\u0001OD\u0001\u0005kRLG.\u0003\u0002s_\nAq\n\u001d;j_:\fG\u000e\u0005\u0002uo6\tQO\u0003\u0002w)\u00051qO]5uKJL!\u0001_;\u0003!\u0011\u000bG/Y*pkJ\u001cWm\u0016:ji\u0016\u0014\b\"B\u001ek\u0001\u0004i\u0004\"B>k\u0001\u0004\u0001\u0017AC:ueV\u001cG\u000fV=qK\")QP\u001ba\u0001}\u0006A1/\u0019<f\u001b>$W\rE\u0002\u0000\u0003\u0003i\u0011\u0001G\u0005\u0004\u0003\u0007A\"\u0001C*bm\u0016lu\u000eZ3\t\u000bMS\u0007\u0019\u0001+\t\u0013\u0005%\u0001\u00011A\u0005\n\u0005-\u0011\u0001D:ue\u0016\fWn\u0016:ji\u0016\u0014XCAA\u0007!\u0011\ty!!\u0006\u000e\u0005\u0005E!bAA\n\u0005\u0005I1\u000f\u001e:fC6LgnZ\u0005\u0005\u0003/\t\tBA\u000eOK>$$\u000eR1uCN{WO]2f'R\u0014X-Y7Xe&$XM\u001d\u0005\n\u00037\u0001\u0001\u0019!C\u0005\u0003;\t\u0001c\u001d;sK\u0006lwK]5uKJ|F%Z9\u0015\t\u0005}\u0011Q\u0005\t\u0004\u007f\u0005\u0005\u0012bAA\u0012\u0001\n!QK\\5u\u0011)\t9#!\u0007\u0002\u0002\u0003\u0007\u0011QB\u0001\u0004q\u0012\n\u0004\u0002CA\u0016\u0001\u0001\u0006K!!\u0004\u0002\u001bM$(/Z1n/JLG/\u001a:!Q\u0011\tI#a\f\u0011\u0007}\n\t$C\u0002\u00024\u0001\u0013\u0001B^8mCRLG.\u001a\u0005\b\u0003o\u0001A\u0011AA\u001d\u00035I7OT3x\u0013:\u001cH/\u00198dKRA\u00111HA!\u0003\u000b\n9\u0005E\u0002@\u0003{I1!a\u0010A\u0005\u001d\u0011un\u001c7fC:Dq!a\u0011\u00026\u0001\u0007Q(A\u0004rk\u0016\u0014\u00180\u00133\t\r}\u000b)\u00041\u0001a\u0011\u0019\u0019\u0016Q\u0007a\u0001)\"9\u00111\n\u0001\u0005B\u00055\u0013AE2sK\u0006$Xm\u0015;sK\u0006lwK]5uKJ$\"\"a\u0014\u0002Z\u0005m\u0013QLA6!\u0011\t\t&!\u0016\u000e\u0005\u0005M#bAA\nk&!\u0011qKA*\u00051\u0019FO]3b[^\u0013\u0018\u000e^3s\u0011\u001d\t\u0019%!\u0013A\u0002uBaaXA%\u0001\u0004\u0001\u0007\u0002CA0\u0003\u0013\u0002\r!!\u0019\u0002\t5|G-\u001a\t\u0005\u0003G\n9'\u0004\u0002\u0002f)\u0019\u00111\u0003\r\n\t\u0005%\u0014Q\r\u0002\u000b\u001fV$\b/\u001e;N_\u0012,\u0007BB*\u0002J\u0001\u0007A\u000bC\u0004\u0002p\u0001!\t%!\u001d\u0002-\r\u0014X-\u0019;f\u001b&\u001c'o\u001c\"bi\u000eD'+Z1eKJ$\u0002\"a\u001d\u0002~\u0005\u0005\u0015Q\u0011\t\u0005\u0003k\nI(\u0004\u0002\u0002x)\u0019\u00111C.\n\t\u0005m\u0014q\u000f\u0002\u0011\u001b&\u001c'o\u001c\"bi\u000eD'+Z1eKJDqaXA7\u0001\u0004\ty\bE\u0002oc\u0002Dq!a!\u0002n\u0001\u0007Q(\u0001\ndQ\u0016\u001c7\u000e]8j]RdunY1uS>t\u0007BB*\u0002n\u0001\u0007A\u000b")
public class DataSource
implements StreamWriteSupport,
MicroBatchReadSupport,
ReadSupport,
DataSourceRegister,
WriteSupport,
Logging {
    private final String jobId;
    private volatile Neo4jDataSourceStreamWriter streamWriter;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private String jobId() {
        return this.jobId;
    }

    public Neo4jDataSourceReader createReader(DataSourceOptions options) {
        return new Neo4jDataSourceReader(options, this.jobId(), Neo4jDataSourceReader$.MODULE$.$lessinit$greater$default$3());
    }

    public DataSourceReader createReader(StructType schema, DataSourceOptions options) {
        return new Neo4jDataSourceReader(options, this.jobId(), schema);
    }

    public String shortName() {
        return "neo4j";
    }

    public Optional<DataSourceWriter> createWriter(String jobId, StructType structType, SaveMode saveMode, DataSourceOptions options) {
        Validations$.MODULE$.validate((Seq<Validation>)Predef$.MODULE$.wrapRefArray((Object[])new Validation[]{new ValidateSaveMode(saveMode.toString())}));
        return Optional.of(new Neo4jDataSourceWriter(jobId, structType, saveMode, options));
    }

    private Neo4jDataSourceStreamWriter streamWriter() {
        return this.streamWriter;
    }

    private void streamWriter_$eq(Neo4jDataSourceStreamWriter x$1) {
        this.streamWriter = x$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isNewInstance(String queryId, StructType schema, DataSourceOptions options) {
        if (this.streamWriter() == null) return true;
        String string = this.streamWriter().queryId();
        String string2 = queryId;
        if (string == null) {
            if (string2 != null) {
                return true;
            }
        } else if (!string.equals(string2)) return true;
        StructType structType = this.streamWriter().schema();
        StructType structType2 = schema;
        if (structType == null) {
            if (structType2 != null) {
                return true;
            }
        } else if (!structType.equals(structType2)) return true;
        DataSourceOptions dataSourceOptions = this.streamWriter().options();
        DataSourceOptions dataSourceOptions2 = options;
        if (dataSourceOptions == null) {
            if (dataSourceOptions2 == null) return false;
            return true;
        } else {
            if (!dataSourceOptions.equals(dataSourceOptions2)) return true;
            return false;
        }
    }

    public StreamWriter createStreamWriter(String queryId, StructType schema, OutputMode mode, DataSourceOptions options) {
        String streamingSaveMode = options.get(Neo4jOptions$.MODULE$.SAVE_MODE()).orElse(Neo4jOptions$.MODULE$.DEFAULT_SAVE_MODE().toString());
        Validations$.MODULE$.validate((Seq<Validation>)Predef$.MODULE$.wrapRefArray((Object[])new Validation[]{new ValidateSaveMode(streamingSaveMode)}));
        if (this.isNewInstance(queryId, schema, options)) {
            this.streamWriter_$eq(new Neo4jDataSourceStreamWriter(queryId, schema, options, SaveMode.valueOf((String)streamingSaveMode)));
        }
        return this.streamWriter();
    }

    public MicroBatchReader createMicroBatchReader(Optional<StructType> schema, String checkpointLocation, DataSourceOptions options) {
        Map optsMap = options.asMap();
        optsMap.put(Neo4jOptions$.MODULE$.STREAMING_METADATA_STORAGE(), StorageType$.MODULE$.NEO4J().toString());
        DataSourceOptions newOpts = new DataSourceOptions(optsMap);
        return new Neo4jMicroBatchReader(schema, newOpts, this.jobId());
    }

    public DataSource() {
        Logging.class.$init$((Logging)this);
        Validations$.MODULE$.validate((Seq<Validation>)Predef$.MODULE$.wrapRefArray((Object[])new Validation[]{new ValidateSparkVersion((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2.4.*"}))}));
        this.jobId = UUID.randomUUID().toString();
        this.streamWriter = null;
    }
}

