/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.types;

import org.neo4j.driver.Value;
import org.neo4j.driver.internal.types.TypeConstructor;
import org.neo4j.driver.types.Type;

public class TypeRepresentation
implements Type {
    private final TypeConstructor tyCon;

    public TypeRepresentation(TypeConstructor tyCon) {
        this.tyCon = tyCon;
    }

    @Override
    public boolean isTypeOf(Value value2) {
        return this.tyCon.covers(value2);
    }

    @Override
    public String name() {
        if (this.tyCon == TypeConstructor.LIST) {
            return "LIST OF ANY?";
        }
        return this.tyCon.toString();
    }

    public TypeConstructor constructor() {
        return this.tyCon;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeRepresentation that = (TypeRepresentation)o;
        return this.tyCon == that.tyCon;
    }

    public int hashCode() {
        return this.tyCon.hashCode();
    }
}

