/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.summary;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.neo4j.driver.Query;
import org.neo4j.driver.internal.summary.InternalSummaryCounters;
import org.neo4j.driver.summary.DatabaseInfo;
import org.neo4j.driver.summary.Notification;
import org.neo4j.driver.summary.Plan;
import org.neo4j.driver.summary.ProfiledPlan;
import org.neo4j.driver.summary.QueryType;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.summary.ServerInfo;
import org.neo4j.driver.summary.SummaryCounters;

public class InternalResultSummary
implements ResultSummary {
    private final Query query;
    private final ServerInfo serverInfo;
    private final QueryType queryType;
    private final SummaryCounters counters;
    private final Plan plan;
    private final ProfiledPlan profile;
    private final List<Notification> notifications;
    private final long resultAvailableAfter;
    private final long resultConsumedAfter;
    private final DatabaseInfo databaseInfo;

    public InternalResultSummary(Query query2, ServerInfo serverInfo, DatabaseInfo databaseInfo, QueryType queryType, SummaryCounters counters, Plan plan, ProfiledPlan profile, List<Notification> notifications, long resultAvailableAfter, long resultConsumedAfter) {
        this.query = query2;
        this.serverInfo = serverInfo;
        this.databaseInfo = databaseInfo;
        this.queryType = queryType;
        this.counters = counters;
        this.plan = InternalResultSummary.resolvePlan(plan, profile);
        this.profile = profile;
        this.notifications = notifications;
        this.resultAvailableAfter = resultAvailableAfter;
        this.resultConsumedAfter = resultConsumedAfter;
    }

    @Override
    public Query query() {
        return this.query;
    }

    @Override
    public SummaryCounters counters() {
        return this.counters == null ? InternalSummaryCounters.EMPTY_STATS : this.counters;
    }

    @Override
    public QueryType queryType() {
        return this.queryType;
    }

    @Override
    public boolean hasPlan() {
        return this.plan != null;
    }

    @Override
    public boolean hasProfile() {
        return this.profile != null;
    }

    @Override
    public Plan plan() {
        return this.plan;
    }

    @Override
    public ProfiledPlan profile() {
        return this.profile;
    }

    @Override
    public List<Notification> notifications() {
        return this.notifications == null ? Collections.emptyList() : this.notifications;
    }

    @Override
    public long resultAvailableAfter(TimeUnit unit) {
        return this.resultAvailableAfter == -1L ? this.resultAvailableAfter : unit.convert(this.resultAvailableAfter, TimeUnit.MILLISECONDS);
    }

    @Override
    public long resultConsumedAfter(TimeUnit unit) {
        return this.resultConsumedAfter == -1L ? this.resultConsumedAfter : unit.convert(this.resultConsumedAfter, TimeUnit.MILLISECONDS);
    }

    @Override
    public ServerInfo server() {
        return this.serverInfo;
    }

    @Override
    public DatabaseInfo database() {
        return this.databaseInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalResultSummary that = (InternalResultSummary)o;
        return this.resultAvailableAfter == that.resultAvailableAfter && this.resultConsumedAfter == that.resultConsumedAfter && Objects.equals(this.query, that.query) && Objects.equals(this.serverInfo, that.serverInfo) && this.queryType == that.queryType && Objects.equals(this.counters, that.counters) && Objects.equals(this.plan, that.plan) && Objects.equals(this.profile, that.profile) && Objects.equals(this.notifications, that.notifications);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.query, this.serverInfo, this.queryType, this.counters, this.plan, this.profile, this.notifications, this.resultAvailableAfter, this.resultConsumedAfter});
    }

    public String toString() {
        return "InternalResultSummary{query=" + this.query + ", serverInfo=" + this.serverInfo + ", databaseInfo=" + this.databaseInfo + ", queryType=" + (Object)((Object)this.queryType) + ", counters=" + this.counters + ", plan=" + this.plan + ", profile=" + this.profile + ", notifications=" + this.notifications + ", resultAvailableAfter=" + this.resultAvailableAfter + ", resultConsumedAfter=" + this.resultConsumedAfter + '}';
    }

    private static Plan resolvePlan(Plan plan, ProfiledPlan profiledPlan) {
        return plan == null ? profiledPlan : plan;
    }
}

