/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import org.neo4j.driver.Query;
import org.neo4j.driver.internal.BookmarkHolder;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.handlers.LegacyPullAllResponseHandler;
import org.neo4j.driver.internal.handlers.PullAllResponseHandler;
import org.neo4j.driver.internal.handlers.PullResponseCompletionListener;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.handlers.SessionPullResponseCompletionListener;
import org.neo4j.driver.internal.handlers.TransactionPullResponseCompletionListener;
import org.neo4j.driver.internal.handlers.pulln.AutoPullResponseHandler;
import org.neo4j.driver.internal.handlers.pulln.BasicPullResponseHandler;
import org.neo4j.driver.internal.handlers.pulln.PullResponseHandler;
import org.neo4j.driver.internal.messaging.v3.BoltProtocolV3;
import org.neo4j.driver.internal.spi.Connection;

public class PullHandlers {
    public static PullAllResponseHandler newBoltV3PullAllHandler(Query query2, RunResponseHandler runHandler, Connection connection, BookmarkHolder bookmarkHolder, UnmanagedTransaction tx) {
        PullResponseCompletionListener completionListener = PullHandlers.createPullResponseCompletionListener(connection, bookmarkHolder, tx);
        return new LegacyPullAllResponseHandler(query2, runHandler, connection, BoltProtocolV3.METADATA_EXTRACTOR, completionListener);
    }

    public static PullAllResponseHandler newBoltV4AutoPullHandler(Query query2, RunResponseHandler runHandler, Connection connection, BookmarkHolder bookmarkHolder, UnmanagedTransaction tx, long fetchSize) {
        PullResponseCompletionListener completionListener = PullHandlers.createPullResponseCompletionListener(connection, bookmarkHolder, tx);
        return new AutoPullResponseHandler(query2, runHandler, connection, BoltProtocolV3.METADATA_EXTRACTOR, completionListener, fetchSize);
    }

    public static PullResponseHandler newBoltV4BasicPullHandler(Query query2, RunResponseHandler runHandler, Connection connection, BookmarkHolder bookmarkHolder, UnmanagedTransaction tx) {
        PullResponseCompletionListener completionListener = PullHandlers.createPullResponseCompletionListener(connection, bookmarkHolder, tx);
        return new BasicPullResponseHandler(query2, runHandler, connection, BoltProtocolV3.METADATA_EXTRACTOR, completionListener);
    }

    private static PullResponseCompletionListener createPullResponseCompletionListener(Connection connection, BookmarkHolder bookmarkHolder, UnmanagedTransaction tx) {
        return tx != null ? new TransactionPullResponseCompletionListener(tx) : new SessionPullResponseCompletionListener(connection, bookmarkHolder);
    }
}

