/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.async.AsyncTransaction;
import org.neo4j.driver.async.AsyncTransactionWork;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.internal.async.AsyncAbstractQueryRunner;
import org.neo4j.driver.internal.async.InternalAsyncTransaction;
import org.neo4j.driver.internal.async.NetworkSession;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.util.Futures;

public class InternalAsyncSession
extends AsyncAbstractQueryRunner
implements AsyncSession {
    private final NetworkSession session;

    public InternalAsyncSession(NetworkSession session) {
        this.session = session;
    }

    @Override
    public CompletionStage<ResultCursor> runAsync(Query query2) {
        return this.runAsync(query2, TransactionConfig.empty());
    }

    @Override
    public CompletionStage<ResultCursor> runAsync(String query2, TransactionConfig config) {
        return this.runAsync(query2, Collections.emptyMap(), config);
    }

    @Override
    public CompletionStage<ResultCursor> runAsync(String query2, Map<String, Object> parameters, TransactionConfig config) {
        return this.runAsync(new Query(query2, parameters), config);
    }

    @Override
    public CompletionStage<ResultCursor> runAsync(Query query2, TransactionConfig config) {
        return this.session.runAsync(query2, config);
    }

    @Override
    public CompletionStage<Void> closeAsync() {
        return this.session.closeAsync();
    }

    @Override
    public CompletionStage<AsyncTransaction> beginTransactionAsync() {
        return this.beginTransactionAsync(TransactionConfig.empty());
    }

    @Override
    public CompletionStage<AsyncTransaction> beginTransactionAsync(TransactionConfig config) {
        return this.session.beginTransactionAsync(config).thenApply(InternalAsyncTransaction::new);
    }

    @Override
    public <T> CompletionStage<T> readTransactionAsync(AsyncTransactionWork<CompletionStage<T>> work) {
        return this.readTransactionAsync(work, TransactionConfig.empty());
    }

    @Override
    public <T> CompletionStage<T> readTransactionAsync(AsyncTransactionWork<CompletionStage<T>> work, TransactionConfig config) {
        return this.transactionAsync(AccessMode.READ, work, config);
    }

    @Override
    public <T> CompletionStage<T> writeTransactionAsync(AsyncTransactionWork<CompletionStage<T>> work) {
        return this.writeTransactionAsync(work, TransactionConfig.empty());
    }

    @Override
    public <T> CompletionStage<T> writeTransactionAsync(AsyncTransactionWork<CompletionStage<T>> work, TransactionConfig config) {
        return this.transactionAsync(AccessMode.WRITE, work, config);
    }

    @Override
    public Bookmark lastBookmark() {
        return this.session.lastBookmark();
    }

    private <T> CompletionStage<T> transactionAsync(AccessMode mode, AsyncTransactionWork<CompletionStage<T>> work, TransactionConfig config) {
        return this.session.retryLogic().retryAsync(() -> {
            CompletableFuture resultFuture = new CompletableFuture();
            CompletionStage<UnmanagedTransaction> txFuture = this.session.beginTransactionAsync(mode, config);
            txFuture.whenComplete((tx, completionError) -> {
                Throwable error = Futures.completionExceptionCause(completionError);
                if (error != null) {
                    resultFuture.completeExceptionally(error);
                } else {
                    this.executeWork(resultFuture, (UnmanagedTransaction)tx, work);
                }
            });
            return resultFuture;
        });
    }

    private <T> void executeWork(CompletableFuture<T> resultFuture, UnmanagedTransaction tx, AsyncTransactionWork<CompletionStage<T>> work) {
        CompletionStage<Object> workFuture = this.safeExecuteWork(tx, work);
        workFuture.whenComplete((result, completionError) -> {
            Throwable error = Futures.completionExceptionCause(completionError);
            if (error != null) {
                this.rollbackTxAfterFailedTransactionWork(tx, resultFuture, error);
            } else {
                this.closeTxAfterSucceededTransactionWork(tx, resultFuture, result);
            }
        });
    }

    private <T> CompletionStage<T> safeExecuteWork(UnmanagedTransaction tx, AsyncTransactionWork<CompletionStage<T>> work) {
        try {
            CompletionStage<T> result = work.execute(new InternalAsyncTransaction(tx));
            return result == null ? Futures.completedWithNull() : result;
        }
        catch (Throwable workError) {
            return Futures.failedFuture(workError);
        }
    }

    private <T> void rollbackTxAfterFailedTransactionWork(UnmanagedTransaction tx, CompletableFuture<T> resultFuture, Throwable error) {
        if (tx.isOpen()) {
            tx.rollbackAsync().whenComplete((ignore, rollbackError) -> {
                if (rollbackError != null) {
                    error.addSuppressed((Throwable)rollbackError);
                }
                resultFuture.completeExceptionally(error);
            });
        } else {
            resultFuture.completeExceptionally(error);
        }
    }

    private <T> void closeTxAfterSucceededTransactionWork(UnmanagedTransaction tx, CompletableFuture<T> resultFuture, T result) {
        if (tx.isOpen()) {
            tx.commitAsync().whenComplete((ignore, completionError) -> {
                Throwable commitError = Futures.completionExceptionCause(completionError);
                if (commitError != null) {
                    resultFuture.completeExceptionally(commitError);
                } else {
                    resultFuture.complete(result);
                }
            });
        } else {
            resultFuture.complete(result);
        }
    }
}

