/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import org.neo4j.driver.Query;
import org.neo4j.driver.Result;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.internal.AbstractQueryRunner;
import org.neo4j.driver.internal.InternalResult;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.util.Futures;

public class InternalTransaction
extends AbstractQueryRunner
implements Transaction {
    private final UnmanagedTransaction tx;

    public InternalTransaction(UnmanagedTransaction tx) {
        this.tx = tx;
    }

    @Override
    public void commit() {
        Futures.blockingGet(this.tx.commitAsync(), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while committing the transaction"));
    }

    @Override
    public void rollback() {
        Futures.blockingGet(this.tx.rollbackAsync(), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while rolling back the transaction"));
    }

    @Override
    public void close() {
        Futures.blockingGet(this.tx.closeAsync(), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while closing the transaction"));
    }

    @Override
    public Result run(Query query2) {
        ResultCursor cursor = Futures.blockingGet(this.tx.runAsync(query2), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while running query in transaction"));
        return new InternalResult(this.tx.connection(), cursor);
    }

    @Override
    public boolean isOpen() {
        return this.tx.isOpen();
    }

    private void terminateConnectionOnThreadInterrupt(String reason) {
        this.tx.connection().terminateAndRelease(reason);
    }
}

